/*
 * Decompiled with CFR 0.152.
 */
package com.solace.labs.spring.boot.autoconfigure;

import com.solace.labs.spring.boot.autoconfigure.SolaceJavaProperties;
import com.solacesystems.jcsmp.JCSMPProperties;
import com.solacesystems.jcsmp.SpringJCSMPFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jms.JmsAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={JmsAutoConfiguration.class})
@ConditionalOnClass(value={JCSMPProperties.class})
@ConditionalOnMissingBean(value={SpringJCSMPFactory.class})
@EnableConfigurationProperties(value={SolaceJavaProperties.class})
public class SolaceJavaAutoConfiguration {
    @Autowired
    private SolaceJavaProperties properties;

    @Bean
    public SpringJCSMPFactory connectionFactory() {
        JCSMPProperties jcsmpProps = new JCSMPProperties();
        jcsmpProps.setProperty("host", (Object)this.properties.getHost());
        jcsmpProps.setProperty("vpn_name", (Object)this.properties.getMsgVpn());
        jcsmpProps.setProperty("username", (Object)this.properties.getClientUsername());
        jcsmpProps.setProperty("password", (Object)this.properties.getClientPassword());
        if (this.properties.getClientName() != null && !this.properties.getClientName().isEmpty()) {
            jcsmpProps.setProperty("client_name", (Object)this.properties.getClientName());
        }
        SpringJCSMPFactory cf = new SpringJCSMPFactory(jcsmpProps);
        return cf;
    }
}

