/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.trace.propagation.internal;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.propagation.BaggageUtil;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.api.trace.propagation.internal.W3CTraceContextEncoding;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassLoaderReflectionUtil {
    private static final Logger logger;
    private static final ClassLoader threadContextClassLoader;
    private static final ClassLoader classloader;
    private static final Class MESSAGE_TRACING_SUPPORT_CLASS;
    private static final Class MESSAGE_TRACE_CONTEXT_SETTER_CLASS;
    private static final Class TRACING_CONTEXT_CLASS;
    private static final Class BAGGAGE_CLASS;
    private static final Method SET_TRACING_ID_BYTES_16_METHOD;
    private static final Method SET_SPAN_ID_BYTES_8_METHOD;
    private static final Method SET_SAMPLED_METHOD;
    private static final Method SET_TRACE_STATE_METHOD;
    private static final Method SET_BAGGAGE_METHOD;
    private static final Method GET_TRACING_ID_BYTES_METHOD;
    private static final Method GET_SPAN_ID_BYTES_METHOD;
    private static final Method IS_SAMPLED_METHOD;
    private static final Method GET_TRACE_STATE_METHOD;
    private static final Method GET_BAGGAGE_METHOD;
    private static final boolean IS_TRACING_CONTEXT_API_VALID;
    private static final String VERSION = "00";
    private static final int VERSION_SIZE = 2;
    private static final char TRACEPARENT_DELIMITER = '-';
    private static final int TRACEPARENT_DELIMITER_SIZE = 1;
    private static final int TRACE_ID_HEX_SIZE;
    private static final int SPAN_ID_HEX_SIZE;
    private static final int TRACE_OPTION_HEX_SIZE;
    private static final int TRACE_ID_OFFSET = 3;
    private static final int SPAN_ID_OFFSET;
    private static final int TRACE_OPTION_OFFSET;
    private static final int TRACEPARENT_HEADER_SIZE;
    private static final String SAMPLED_HEX;
    private static final String DEFAULT_HEX;
    public static final char[] HEX_ARRAY;

    public static String byteToHex(byte b) {
        char[] hexChars = new char[2];
        int v = b & 0xFF;
        hexChars[0] = HEX_ARRAY[v >>> 4];
        hexChars[1] = HEX_ARRAY[v & 0xF];
        return new String(hexChars);
    }

    private ClassLoaderReflectionUtil() {
    }

    public static Object getSolMessageWithTracingSupport(Object m) {
        if (m == null) {
            return null;
        }
        Class<?> oClass = m.getClass();
        Class tracingSupportInterface = MESSAGE_TRACING_SUPPORT_CLASS;
        if (tracingSupportInterface != null && tracingSupportInterface.isAssignableFrom(oClass)) {
            return m;
        }
        return null;
    }

    static Object getTraceContextSetterHolder(Object intoMessageWithTracingSupport) {
        try {
            Method messageMethod = MESSAGE_TRACING_SUPPORT_CLASS.getMethod("contextSetter", new Class[0]);
            return messageMethod.invoke(intoMessageWithTracingSupport, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.log(Level.WARNING, "Failed to retrieve TraceContextSetter pointer", e);
            return null;
        }
    }

    static Object getTransportContextHolder(Object intoMessageWithTracingSupport) {
        try {
            Method messageMethod = MESSAGE_TRACING_SUPPORT_CLASS.getMethod("transportContext", new Class[0]);
            return messageMethod.invoke(intoMessageWithTracingSupport, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.log(Level.WARNING, "Failed to retrieve transport TracingContext pointer", e);
            return null;
        }
    }

    static Object getMessageCreationContextHolder(Object intoMessageWithTracingSupport) {
        try {
            Method messageMethod = MESSAGE_TRACING_SUPPORT_CLASS.getMethod("creationContext", new Class[0]);
            return messageMethod.invoke(intoMessageWithTracingSupport, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.log(Level.WARNING, "Failed to retrieve creation TracingContext pointer", e);
            return null;
        }
    }

    static Object getBaggageHolder(Object intoMessageWithTracingSupport) {
        try {
            Method messageMethod = MESSAGE_TRACING_SUPPORT_CLASS.getMethod("baggage", new Class[0]);
            return messageMethod.invoke(intoMessageWithTracingSupport, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.log(Level.WARNING, "Failed to retrieve creation Baggage pointer", e);
            return null;
        }
    }

    public static void injectSpanContext(Object intoMessageWithTracingSupport, SpanContext toInject) throws Exception {
        if (intoMessageWithTracingSupport == null || toInject == null || !IS_TRACING_CONTEXT_API_VALID) {
            return;
        }
        Object traceContextSetter = ClassLoaderReflectionUtil.getTraceContextSetterHolder(intoMessageWithTracingSupport);
        if (traceContextSetter == null) {
            logger.log(Level.WARNING, "Context injection failed, trace context setter null");
            return;
        }
        byte[] traceId = toInject.getTraceIdBytes();
        byte[] spanId = toInject.getSpanIdBytes();
        boolean sampled = toInject.isSampled();
        SET_TRACING_ID_BYTES_16_METHOD.invoke(traceContextSetter, new Object[]{traceId});
        SET_SPAN_ID_BYTES_8_METHOD.invoke(traceContextSetter, new Object[]{spanId});
        SET_SAMPLED_METHOD.invoke(traceContextSetter, sampled);
    }

    public static void injectTraceState(Object intoMessageWithTracingSupport, TraceState toInject) throws Exception {
        if (intoMessageWithTracingSupport == null || toInject == null) {
            return;
        }
        String encodedTraceState = W3CTraceContextEncoding.encodeTraceState((TraceState)toInject);
        ClassLoaderReflectionUtil.injectTraceState(intoMessageWithTracingSupport, encodedTraceState);
    }

    public static void injectBaggage(Object intoMessageWithTracingSupport, Baggage toInject) throws Exception {
        if (intoMessageWithTracingSupport == null || toInject == null) {
            return;
        }
        String encodedBaggage = BaggageUtil.baggageToString(toInject);
        ClassLoaderReflectionUtil.injectBaggage(intoMessageWithTracingSupport, encodedBaggage);
    }

    private static void injectTraceState(Object intoMessageWithTracingSupport, String traceStateAsString) throws Exception {
        if (!IS_TRACING_CONTEXT_API_VALID) {
            return;
        }
        if (intoMessageWithTracingSupport == null || traceStateAsString == null || traceStateAsString.isEmpty()) {
            return;
        }
        Object traceContextSetter = ClassLoaderReflectionUtil.getTraceContextSetterHolder(intoMessageWithTracingSupport);
        if (traceContextSetter == null) {
            logger.log(Level.WARNING, "TraceState injection failed, trace context setter null");
            return;
        }
        SET_TRACE_STATE_METHOD.invoke(traceContextSetter, traceStateAsString);
    }

    private static void injectBaggage(Object intoMessageWithTracingSupport, String baggageAsString) throws Exception {
        if (!IS_TRACING_CONTEXT_API_VALID) {
            return;
        }
        if (intoMessageWithTracingSupport == null || baggageAsString == null || baggageAsString.isEmpty()) {
            return;
        }
        Object baggageHolder = ClassLoaderReflectionUtil.getBaggageHolder(intoMessageWithTracingSupport);
        if (baggageHolder == null) {
            return;
        }
        SET_BAGGAGE_METHOD.invoke(baggageHolder, baggageAsString);
    }

    public static String getTraceParentAsString(Object fromMessageWithTracingSupport) {
        if (!IS_TRACING_CONTEXT_API_VALID || fromMessageWithTracingSupport == null) {
            return null;
        }
        Object transportContext = ClassLoaderReflectionUtil.getTransportContextHolder(fromMessageWithTracingSupport);
        String transportContextAsStr = ClassLoaderReflectionUtil.contextAsString(transportContext);
        if (transportContextAsStr != null && !transportContextAsStr.isEmpty()) {
            return transportContextAsStr;
        }
        Object creationContext = ClassLoaderReflectionUtil.getMessageCreationContextHolder(fromMessageWithTracingSupport);
        String creationContextAsStr = ClassLoaderReflectionUtil.contextAsString(creationContext);
        if (creationContextAsStr != null && !creationContextAsStr.isEmpty()) {
            return creationContextAsStr;
        }
        logger.log(Level.FINEST, "Transport and creation context not present");
        return null;
    }

    public static String getTraceStateAsString(Object intoMessageWithTracingSupport) {
        String s;
        if (!IS_TRACING_CONTEXT_API_VALID) {
            return null;
        }
        Object transportContext = ClassLoaderReflectionUtil.getTransportContextHolder(intoMessageWithTracingSupport);
        Object creationContext = ClassLoaderReflectionUtil.getMessageCreationContextHolder(intoMessageWithTracingSupport);
        if (transportContext == null && creationContext == null) {
            logger.log(Level.FINEST, "Transport and creation context not present");
            return null;
        }
        String traceState = null;
        if (transportContext != null) {
            try {
                Object transportTraceStateString = GET_TRACE_STATE_METHOD.invoke(transportContext, new Object[0]);
                s = (String)transportTraceStateString;
                if (s != null && !s.isEmpty()) {
                    traceState = s;
                } else {
                    logger.log(Level.FINEST, "No trace state in transport context");
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                logger.log(Level.WARNING, "Failed retrieve trace state as string from transport context", e);
            }
        }
        if (creationContext != null) {
            try {
                Object creationTraceStateString = GET_TRACE_STATE_METHOD.invoke(creationContext, new Object[0]);
                s = (String)creationTraceStateString;
                if (s != null && !s.isEmpty()) {
                    traceState = traceState != null ? traceState + "," + s : s;
                } else {
                    logger.log(Level.FINEST, "No trace state in creation context");
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                logger.log(Level.WARNING, "Failed retrieve trace state as string from creation context", e);
            }
        }
        return traceState;
    }

    public static String getBaggageAsString(Object intoMessageWithTracingSupport) {
        if (!IS_TRACING_CONTEXT_API_VALID) {
            return null;
        }
        Object baggageHolder = ClassLoaderReflectionUtil.getBaggageHolder(intoMessageWithTracingSupport);
        if (baggageHolder == null) {
            return null;
        }
        try {
            Object traceStateString = GET_BAGGAGE_METHOD.invoke(baggageHolder, new Object[0]);
            return (String)traceStateString;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.log(Level.WARNING, "Failed retrieve baggage as string from MessageWithTracingSupport", e);
            return null;
        }
    }

    private static String contextAsString(Object context) {
        try {
            if (context == null) {
                return null;
            }
            Object tracingIdBytes = GET_TRACING_ID_BYTES_METHOD.invoke(context, new Object[0]);
            Object spanIdBytes = GET_SPAN_ID_BYTES_METHOD.invoke(context, new Object[0]);
            Object sampledBool = IS_SAMPLED_METHOD.invoke(context, new Object[0]);
            if (tracingIdBytes == null || spanIdBytes == null) {
                return null;
            }
            char[] rawArray = new char[TRACEPARENT_HEADER_SIZE];
            rawArray[0] = VERSION.charAt(0);
            rawArray[1] = VERSION.charAt(1);
            rawArray[2] = 45;
            String traceId = ClassLoaderReflectionUtil.traceIdToString((byte[])tracingIdBytes);
            ClassLoaderReflectionUtil.toCharArray(traceId, 0, rawArray, 3, traceId.length());
            rawArray[ClassLoaderReflectionUtil.SPAN_ID_OFFSET - 1] = 45;
            String spanId = ClassLoaderReflectionUtil.spanIdToString((byte[])spanIdBytes);
            ClassLoaderReflectionUtil.toCharArray(spanId, 0, rawArray, SPAN_ID_OFFSET, spanId.length());
            rawArray[ClassLoaderReflectionUtil.TRACE_OPTION_OFFSET - 1] = 45;
            boolean sampled = (Boolean)sampledBool;
            String traceFlagsHex = sampled ? SAMPLED_HEX : DEFAULT_HEX;
            rawArray[ClassLoaderReflectionUtil.TRACE_OPTION_OFFSET] = traceFlagsHex.charAt(0);
            rawArray[ClassLoaderReflectionUtil.TRACE_OPTION_OFFSET + 1] = traceFlagsHex.charAt(1);
            return new String(rawArray, 0, TRACEPARENT_HEADER_SIZE);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.log(Level.WARNING, "Failed retrieve trace parent as string from MessageWithTracingSupport", e);
            return null;
        }
    }

    private static String traceIdToString(byte[] traceId) {
        return TraceId.fromBytes((byte[])traceId);
    }

    private static String spanIdToString(byte[] traceId) {
        return SpanId.fromBytes((byte[])traceId);
    }

    private static void toCharArray(String s, int srcBegin, char[] dest, int dstBegin, int length) {
        char[] c = s.toCharArray();
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (length > c.length) {
            throw new StringIndexOutOfBoundsException(length);
        }
        System.arraycopy(c, srcBegin, dest, dstBegin, length);
    }

    private static boolean isTracingContextApiValid() {
        return SET_TRACING_ID_BYTES_16_METHOD != null && SET_SPAN_ID_BYTES_8_METHOD != null && SET_SAMPLED_METHOD != null && SET_TRACE_STATE_METHOD != null && SET_BAGGAGE_METHOD != null && GET_TRACING_ID_BYTES_METHOD != null && GET_SPAN_ID_BYTES_METHOD != null && IS_SAMPLED_METHOD != null && GET_TRACE_STATE_METHOD != null && GET_BAGGAGE_METHOD != null;
    }

    static {
        Class<?> baggageClass;
        Class<?> tracingContextClass;
        Class<?> tracingContextSetterClass;
        Class<?> messageTracingSupportClass;
        logger = Logger.getLogger(ClassLoaderReflectionUtil.class.getName());
        threadContextClassLoader = Thread.currentThread().getContextClassLoader();
        classloader = threadContextClassLoader != null ? threadContextClassLoader : ClassLoader.getSystemClassLoader();
        TRACE_ID_HEX_SIZE = TraceId.getLength();
        SPAN_ID_HEX_SIZE = SpanId.getLength();
        TRACE_OPTION_HEX_SIZE = TraceFlags.getLength();
        SPAN_ID_OFFSET = 3 + TRACE_ID_HEX_SIZE + 1;
        TRACE_OPTION_OFFSET = SPAN_ID_OFFSET + SPAN_ID_HEX_SIZE + 1;
        TRACEPARENT_HEADER_SIZE = TRACE_OPTION_OFFSET + TRACE_OPTION_HEX_SIZE;
        HEX_ARRAY = "0123456789ABCDEF".toCharArray();
        byte r1 = 1;
        SAMPLED_HEX = ClassLoaderReflectionUtil.byteToHex(r1);
        byte r2 = 0;
        DEFAULT_HEX = ClassLoaderReflectionUtil.byteToHex(r2);
        try {
            messageTracingSupportClass = Class.forName("com.solace.messaging.trace.propagation.MessageTracingSupport", true, classloader);
        }
        catch (ClassNotFoundException | LinkageError e) {
            logger.log(Level.FINE, "", e);
            messageTracingSupportClass = null;
        }
        MESSAGE_TRACING_SUPPORT_CLASS = messageTracingSupportClass;
        try {
            tracingContextSetterClass = Class.forName("com.solace.messaging.trace.propagation.TraceContextSetter", true, classloader);
        }
        catch (ClassNotFoundException | LinkageError e) {
            logger.log(Level.FINE, "", e);
            tracingContextSetterClass = null;
        }
        MESSAGE_TRACE_CONTEXT_SETTER_CLASS = tracingContextSetterClass;
        try {
            tracingContextClass = Class.forName("com.solace.messaging.trace.propagation.TraceContext", true, classloader);
        }
        catch (ClassNotFoundException | LinkageError e) {
            logger.log(Level.FINE, "", e);
            tracingContextClass = null;
        }
        TRACING_CONTEXT_CLASS = tracingContextClass;
        try {
            baggageClass = Class.forName("com.solace.messaging.trace.propagation.Baggage", true, classloader);
        }
        catch (ClassNotFoundException | LinkageError e) {
            logger.log(Level.FINE, "", e);
            baggageClass = null;
        }
        BAGGAGE_CLASS = baggageClass;
        if (MESSAGE_TRACE_CONTEXT_SETTER_CLASS != null) {
            Method getTraceStateMethod;
            Method isSampledMethod;
            Method getSpanIdBytesMethod;
            Method getTraceIdBytesMethod;
            Method setTraceStateMethod;
            Method setSampledMethod;
            Method setSpanIdBytes8Method;
            Method setTraceId16Method;
            try {
                setTraceId16Method = MESSAGE_TRACE_CONTEXT_SETTER_CLASS.getDeclaredMethod("setTraceIdBytes16", byte[].class);
            }
            catch (NoSuchMethodException e) {
                logger.log(Level.FINE, "", e);
                setTraceId16Method = null;
            }
            SET_TRACING_ID_BYTES_16_METHOD = setTraceId16Method;
            try {
                setSpanIdBytes8Method = MESSAGE_TRACE_CONTEXT_SETTER_CLASS.getDeclaredMethod("setSpanIdBytes8", byte[].class);
            }
            catch (NoSuchMethodException e) {
                logger.log(Level.FINE, "", e);
                setSpanIdBytes8Method = null;
            }
            SET_SPAN_ID_BYTES_8_METHOD = setSpanIdBytes8Method;
            try {
                setSampledMethod = MESSAGE_TRACE_CONTEXT_SETTER_CLASS.getDeclaredMethod("setSampled", Boolean.TYPE);
            }
            catch (NoSuchMethodException e) {
                logger.log(Level.FINE, "", e);
                setSampledMethod = null;
            }
            SET_SAMPLED_METHOD = setSampledMethod;
            try {
                setTraceStateMethod = MESSAGE_TRACE_CONTEXT_SETTER_CLASS.getDeclaredMethod("setTraceState", String.class);
            }
            catch (NoSuchMethodException e) {
                logger.log(Level.FINE, "", e);
                setTraceStateMethod = null;
            }
            SET_TRACE_STATE_METHOD = setTraceStateMethod;
            try {
                getTraceIdBytesMethod = TRACING_CONTEXT_CLASS.getDeclaredMethod("getTraceIdBytes16", null);
            }
            catch (NoSuchMethodException e) {
                logger.log(Level.FINE, "", e);
                getTraceIdBytesMethod = null;
            }
            GET_TRACING_ID_BYTES_METHOD = getTraceIdBytesMethod;
            try {
                getSpanIdBytesMethod = TRACING_CONTEXT_CLASS.getDeclaredMethod("getSpanIdBytes8", null);
            }
            catch (NoSuchMethodException e) {
                logger.log(Level.FINE, "", e);
                getSpanIdBytesMethod = null;
            }
            GET_SPAN_ID_BYTES_METHOD = getSpanIdBytesMethod;
            try {
                isSampledMethod = TRACING_CONTEXT_CLASS.getDeclaredMethod("isSampled", null);
            }
            catch (NoSuchMethodException e) {
                logger.log(Level.FINE, "", e);
                isSampledMethod = null;
            }
            IS_SAMPLED_METHOD = isSampledMethod;
            try {
                getTraceStateMethod = TRACING_CONTEXT_CLASS.getDeclaredMethod("getTraceState", null);
            }
            catch (NoSuchMethodException e) {
                logger.log(Level.FINE, "", e);
                getTraceStateMethod = null;
            }
            GET_TRACE_STATE_METHOD = getTraceStateMethod;
        } else {
            SET_TRACING_ID_BYTES_16_METHOD = null;
            SET_SPAN_ID_BYTES_8_METHOD = null;
            SET_SAMPLED_METHOD = null;
            SET_TRACE_STATE_METHOD = null;
            GET_TRACING_ID_BYTES_METHOD = null;
            GET_SPAN_ID_BYTES_METHOD = null;
            IS_SAMPLED_METHOD = null;
            GET_TRACE_STATE_METHOD = null;
        }
        if (BAGGAGE_CLASS != null) {
            Method getBaggageMethod;
            Method setBaggageMethod;
            try {
                setBaggageMethod = BAGGAGE_CLASS.getDeclaredMethod("setBaggage", String.class);
            }
            catch (NoSuchMethodException e) {
                logger.log(Level.FINE, "", e);
                setBaggageMethod = null;
            }
            SET_BAGGAGE_METHOD = setBaggageMethod;
            try {
                getBaggageMethod = BAGGAGE_CLASS.getDeclaredMethod("getBaggage", null);
            }
            catch (NoSuchMethodException e) {
                logger.log(Level.FINE, "", e);
                getBaggageMethod = null;
            }
            GET_BAGGAGE_METHOD = getBaggageMethod;
        } else {
            SET_BAGGAGE_METHOD = null;
            GET_BAGGAGE_METHOD = null;
        }
        IS_TRACING_CONTEXT_API_VALID = ClassLoaderReflectionUtil.isTracingContextApiValid();
    }
}

