/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.trace.propagation.internal;

import com.solace.messaging.trace.propagation.VersionInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VersionInfoImpl
implements VersionInfo {
    private final String moduleVersion = String.format("JAVA OpenTelemetry Integration %s", manifestReader.getImplVersion());
    private static final String versionTemplate = "JAVA OpenTelemetry Integration %s";
    private static final ManifestReader manifestReader = new ManifestReader();

    @Override
    public String getVersion() {
        return this.moduleVersion;
    }

    private static final class ManifestReader {
        private static final String OTEL_MANIFEST_SECTION_NAME = "com.solace.messaging.trace.propagation";
        private static final String SCM_REVISION = "SCM-Revision";
        private final Map<String, String> manifestContent = new HashMap<String, String>();
        private static final Logger logger = Logger.getLogger(ManifestReader.class.getName());

        private ManifestReader() {
            ClassLoader cl = ManifestReader.getContextClassLoader();
            if (cl != null) {
                try {
                    Enumeration<URL> manifestResources = cl.getResources("META-INF/MANIFEST.MF");
                    Map<String, String> manifestInfo = ManifestReader.findApiManifest(manifestResources);
                    this.manifestContent.putAll(manifestInfo);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Encountered problem by reading of META-INF/MANIFEST.MF ", e);
                }
            }
        }

        String getImplVersion() {
            return this.manifestContent.get(Attributes.Name.IMPLEMENTATION_VERSION.toString());
        }

        String getScmRevision() {
            return this.manifestContent.get(SCM_REVISION);
        }

        public static ClassLoader getContextClassLoader() {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    ClassLoader cl = null;
                    try {
                        cl = Thread.currentThread().getContextClassLoader();
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    return cl;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Map<String, String> findApiManifest(Enumeration<URL> allManifests) {
            HashMap<String, String> output = new HashMap<String, String>();
            while (allManifests.hasMoreElements()) {
                URL manifestUrl = allManifests.nextElement();
                try {
                    InputStream manifestStream = manifestUrl.openStream();
                    try {
                        Manifest manifest = new Manifest(manifestStream);
                        Map<String, Attributes> entries = manifest.getEntries();
                        Attributes attributes = entries.get(OTEL_MANIFEST_SECTION_NAME);
                        if (attributes == null || attributes.isEmpty() || !attributes.containsKey(Attributes.Name.IMPLEMENTATION_VERSION) || manifest.getMainAttributes().getValue(SCM_REVISION) == null) continue;
                        output.put(Attributes.Name.IMPLEMENTATION_VERSION.toString(), attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION));
                        output.put(SCM_REVISION, manifest.getMainAttributes().getValue(SCM_REVISION));
                        Attributes attrs = manifest.getMainAttributes();
                        for (Object key : attrs.keySet()) {
                            String value = attrs.getValue((Attributes.Name)Attributes.Name.class.cast(key));
                            output.put(key.toString(), value);
                        }
                        logger.log(Level.INFO, "Manifest Reader: " + output);
                        break;
                    }
                    finally {
                        if (manifestStream == null) continue;
                        try {
                            manifestStream.close();
                        }
                        catch (IOException e) {
                            logger.log(Level.WARNING, "Encountered problem by closing META-INF/MANIFEST.MF file stream", e);
                        }
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Encountered problem by reading META-INF/MANIFEST.MF file stream", e);
                }
            }
            output.computeIfAbsent(Attributes.Name.IMPLEMENTATION_VERSION.toString(), k -> "--");
            output.computeIfAbsent(SCM_REVISION, k -> "--");
            return output;
        }
    }
}

