/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging;

import com.solace.messaging.PubSubPlusClientException;
import com.solace.messaging.util.InteroperabilitySupport;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.Validation;
import com.solacesystems.jcsmp.BytesMessage;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.MapMessage;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.TextMessage;
import com.solacesystems.jcsmp.XMLContentMessage;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface Message
extends InteroperabilitySupport,
Serializable {
    public Map<String, String> getProperties();

    public boolean hasProperty(String var1);

    public String getProperty(String var1);

    public byte[] getPayloadAsBytes();

    public String getPayloadAsString();

    public String getCorrelationId();

    public Object getCorrelationKey();

    public long getExpiration();

    public long getSequenceNumber();

    public int getPriority();

    public boolean hasContent();

    public String getApplicationMessageId();

    public String getApplicationMessageType();

    @Internal
    @ProviderType
    public static class SolaceMessageImpl
    implements Message {
        private static final long serialVersionUID = 8994429587490021533L;
        protected final transient BytesXMLMessage solaceMessage;
        private static final String EMPTY_STRING = "";
        private final InteroperabilitySupport.RestInteroperabilitySupport restInteroperabilitySupport;
        private static final long NO_LONG_VALUE = -1L;
        private static final Log logger = LogFactory.getLog(SolaceMessageImpl.class);
        private static final byte[] ZERO_BYTES = new byte[0];

        protected SolaceMessageImpl(BytesXMLMessage solaceMessage) {
            Validation.nullIllegal(solaceMessage, "Message can't be null");
            this.solaceMessage = solaceMessage;
            this.restInteroperabilitySupport = new RestInteroperabilitySupportImpl();
        }

        public String toString() {
            return "MessageImpl{solaceMessage=" + this.solaceMessage + '}';
        }

        @Override
        public Map<String, String> getProperties() {
            return this.toMap(this.solaceMessage.getProperties());
        }

        @Override
        public boolean hasProperty(String name) {
            Validation.nullIllegal(name, "'null' is an illegal property name value.");
            if (this.solaceMessage.getProperties() == null) {
                return false;
            }
            return this.solaceMessage.getProperties().containsKey(name);
        }

        @Override
        public String getProperty(String name) {
            Validation.nullIllegal(name, "'null' is an illegal property name value.");
            try {
                return this.solaceMessage.getProperties().getString(name);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public byte[] getPayloadAsBytes() {
            if (this.solaceMessage.getContentLength() > 0 && this.solaceMessage.hasAttachment()) {
                throw new PubSubPlusClientException("multiple payloads");
            }
            if (this.solaceMessage.hasAttachment()) {
                if (this.solaceMessage instanceof TextMessage) {
                    String stringPayload = ((TextMessage)this.solaceMessage).getText();
                    if (stringPayload != null) {
                        return stringPayload.getBytes(StandardCharsets.UTF_8);
                    }
                    return ZERO_BYTES;
                }
                if (this.solaceMessage instanceof XMLContentMessage) {
                    return ((XMLContentMessage)this.solaceMessage).getAttachmentByteBuffer() == null ? ZERO_BYTES : ((XMLContentMessage)this.solaceMessage).getAttachmentByteBuffer().array();
                }
                if (this.solaceMessage instanceof BytesMessage) {
                    return ((BytesMessage)this.solaceMessage).getData();
                }
                if (this.solaceMessage instanceof MapMessage) {
                    return ZERO_BYTES;
                }
                return this.solaceMessage.getAttachmentByteBuffer() == null ? ZERO_BYTES : this.solaceMessage.getAttachmentByteBuffer().array();
            }
            return this.solaceMessage.getBytes();
        }

        @Override
        public String getPayloadAsString() {
            if (this.solaceMessage.hasContent() && this.solaceMessage.hasAttachment()) {
                throw new PubSubPlusClientException("multiple payloads");
            }
            if (this.solaceMessage.hasAttachment()) {
                if (this.solaceMessage instanceof TextMessage) {
                    return ((TextMessage)this.solaceMessage).getText();
                }
                if (this.solaceMessage instanceof XMLContentMessage) {
                    return ((XMLContentMessage)this.solaceMessage).getAttachmentByteBuffer() == null ? EMPTY_STRING : new String(((XMLContentMessage)this.solaceMessage).getAttachmentByteBuffer().array(), StandardCharsets.UTF_8);
                }
                if (this.solaceMessage instanceof BytesMessage) {
                    BytesMessage bytesMessage = (BytesMessage)this.solaceMessage;
                    byte[] bytesPayload = bytesMessage.getData();
                    if (bytesPayload == null) {
                        return EMPTY_STRING;
                    }
                    return new String(bytesPayload, StandardCharsets.UTF_8);
                }
                if (this.solaceMessage instanceof MapMessage) {
                    MapMessage mapMessage = (MapMessage)this.solaceMessage;
                    SDTMap mapPayload = mapMessage.getMap();
                    if (mapPayload == null) {
                        return EMPTY_STRING;
                    }
                    try {
                        return mapPayload.toString();
                    }
                    catch (Exception e) {
                        if (logger.isWarnEnabled()) {
                            logger.warn((Object)"SDT message PayloadAsString conversion failed.", (Throwable)e);
                        }
                        return EMPTY_STRING;
                    }
                }
                return this.solaceMessage.getAttachmentByteBuffer() == null ? EMPTY_STRING : new String(this.solaceMessage.getAttachmentByteBuffer().array(), StandardCharsets.UTF_8);
            }
            byte[] bytesPayload = this.solaceMessage.getBytes();
            if (bytesPayload == null) {
                return EMPTY_STRING;
            }
            return new String(bytesPayload, StandardCharsets.UTF_8);
        }

        @Override
        public String getCorrelationId() {
            return this.solaceMessage.getCorrelationId();
        }

        @Override
        public Object getCorrelationKey() {
            return this.solaceMessage.getCorrelationKey();
        }

        @Override
        public long getExpiration() {
            return this.solaceMessage.getExpiration();
        }

        @Override
        public long getSequenceNumber() {
            Long value = this.solaceMessage.getSequenceNumber();
            return value != null ? value : -1L;
        }

        @Override
        public int getPriority() {
            return this.solaceMessage.getPriority();
        }

        @Override
        public boolean hasContent() {
            return this.solaceMessage.hasContent();
        }

        @Override
        public String getApplicationMessageId() {
            return this.solaceMessage.getApplicationMessageId();
        }

        @Override
        public String getApplicationMessageType() {
            return this.solaceMessage.getApplicationMessageType();
        }

        @Internal
        private Map<String, String> toMap(SDTMap map) {
            HashMap<String, String> output = new HashMap<String, String>();
            if (map == null || map.isEmpty()) {
                return output;
            }
            map.keySet().forEach(k -> {
                block2: {
                    try {
                        String value = map.getString(k);
                        output.put((String)k, value);
                    }
                    catch (Exception e) {
                        if (!logger.isWarnEnabled()) break block2;
                        logger.warn((Object)"SDTMap to java Map conversion failed.", (Throwable)e);
                    }
                }
            });
            return output;
        }

        @Override
        public InteroperabilitySupport.RestInteroperabilitySupport getRestInteroperabilitySupport() {
            return this.restInteroperabilitySupport;
        }

        @Internal
        @ProviderType
        private class RestInteroperabilitySupportImpl
        implements InteroperabilitySupport.RestInteroperabilitySupport {
            private static final long serialVersionUID = 2263860666621884603L;

            @Override
            public String getHTTPContentType() {
                return SolaceMessageImpl.this.solaceMessage.getHTTPContentType();
            }

            @Override
            public String getHTTPContentEncoding() {
                return SolaceMessageImpl.this.solaceMessage.getHTTPContentEncoding();
            }

            public String toString() {
                return "RestInteroperabilitySupport{httpContentType='" + SolaceMessageImpl.this.solaceMessage.getHTTPContentType() + '\'' + ", httpContentEncoding='" + SolaceMessageImpl.this.solaceMessage.getHTTPContentEncoding() + '\'' + '}';
            }
        }
    }
}

