/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging;

import com.solace.messaging.AbstractConfigurableBuilder;
import com.solace.messaging.MessagePublisherBuilder;
import com.solace.messaging.PubSubPlusClientException;
import com.solace.messaging.config.provider.PublisherAckConfigurationProvider;
import com.solace.messaging.config.provider.PublisherBackPressureConfigurationProvider;
import com.solace.messaging.config.provider.PublisherPropertiesConfigurationProvider;
import com.solace.messaging.publisher.OutboundMessageBuilder;
import com.solace.messaging.publisher.PersistentMessagePublisher;
import com.solace.messaging.publisher.PersistentMessagePublisherImpl;
import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.MessagingServiceInternalView;
import com.solace.messaging.util.internal.Validation;
import java.util.Properties;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface PersistentMessagePublisherBuilder
extends MessagePublisherBuilder {
    public PersistentMessagePublisherBuilder withDeliveryAckTimeout(int var1) throws IllegalArgumentException;

    public PersistentMessagePublisherBuilder withDeliveryAckWindowSize(int var1) throws IllegalArgumentException;

    @Override
    public PersistentMessagePublisherBuilder fromProperties(Properties var1);

    @Override
    public PersistentMessagePublisherBuilder onBackPressureReject(int var1);

    @Override
    public PersistentMessagePublisherBuilder onBackPressureElastic();

    @Override
    public PersistentMessagePublisherBuilder onBackPressureWait(int var1);

    public PersistentMessagePublisher build() throws PubSubPlusClientException;

    @Internal
    @ProviderType
    public static class PersistentMessagePublisherBuilderImpl
    extends AbstractConfigurableBuilder
    implements PersistentMessagePublisherBuilder {
        private final MessagingServiceInternalView serviceInternalView;
        private final OutboundMessageBuilder messageBuilder;

        PersistentMessagePublisherBuilderImpl(OutboundMessageBuilder messageBuilder, MessagingServiceInternalView serviceInternalView) {
            super(serviceInternalView.getActiveProfile());
            this.messageBuilder = messageBuilder;
            this.serviceInternalView = serviceInternalView;
        }

        @Override
        public PersistentMessagePublisherBuilder withDeliveryAckTimeout(int timeout) {
            this.configProviders.add(PublisherAckConfigurationProvider.deliveryAckTimeout(timeout));
            return this;
        }

        @Override
        public PersistentMessagePublisherBuilder withDeliveryAckWindowSize(int windowSize) {
            this.configProviders.add(PublisherAckConfigurationProvider.deliveryAckWindowSize(windowSize));
            return this;
        }

        @Override
        public PersistentMessagePublisherBuilder fromProperties(Properties configuration) throws IllegalArgumentException {
            this.configProviders.add(PublisherPropertiesConfigurationProvider.of(configuration));
            return this;
        }

        @Override
        public PersistentMessagePublisherBuilder onBackPressureReject(int bufferCapacity) {
            this.configProviders.add(PublisherBackPressureConfigurationProvider.bufferAndReject(bufferCapacity));
            return this;
        }

        @Override
        public PersistentMessagePublisherBuilder onBackPressureElastic() {
            this.configProviders.add(PublisherBackPressureConfigurationProvider.elastic());
            return this;
        }

        @Override
        public PersistentMessagePublisherBuilder onBackPressureWait(int bufferCapacity) {
            this.configProviders.add(PublisherBackPressureConfigurationProvider.bufferAndWait(bufferCapacity));
            return this;
        }

        @Override
        public PersistentMessagePublisher build() throws PubSubPlusClientException {
            return new PersistentMessagePublisherImpl(this.serviceInternalView, this.composeConfiguration(), this.messageBuilder);
        }

        @Override
        void validate(TypedProperties properties) throws IllegalArgumentException {
            String bpStrategy = properties.getProperty("solace.messaging.publisher.back-pressure.strategy");
            Validation.nullOrEmptyIllegal(bpStrategy, "Back-pressure strategy settings are missing");
            switch (bpStrategy) {
                case "ELASTIC": {
                    break;
                }
                case "BUFFER_REJECT_WHEN_FULL": 
                case "BUFFER_WAIT_WHEN_FULL": {
                    try {
                        int capacity = properties.getIntegerProperty("solace.messaging.publisher.back-pressure.buffer-capacity");
                        if (capacity < 0) {
                            throw new IllegalArgumentException(String.format("Negative buffer capacity %d", capacity));
                        }
                        break;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Missing or illegal buffer capacity");
                    }
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unknown back-pressure strategy: %s", bpStrategy));
                }
            }
        }

        @Override
        TypedProperties createDefaultConfiguration() {
            return this.activeProfile.getConfigurationObjectFactory().createPersistentPublisherConfiguration().getConfiguration();
        }
    }
}

