/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging;

import com.solace.messaging.AbstractConfigurableBuilder;
import com.solace.messaging.PubSubPlusClientException;
import com.solace.messaging.config.ReceiverPropertyConfiguration;
import com.solace.messaging.config.provider.QueueBrowserConfigurationProvider;
import com.solace.messaging.config.provider.QueueBrowserPropertiesConfigurationProvider;
import com.solace.messaging.receiver.MessageQueueBrowser;
import com.solace.messaging.receiver.MessageQueueBrowserImpl;
import com.solace.messaging.resources.Queue;
import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.MessagingServiceInternalView;
import com.solace.messaging.util.internal.Validation;
import java.util.Properties;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface MessageQueueBrowserBuilder
extends ReceiverPropertyConfiguration {
    @Override
    public MessageQueueBrowserBuilder fromProperties(Properties var1);

    public MessageQueueBrowserBuilder withMessageSelector(String var1);

    public MessageQueueBrowserBuilder withQueueBrowserWindowSize(int var1) throws IllegalArgumentException;

    public MessageQueueBrowser build(Queue var1) throws PubSubPlusClientException;

    @Internal
    @ProviderType
    public static class MessageQueueBrowserBuilderImpl
    extends AbstractConfigurableBuilder
    implements MessageQueueBrowserBuilder {
        private final MessagingServiceInternalView messagingServiceInternalView;

        MessageQueueBrowserBuilderImpl(MessagingServiceInternalView messagingServiceInternalView) {
            super(messagingServiceInternalView.getActiveProfile());
            this.messagingServiceInternalView = messagingServiceInternalView;
        }

        @Override
        void validate(TypedProperties properties) throws IllegalArgumentException {
        }

        @Override
        TypedProperties createDefaultConfiguration() {
            return this.activeProfile.getConfigurationObjectFactory().createMessageQueueBrowserConfiguration().getConfiguration();
        }

        @Override
        public MessageQueueBrowserBuilder fromProperties(Properties configuration) {
            this.configProviders.add(QueueBrowserPropertiesConfigurationProvider.of(configuration));
            return this;
        }

        @Override
        public MessageQueueBrowserBuilder withMessageSelector(String selectorQueryExpression) {
            this.configProviders.add(QueueBrowserConfigurationProvider.messageSelector(selectorQueryExpression));
            return this;
        }

        @Override
        public MessageQueueBrowserBuilder withQueueBrowserWindowSize(int windowSize) throws IllegalArgumentException {
            this.configProviders.add(QueueBrowserConfigurationProvider.windowSize(windowSize));
            return this;
        }

        @Override
        public MessageQueueBrowser build(Queue endpointToConsumeFrom) throws PubSubPlusClientException {
            Validation.nullIllegal(endpointToConsumeFrom, "endpointToConsumeFrom can't be null");
            TypedProperties configuration = this.composeConfiguration();
            return new MessageQueueBrowserImpl(this.messagingServiceInternalView, configuration, endpointToConsumeFrom);
        }
    }
}

