/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging;

import com.solace.messaging.AbstractConfigurableBuilder;
import com.solace.messaging.MessageReceiverBuilder;
import com.solace.messaging.PubSubPlusClientException;
import com.solace.messaging.config.MessageAcknowledgementConfiguration;
import com.solace.messaging.config.MessageReplayConfiguration;
import com.solace.messaging.config.MissingResourcesCreationConfiguration;
import com.solace.messaging.config.ReceiverActivationPassivationConfiguration;
import com.solace.messaging.config.ReplayStrategy;
import com.solace.messaging.config.provider.ReceiverActivationPassivationConfigurationProvider;
import com.solace.messaging.config.provider.ReceiverAutoAckConfigurationProvider;
import com.solace.messaging.config.provider.ReceiverMessageReplayConfigurationProvider;
import com.solace.messaging.config.provider.ReceiverMessageSelectorConfigurationProvider;
import com.solace.messaging.config.provider.ReceiverMissingResourcesCreationConfigurationProvider;
import com.solace.messaging.config.provider.ReceiverPropertiesConfigurationProvider;
import com.solace.messaging.receiver.PersistentMessageReceiver;
import com.solace.messaging.receiver.PersistentMessageReceiverImpl;
import com.solace.messaging.resources.CachedTopicSubscription;
import com.solace.messaging.resources.Queue;
import com.solace.messaging.resources.TopicSubscription;
import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.MessagingServiceInternalView;
import com.solacesystems.jcsmp.impl.ReplicationGroupMessageIdImpl;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface PersistentMessageReceiverBuilder
extends MessageReceiverBuilder,
ReceiverActivationPassivationConfiguration,
MessageAcknowledgementConfiguration,
MessageReplayConfiguration,
MissingResourcesCreationConfiguration {
    @Override
    public PersistentMessageReceiverBuilder withSubscriptions(TopicSubscription ... var1);

    @Override
    public PersistentMessageReceiverBuilder fromProperties(Properties var1);

    @Override
    public PersistentMessageReceiverBuilder withMissingResourcesCreationStrategy(MissingResourcesCreationConfiguration.MissingResourcesCreationStrategy var1);

    @Override
    public PersistentMessageReceiverBuilder withActivationPassivationSupport(ReceiverActivationPassivationConfiguration.ReceiverStateChangeListener var1);

    @Override
    public PersistentMessageReceiverBuilder withMessageAutoAcknowledgement();

    @Override
    public PersistentMessageReceiverBuilder withMessageClientAcknowledgement();

    @Override
    public PersistentMessageReceiverBuilder withMessageReplay(ReplayStrategy var1);

    public PersistentMessageReceiverBuilder withMessageSelector(String var1);

    public PersistentMessageReceiver build(Queue var1) throws PubSubPlusClientException;

    @Internal
    @ProviderType
    public static class PersistentMessageReceiverBuilderImpl
    extends AbstractConfigurableBuilder
    implements PersistentMessageReceiverBuilder {
        private final MessagingServiceInternalView messagingServiceInternalView;
        private final List<TopicSubscription> topicSubscriptions = new CopyOnWriteArrayList<TopicSubscription>();

        PersistentMessageReceiverBuilderImpl(MessagingServiceInternalView messagingServiceInternalView) {
            super(messagingServiceInternalView.getActiveProfile());
            this.messagingServiceInternalView = messagingServiceInternalView;
        }

        @Override
        public PersistentMessageReceiverBuilder withSubscriptions(TopicSubscription ... subscriptions) {
            if (subscriptions != null && subscriptions.length > 0) {
                for (TopicSubscription ts : subscriptions) {
                    if (ts == null) continue;
                    this.topicSubscriptions.add(ts);
                }
            }
            return this;
        }

        @Override
        public PersistentMessageReceiverBuilder fromProperties(Properties configuration) throws IllegalArgumentException {
            this.configProviders.add(ReceiverPropertiesConfigurationProvider.of(configuration));
            return this;
        }

        @Override
        public PersistentMessageReceiverBuilder withMissingResourcesCreationStrategy(MissingResourcesCreationConfiguration.MissingResourcesCreationStrategy strategy) {
            this.configProviders.add(ReceiverMissingResourcesCreationConfigurationProvider.of(strategy));
            return this;
        }

        @Override
        public PersistentMessageReceiverBuilder withActivationPassivationSupport(ReceiverActivationPassivationConfiguration.ReceiverStateChangeListener receiverStateChangeListener) {
            this.configProviders.add(ReceiverActivationPassivationConfigurationProvider.activationPassivationSupport(receiverStateChangeListener));
            return this;
        }

        @Override
        public PersistentMessageReceiverBuilder withMessageAutoAcknowledgement() {
            this.configProviders.add(ReceiverAutoAckConfigurationProvider.autoAck());
            return this;
        }

        @Override
        public PersistentMessageReceiverBuilder withMessageClientAcknowledgement() {
            this.configProviders.add(ReceiverAutoAckConfigurationProvider.clientAck());
            return this;
        }

        @Override
        public PersistentMessageReceiverBuilder withMessageReplay(ReplayStrategy replayStrategy) {
            this.configProviders.add(ReceiverMessageReplayConfigurationProvider.replay(replayStrategy));
            return this;
        }

        @Override
        public PersistentMessageReceiverBuilder withMessageSelector(String selectorQueryExpression) {
            this.configProviders.add(ReceiverMessageSelectorConfigurationProvider.messageSelector(selectorQueryExpression));
            return this;
        }

        @Override
        public PersistentMessageReceiver build(Queue endpointToConsumeFrom) {
            TypedProperties configuration = this.composeConfiguration();
            String replay = configuration.getProperty("solace.messaging.receiver.persistent.replay.strategy");
            if (!(replay == null || replay.isEmpty() || endpointToConsumeFrom.isDurable() && endpointToConsumeFrom.isExclusivelyAccessible())) {
                throw new IllegalArgumentException("Message replay is not supported on non-durable or non-exclusive queues");
            }
            this.topicSubscriptions.forEach(topicSubscription -> {
                if (topicSubscription instanceof CachedTopicSubscription) {
                    throw new IllegalArgumentException("Cached topic subscriptions are not supported on persistent messaging");
                }
            });
            return new PersistentMessageReceiverImpl(this.messagingServiceInternalView, configuration, this.topicSubscriptions, endpointToConsumeFrom);
        }

        @Override
        void validate(TypedProperties properties) throws IllegalArgumentException {
            String ackStrategy;
            String replayStrategy = properties.getProperty("solace.messaging.receiver.persistent.replay.strategy");
            if (replayStrategy != null) {
                switch (replayStrategy) {
                    case "REPLAY_ALL": {
                        break;
                    }
                    case "REPLAY_TIME_BASED": {
                        try {
                            ZonedDateTime replayTime = (ZonedDateTime)properties.getObjectProperty("solace.messaging.receiver.persistent.replay.timebased-start-time");
                            if (replayTime == null) {
                                throw new IllegalArgumentException("Missing replay time point");
                            }
                            break;
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Missing or illegal replay time point");
                        }
                    }
                    case "REPLAY_REPLICATION_GROUP_MESSAGE_ID_BASED": {
                        try {
                            String rmidString = properties.getProperty("solace.messaging.receiver.persistent.replay.replication-group-message-id");
                            if (rmidString == null) {
                                throw new IllegalArgumentException("Missing or illegal ReplicationGroupMessageId");
                            }
                            ReplicationGroupMessageIdImpl.createReplicationGroupMessageId((String)rmidString);
                            break;
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Missing or illegal ReplicationGroupMessageId", e);
                        }
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("Unknown message replay strategy: %s", replayStrategy));
                    }
                }
            }
            switch (ackStrategy = properties.getProperty("solace.messaging.receiver.persistent.ack.strategy")) {
                case "CLIENT_ACK": {
                    break;
                }
                case "AUTO_ACK": {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unknown message acknowledgement strategy: %s", ackStrategy));
                }
            }
        }

        @Override
        TypedProperties createDefaultConfiguration() {
            return this.activeProfile.getConfigurationObjectFactory().createPersistentReceiverConfiguration().getConfiguration();
        }
    }
}

