/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.config.provider;

import com.solace.messaging.config.provider.ServicePropertiesConfigurationProvider;
import com.solace.messaging.util.internal.Internal;
import java.util.Properties;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public class LocalConfigurationProvider
extends ServicePropertiesConfigurationProvider {
    private LocalConfigurationProvider(Properties configurationSource) {
        super(configurationSource);
    }

    public static LocalConfigurationProvider of() {
        return LocalConfigurationProvider.of(55555, "");
    }

    public static LocalConfigurationProvider of(int port) {
        return LocalConfigurationProvider.of(port, "");
    }

    public static LocalConfigurationProvider of(String vpnName) {
        return LocalConfigurationProvider.of(55555, vpnName);
    }

    public static LocalConfigurationProvider of(int port, String vpnName) {
        Properties localProperties = new Properties();
        localProperties.setProperty("solace.messaging.service.vpn-name", vpnName);
        localProperties.setProperty("solace.messaging.transport.host", "tcp:localhost:" + port);
        localProperties.setProperty("solace.messaging.transport.connection-retries", "10");
        localProperties.setProperty("solace.messaging.transport.connection-attempts-timeout", "30000");
        localProperties.setProperty("solace.messaging.authentication.scheme", "AUTHENTICATION_SCHEME_BASIC");
        localProperties.setProperty("solace.messaging.authentication.basic.username", "admin");
        localProperties.setProperty("solace.messaging.authentication.basic.password", "admin");
        return new LocalConfigurationProvider(localProperties);
    }

    public static LocalConfigurationProvider ofSecure() {
        return LocalConfigurationProvider.ofSecure(55443, "");
    }

    public static LocalConfigurationProvider ofSecure(int port) {
        return LocalConfigurationProvider.ofSecure(port, "");
    }

    public static LocalConfigurationProvider ofSecure(int port, String vpnName) {
        Properties localProperties = new Properties();
        localProperties.setProperty("solace.messaging.service.vpn-name", vpnName);
        localProperties.setProperty("solace.messaging.transport.host", "tcps:localhost:" + port);
        localProperties.setProperty("solace.messaging.transport.connection-retries", "10");
        localProperties.setProperty("solace.messaging.transport.connection-attempts-timeout", "30000");
        localProperties.setProperty("solace.messaging.authentication.scheme", "AUTHENTICATION_SCHEME_BASIC");
        localProperties.setProperty("solace.messaging.authentication.basic.username", "admin");
        localProperties.setProperty("solace.messaging.authentication.basic.password", "admin");
        return new LocalConfigurationProvider(localProperties);
    }
}

