/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.util.internal;

import com.solace.messaging.util.Manageable;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.MetricsKeyMapping;
import com.solace.messaging.util.internal.NextGenStatType;
import com.solace.messaging.util.internal.Validation;
import com.solacesystems.jcsmp.JCSMPStats;
import com.solacesystems.jcsmp.statistics.StatType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public final class SolaceStatsMetricsConverter {
    private static final Map<Manageable.ApiMetrics.Metric, MappingInfo> CONVERTER_MAP = new HashMap<Manageable.ApiMetrics.Metric, MappingInfo>();

    @Internal
    public static long getFromSolaceStats(JCSMPStats solaceStats, Manageable.ApiMetricsCollector ngCollector, Manageable.ApiMetrics.Metric theMetric) {
        Validation.nullIllegal(solaceStats, "Solace stats can't be null");
        Validation.nullIllegal(ngCollector, "Stats colector can't be null");
        Validation.nullIllegal(theMetric, "Metric collector can't be null");
        MappingInfo mapping = CONVERTER_MAP.get((Object)theMetric);
        if (StatType.class.equals(mapping.hostClass)) {
            if (Long.TYPE.equals(mapping.valueType)) {
                StatType solaceStatsKey = mapping.mappedConstant;
                return solaceStats.getStat(solaceStatsKey);
            }
            throw new IllegalArgumentException("Unsupported metric value type " + mapping.valueType);
        }
        if (NextGenStatType.class.equals(mapping.hostClass)) {
            if (Long.TYPE.equals(mapping.valueType)) {
                return ngCollector.getValue(theMetric);
            }
            throw new IllegalArgumentException("Unsupported metric value type " + mapping.valueType);
        }
        throw new IllegalArgumentException("Unsupported stats type " + mapping.hostClass);
    }

    static {
        Manageable.ApiMetrics.Metric[] enums = Manageable.ApiMetrics.Metric.values();
        Class<Manageable.ApiMetrics.Metric> cMetric = Manageable.ApiMetrics.Metric.class;
        for (Manageable.ApiMetrics.Metric m : enums) {
            try {
                Field enumField = cMetric.getField(m.name());
                MetricsKeyMapping mapper = enumField.getAnnotation(MetricsKeyMapping.class);
                if (mapper == null) continue;
                try {
                    Object mappedConstantValue;
                    Class<?> targetClass = mapper.target();
                    if (!StatType.class.equals(targetClass) && !NextGenStatType.class.equals(targetClass)) continue;
                    Field directMappedField = targetClass.getDeclaredField(mapper.mappedFieldName());
                    int mappedFiledModifiers = directMappedField.getModifiers();
                    if (directMappedField.isSynthetic() || !Modifier.isFinal(mappedFiledModifiers) || !Modifier.isStatic(mappedFiledModifiers) || !Modifier.isPublic(mappedFiledModifiers)) continue;
                    if (StatType.class.equals(directMappedField.getType())) {
                        mappedConstantValue = (StatType)directMappedField.get(null);
                        CONVERTER_MAP.put(m, new MappingInfo(targetClass, (StatType)mappedConstantValue, mapper.metricsValueType()));
                        continue;
                    }
                    if (!NextGenStatType.class.equals(directMappedField.getType())) continue;
                    mappedConstantValue = (NextGenStatType)((Object)directMappedField.get(null));
                    CONVERTER_MAP.put(m, new MappingInfo(targetClass, (NextGenStatType)((Object)mappedConstantValue), mapper.metricsValueType()));
                }
                catch (NoSuchFieldException e) {
                    throw new ExceptionInInitializerError(e);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    @Internal
    @ProviderType
    static class MappingInfo {
        final Class<?> hostClass;
        final StatType mappedConstant;
        final NextGenStatType ngMappedConstant;
        final Class<?> valueType;

        public MappingInfo(Class<?> hostClass, StatType mappedConstant, Class<?> valueType) {
            this.hostClass = hostClass;
            this.mappedConstant = mappedConstant;
            this.valueType = valueType;
            this.ngMappedConstant = null;
        }

        public MappingInfo(Class<?> hostClass, NextGenStatType mappedConstant, Class<?> valueType) {
            this.hostClass = hostClass;
            this.mappedConstant = null;
            this.valueType = valueType;
            this.ngMappedConstant = mappedConstant;
        }

        public Class<?> getValueType() {
            return this.valueType;
        }

        public Class<?> getHostClass() {
            return this.hostClass;
        }

        public StatType getMappedConstant() {
            return this.mappedConstant;
        }

        public NextGenStatType getNgMappedConstant() {
            return this.ngMappedConstant;
        }

        public String toString() {
            return "MappingInfo{hostClass=" + this.hostClass + ", mappedConstant=" + this.mappedConstant + ", ngMappedConstant=" + (Object)((Object)this.ngMappedConstant) + ", valueType=" + this.valueType + '}';
        }
    }
}

