/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging;

import com.solace.messaging.util.internal.Validation;
import com.solacesystems.jcsmp.CapabilityType;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPSecurityException;
import com.solacesystems.jcsmp.JCSMPTransportException;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Objects;
import javax.security.auth.login.LoginException;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class PubSubPlusClientException
extends RuntimeException {
    private static final long serialVersionUID = 2923685095404694389L;
    private static final String NOT_BYTES_TO_READ_MAPPING = "Unable to read enough bytes from stream!";
    private static final String NO_VALID_SMF_HEADER_MAPPING = "Could not read valid SMF Header from network";
    private static final String CERTIFICATE_ERROR_MAPPING = "Certificate Error";
    private static final String CERTIFICATE_EXPIRED_MAPPING = "Certificate Expired";
    private static final String UNAUTHORIZED_MAPPING = "Unauthorized";
    private static final String ACCESS_DENIED = "Access denied";
    private static final String BAD_CREDENTIALS = "The user name or password is incorrect";
    private static final String BAD_HOST_OR_PORT = "Service can't be reached using provided host and port";
    private static final String BAD_CERTIFICATE = "Certificate error";
    private static final String BAD_LOGIN_CONFIGURATION = "Jaas login configuration error";
    private static final String GENERIC_CERTIFICATE_ERROR = "Certificate error, client could not login to message broker";
    private static final String CERTIFICATE_EXPIRED = "Certificate error, Certificate Expired";
    private static final String ACCESS_TYPE_MISMATCH = "Access Type mismatch.";
    private static final String ROUTER_NOT_REACHABLE = "Error communicating with the router.";
    private static final String AUTHENTICATION_TYPE_NOT_AVAILABLE = "Authentication type not available or disabled";
    private static final String GOT_DECODER_EXCEPTION = "got netty DecoderException";

    public PubSubPlusClientException() {
    }

    public PubSubPlusClientException(String message) {
        super(message);
    }

    public PubSubPlusClientException(String message, Throwable cause) {
        super(message, cause);
    }

    public PubSubPlusClientException(Throwable cause) {
        super(cause);
    }

    public static PubSubPlusClientException of(Throwable t) {
        Validation.nullIllegal(t, "Exception can't be null");
        if (t instanceof PubSubPlusClientException) {
            return (PubSubPlusClientException)t;
        }
        if (t instanceof JCSMPErrorResponseException) {
            String errorMsg;
            JCSMPErrorResponseException e = (JCSMPErrorResponseException)t;
            int errorSubCode = e.getSubcodeEx();
            String string = errorMsg = e.getResponsePhrase() != null ? e.getResponsePhrase() : null;
            if (401 == e.getResponseCode()) {
                if (errorSubCode == 1 && errorMsg != null && errorMsg.contains(CERTIFICATE_ERROR_MAPPING)) {
                    return new AuthenticationException(GENERIC_CERTIFICATE_ERROR, t);
                }
                if (errorSubCode == 1 && errorMsg != null && errorMsg.contains(CERTIFICATE_EXPIRED_MAPPING)) {
                    return new AuthenticationException(CERTIFICATE_EXPIRED, t);
                }
                return new AuthenticationException(Objects.toString(errorMsg, UNAUTHORIZED_MAPPING), t);
            }
            if (403 == e.getResponseCode()) {
                if (1 == errorSubCode) {
                    return new AuthenticationException(Objects.toString(errorMsg, BAD_CREDENTIALS), t);
                }
                if (58 == errorSubCode || 59 == errorSubCode || 60 == errorSubCode) {
                    return new AuthenticationException(AUTHENTICATION_TYPE_NOT_AVAILABLE, (Throwable)e);
                }
                return new AuthorizationException(Objects.toString(errorMsg, ACCESS_DENIED), (Throwable)e);
            }
        } else if (t instanceof JCSMPTransportException) {
            Throwable th = t.getCause();
            if (th != null && th instanceof IOException && (NOT_BYTES_TO_READ_MAPPING.equals(th.getMessage()) || GOT_DECODER_EXCEPTION.equals(t.getMessage())) || th.getMessage() != null && th.getMessage().contains(NO_VALID_SMF_HEADER_MAPPING) || th.getMessage() == null) {
                return new ServiceUnreachableException(BAD_HOST_OR_PORT, t);
            }
            if (t.getMessage() != null && t.getMessage().contains(ROUTER_NOT_REACHABLE)) {
                return new ServiceUnreachableException(BAD_HOST_OR_PORT, t);
            }
            if (th != null && th instanceof CertificateException) {
                return new AuthenticationException(BAD_CERTIFICATE, t);
            }
        } else if (t instanceof JCSMPSecurityException) {
            Throwable se = t.getCause();
            if (se != null && se instanceof LoginException) {
                return new AuthenticationException(Objects.toString(se.getMessage(), BAD_LOGIN_CONFIGURATION), t);
            }
            return new AuthenticationException(Objects.toString(t.getMessage(), BAD_LOGIN_CONFIGURATION), t);
        }
        return new PubSubPlusClientException(t);
    }

    @ProviderType
    public static class MessageReplayException
    extends PubSubPlusClientException {
        private static final long serialVersionUID = 6760624644397824212L;

        public MessageReplayException(String message) {
            super(message);
        }

        public MessageReplayException(String message, Throwable t) {
            super(message, t);
        }
    }

    @ProviderType
    public static class ResourceProvisioningException
    extends PubSubPlusClientException {
        private static final long serialVersionUID = 7839312710474925059L;

        public ResourceProvisioningException(String message) {
            super(message);
        }

        public ResourceProvisioningException(String message, Throwable t) {
            super(message, t);
        }
    }

    @ProviderType
    public static class MissingResourceException
    extends PubSubPlusClientException {
        private static final long serialVersionUID = 3777381415318250678L;

        public MissingResourceException(String message) {
            super(message);
        }

        public MissingResourceException(String message, Throwable t) {
            super(message, t);
        }
    }

    @ProviderType
    public static class MessageTooBigException
    extends PubSubPlusClientException {
        private static final long serialVersionUID = 6024258436766748917L;
    }

    @ProviderType
    public static class PublisherOverflowException
    extends PubSubPlusClientException {
        private static final long serialVersionUID = -6288917660636396539L;

        public PublisherOverflowException(String message) {
            super(message);
        }

        public PublisherOverflowException(String message, Throwable t) {
            super(message, t);
        }
    }

    @ProviderType
    public static class MessageNotAcknowledgedByBrokerException
    extends PubSubPlusClientException {
        private static final long serialVersionUID = 2390516172203159454L;
    }

    @ProviderType
    public static class ServiceCapabilityException
    extends PubSubPlusClientException {
        private static final long serialVersionUID = 9169533180273256615L;
        final CapabilityType capabilityType;

        public ServiceCapabilityException(String message, CapabilityType capabilityType) {
            super(message);
            this.capabilityType = capabilityType;
        }

        public CapabilityType getCapabilityType() {
            return this.capabilityType;
        }
    }

    @ProviderType
    public static class MessageRejectedByBrokerException
    extends PubSubPlusClientException {
        private static final long serialVersionUID = -2961451021244629807L;
    }

    @ProviderType
    public static class PubSubPlusClientIOException
    extends PubSubPlusClientException {
        private static final long serialVersionUID = -1636930406878422760L;
    }

    @ProviderType
    public static class UnsupportedAuthorizationException
    extends AuthorizationException {
        public UnsupportedAuthorizationException(String message) {
            super(message);
        }

        public UnsupportedAuthorizationException(String message, Throwable t) {
            super(message, t);
        }
    }

    @ProviderType
    public static class AuthorizationException
    extends PubSubPlusClientException {
        private static final long serialVersionUID = -2315053666285971354L;

        public AuthorizationException(String message) {
            super(message);
        }

        public AuthorizationException(String message, Throwable t) {
            super(message, t);
        }
    }

    @ProviderType
    public static class AuthenticationException
    extends PubSubPlusClientException {
        private static final long serialVersionUID = -4840876322728337412L;

        public AuthenticationException(String message) {
            super(message);
        }

        public AuthenticationException(String message, Throwable t) {
            super(message, t);
        }
    }

    @ProviderType
    public static class ServiceDownException
    extends PubSubPlusClientException {
        private static final long serialVersionUID = 8761735679894818229L;

        public ServiceDownException(String message) {
            super(message);
        }

        public ServiceDownException(String message, Throwable t) {
            super(message, t);
        }

        public ServiceDownException(Throwable t) {
            super(t);
        }
    }

    @ProviderType
    public static class ServiceUnreachableException
    extends PubSubPlusClientException {
        private static final long serialVersionUID = 6202204690166744493L;

        public ServiceUnreachableException(String message) {
            super(message);
        }

        public ServiceUnreachableException(String message, Throwable t) {
            super(message, t);
        }
    }

    @ProviderType
    public static class MessageDestinationDoesNotExistException
    extends PubSubPlusClientException {
        private static final long serialVersionUID = 7488829915435261234L;
    }

    @ProviderType
    public static class IncompatibleMessageException
    extends PubSubPlusClientException {
        private static final long serialVersionUID = 532977146516993030L;

        public IncompatibleMessageException(String message) {
            super(message);
        }

        public IncompatibleMessageException(String message, Throwable t) {
            super(message, t);
        }
    }

    @ProviderType
    public static class IncompleteMessageDeliveryException
    extends PubSubPlusClientException {
        private final int messageCount;
        private static final long serialVersionUID = 8626803921334845411L;

        public IncompleteMessageDeliveryException(String message, int messageCount) {
            super(message);
            this.messageCount = messageCount;
        }

        public IncompleteMessageDeliveryException(String message, Throwable t, int messageCount) {
            super(message, t);
            this.messageCount = messageCount;
        }

        public int getMessageCount() {
            return this.messageCount;
        }
    }

    @ProviderType
    public static class TimeoutException
    extends PubSubPlusClientException {
        private static final long serialVersionUID = 9192386053540587968L;

        public TimeoutException(String message) {
            super(message);
        }
    }

    @ProviderType
    public static class RequestInterruptedException
    extends PubSubPlusClientException {
        private static final long serialVersionUID = -3525620750226544247L;

        public RequestInterruptedException(String message) {
            super(message);
        }

        public RequestInterruptedException(String message, Throwable t) {
            super(message, t);
        }
    }

    @ProviderType
    public static class InvalidConfigurationException
    extends PubSubPlusClientException {
        private static final long serialVersionUID = -3818022594027542040L;

        public InvalidConfigurationException(String message) {
            super(message);
        }

        public InvalidConfigurationException(Throwable t) {
            super(t);
        }

        public InvalidConfigurationException(String message, Throwable t) {
            super(message, t);
        }
    }
}

