/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.resources;

import com.solace.messaging.resources.Destination;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.Validation;
import java.util.Objects;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface TopicSubscription
extends Destination {
    public static TopicSubscription of(String expression) {
        TopicSubscriptionImpl.validateTopicSubscription(expression);
        return new TopicSubscriptionImpl(expression);
    }

    @Internal
    @ProviderType
    public static final class TopicSubscriptionImpl
    implements TopicSubscription {
        private static final long serialVersionUID = -2265160600604389728L;
        private final String expression;

        private TopicSubscriptionImpl(String expression) {
            this.expression = expression;
        }

        @Override
        public String getName() {
            return this.expression;
        }

        public String toString() {
            return "TopicSubscriptionImpl{expression='" + this.expression + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TopicSubscriptionImpl that = (TopicSubscriptionImpl)o;
            return Objects.equals(this.expression, that.expression);
        }

        public int hashCode() {
            return this.expression != null ? this.expression.hashCode() : 0;
        }

        private static void validateTopicSubscription(String name) {
            Validation.nullOrEmptyIllegal(name, "Topic Subscription expression can't be null or empty");
        }
    }
}

