/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.util.internal;

import com.solace.messaging.util.Manageable;
import com.solace.messaging.util.internal.Internal;
import java.util.concurrent.atomic.AtomicLongArray;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public class ApiMetricsCollectorImpl
implements Manageable.ApiMetricsCollector {
    private final AtomicLongArray statTable = new AtomicLongArray(Manageable.ApiMetrics.Metric.values().length);

    @Override
    public long getValue(Manageable.ApiMetrics.Metric theMetric) {
        return this.statTable.get(theMetric.ordinal());
    }

    @Override
    public void reset() {
        for (int i = 0; i < Manageable.ApiMetrics.Metric.values().length; ++i) {
            this.statTable.set(i, 0L);
        }
    }

    @Override
    public void incrementMetric(Manageable.ApiMetrics.Metric metric) {
        this.statTable.incrementAndGet(metric.ordinal());
    }

    @Override
    public void increaseMetric(Manageable.ApiMetrics.Metric metric, long delta) {
        this.statTable.addAndGet(metric.ordinal(), delta);
    }
}

