/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.config.provider;

import com.solace.messaging.config.provider.ReceiverConfigurationProvider;
import com.solace.messaging.config.provider.ReceiverPropertiesConverter;
import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.Validation;
import java.util.Properties;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public class ReceiverMessageSelectorConfigurationProvider
implements ReceiverConfigurationProvider {
    private final Properties configurationSource = new Properties();

    private ReceiverMessageSelectorConfigurationProvider() {
    }

    public static ReceiverMessageSelectorConfigurationProvider messageSelector(String selectorQueryExpression) {
        Validation.nullOrEmptyIllegal(selectorQueryExpression, "selector query expression can't be null or empty");
        ReceiverMessageSelectorConfigurationProvider provider = new ReceiverMessageSelectorConfigurationProvider();
        provider.configurationSource.setProperty("solace.messaging.receiver.persistent.selector-query", selectorQueryExpression);
        return provider;
    }

    @Override
    public TypedProperties getConfiguration() {
        return ReceiverPropertiesConverter.toTypedProperties(this.configurationSource);
    }
}

