/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.publisher;

import com.solace.messaging.Message;
import com.solace.messaging.config.PropertyBasedConfiguration;
import com.solace.messaging.config.profile.ConfigurationProfile;
import com.solace.messaging.config.provider.MessagePropertiesConverter;
import com.solace.messaging.publisher.OutboundMessage;
import com.solace.messaging.util.Converter;
import com.solace.messaging.util.SolaceSDTMap;
import com.solace.messaging.util.SolaceSDTMapToMessageConverter;
import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.OutboundMessageTemplate;
import com.solace.messaging.util.internal.SolaceMessageUtil;
import com.solace.messaging.util.internal.Validation;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.DeliveryMode;
import com.solacesystems.jcsmp.Message;
import com.solacesystems.jcsmp.User_Cos;
import com.solacesystems.jcsmp.XMLMessage;
import com.solacesystems.jcsmp.impl.BytesMessageImpl;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.JCSMPGenericXMLMessage;
import com.solacesystems.jcsmp.impl.MapMessageImpl;
import com.solacesystems.jcsmp.impl.MessageImpl;
import com.solacesystems.jcsmp.impl.StreamMessageImpl;
import com.solacesystems.jcsmp.impl.TextMessageImpl;
import java.io.Serializable;
import java.util.Properties;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface OutboundMessageBuilder
extends PropertyBasedConfiguration {
    @Override
    public OutboundMessageBuilder fromProperties(Properties var1);

    public OutboundMessageBuilder withProperty(String var1, String var2);

    public OutboundMessageBuilder withExpiration(long var1);

    public OutboundMessageBuilder withTimeToLive(long var1);

    public OutboundMessageBuilder withPriority(int var1);

    @Deprecated
    public OutboundMessageBuilder withClassOfService(int var1);

    public OutboundMessageBuilder withApplicationMessageType(String var1);

    @Deprecated
    public OutboundMessageBuilder withApplicationMessageId(String var1);

    public OutboundMessageBuilder withHTTPContentHeader(String var1, String var2);

    public OutboundMessageBuilder withSequenceNumber(long var1);

    public OutboundMessageBuilder withSenderId(String var1);

    public OutboundMessage build(byte[] var1);

    public OutboundMessage build(byte[] var1, Properties var2);

    public OutboundMessage build(String var1);

    public OutboundMessage build(String var1, Properties var2);

    public <T extends Serializable> OutboundMessage build(T var1, Converter.ObjectToBytes<T> var2);

    public <T extends Serializable> OutboundMessage build(T var1, Converter.ObjectToBytes<T> var2, Properties var3);

    public static OutboundMessage deepCopy(OutboundMessage message) throws IllegalArgumentException {
        Validation.nullIllegal(message, "'null' is an illegal message value.");
        if (message instanceof OutboundMessageBuilderImpl.OutboundMessageImpl) {
            BytesXMLMessage originalsInternalMessage = ((OutboundMessageBuilderImpl.OutboundMessageImpl)message).getSolaceMessage();
            if (originalsInternalMessage == null) {
                throw new IllegalArgumentException("Internal message can't be null");
            }
            if (originalsInternalMessage instanceof MessageImpl) {
                MessageImpl internalMessageCopy = OutboundMessageBuilderImpl.OutboundMessageImpl.copyMessageImpl((MessageImpl)originalsInternalMessage);
                return new OutboundMessageBuilderImpl.OutboundMessageImpl((Message)internalMessageCopy);
            }
        }
        throw new IllegalArgumentException("Not supported message type: " + message.getClass());
    }

    public static OutboundMessage deepCopy(OutboundMessage message, Properties extendedMessageProperties) throws IllegalArgumentException {
        Validation.nullIllegal(message, "'null' is an illegal message value.");
        Validation.nullIllegal(extendedMessageProperties, "'null' is an illegal extendedMessageProperties value.");
        OutboundMessageBuilderImpl.OutboundMessageImpl outboundMessageCopy = (OutboundMessageBuilderImpl.OutboundMessageImpl)OutboundMessageBuilder.deepCopy(message);
        if (extendedMessageProperties != null && !extendedMessageProperties.isEmpty()) {
            TypedProperties.ConfigurationProperties allProperties = MessagePropertiesConverter.toMixedProperties(extendedMessageProperties);
            SolaceMessageUtil.addPropertiesToMessage((XMLMessage)outboundMessageCopy.getSolaceMessage(), allProperties);
        }
        return outboundMessageCopy;
    }

    @Internal
    @ProviderType
    public static class OutboundMessageBuilderImpl
    implements OutboundMessageBuilder {
        private final OutboundMessageTemplate outboundMessageTemplate;

        protected OutboundMessageBuilderImpl(ConfigurationProfile activeProfile) {
            this.outboundMessageTemplate = activeProfile.getConfigurationObjectFactory().createOutboundMessageTemplate();
        }

        @Override
        public OutboundMessageBuilder fromProperties(Properties configuration) throws IllegalArgumentException {
            TypedProperties.ConfigurationProperties allProperties = MessagePropertiesConverter.toMixedProperties(configuration);
            this.outboundMessageTemplate.setProperties(allProperties);
            return this;
        }

        @Override
        public OutboundMessageBuilder withProperty(String key, String value) {
            if (MessagePropertiesConverter.isTypedProperty(key)) {
                TypedProperties.ConfigurationProperties solaceMsgProperties = MessagePropertiesConverter.toMixedProperties(key, value);
                this.outboundMessageTemplate.setProperties(solaceMsgProperties);
            } else {
                this.outboundMessageTemplate.setProperty(key, value);
            }
            return this;
        }

        @Override
        public OutboundMessageBuilder withExpiration(long utcTime) throws IllegalArgumentException {
            this.outboundMessageTemplate.setExpiration(utcTime);
            return this;
        }

        @Override
        public OutboundMessageBuilder withTimeToLive(long ttl) throws IllegalArgumentException {
            this.outboundMessageTemplate.setTimeToLive(ttl);
            return this;
        }

        @Override
        public OutboundMessageBuilder withPriority(int priority) throws IllegalArgumentException {
            if (priority < -1 || priority > 255) {
                throw new IllegalArgumentException("Priority value out of range [-1:255]");
            }
            this.outboundMessageTemplate.setPriority(priority);
            return this;
        }

        @Override
        public OutboundMessageBuilder withClassOfService(int cosValue) {
            if (cosValue < 0 || cosValue > User_Cos.values().length - 1) {
                throw new IllegalArgumentException("Class Of Service value out of range [0:2]");
            }
            this.outboundMessageTemplate.setCos(User_Cos.values()[cosValue]);
            return this;
        }

        @Override
        public OutboundMessageBuilder withApplicationMessageType(String applicationMessageType) {
            this.outboundMessageTemplate.setApplicationMessageType(applicationMessageType);
            return this;
        }

        @Override
        public OutboundMessageBuilder withApplicationMessageId(String applicationMessageId) {
            this.outboundMessageTemplate.setApplicationMessageId(applicationMessageId);
            return this;
        }

        @Override
        public OutboundMessageBuilder withHTTPContentHeader(String contentType, String contentEncoding) {
            Validation.nullIllegal(contentType, "'null' is an illegal contentType value.");
            Validation.nullIllegal(contentEncoding, "'null' is an illegal contentEncoding value.");
            this.outboundMessageTemplate.setHTTPContentType(contentType);
            this.outboundMessageTemplate.setHTTPContentEncoding(contentEncoding);
            return this;
        }

        @Override
        public OutboundMessageBuilder withSequenceNumber(long sequenceNumber) {
            this.outboundMessageTemplate.setSequenceNumber(sequenceNumber);
            return this;
        }

        @Override
        public OutboundMessageBuilder withSenderId(String senderId) {
            this.outboundMessageTemplate.setSenderID(senderId);
            return this;
        }

        void forDirectMessagePublisher() {
            this.outboundMessageTemplate.setDeliveryMode(DeliveryMode.DIRECT);
        }

        void forPersistentMessagePublisher() {
            this.outboundMessageTemplate.setDeliveryMode(DeliveryMode.PERSISTENT);
        }

        @Override
        public OutboundMessage build(byte[] payload) {
            return this.build(payload, (Properties)null);
        }

        @Override
        public OutboundMessage build(byte[] payload, Properties extendedMessageProperties) {
            Validation.nullIllegal(payload, "'null' is an illegal payload value.");
            OutboundMessageTemplate templateCopy = OutboundMessageTemplate.copyTemplate(this.outboundMessageTemplate);
            if (this.outboundMessageTemplate.getApplicationMessageId() != null) {
                templateCopy.setApplicationMessageId(this.outboundMessageTemplate.getApplicationMessageId());
            }
            if (extendedMessageProperties != null && !extendedMessageProperties.isEmpty()) {
                TypedProperties.ConfigurationProperties allProperties = MessagePropertiesConverter.toMixedProperties(extendedMessageProperties);
                templateCopy.setProperties(allProperties);
            }
            BytesMessageImpl internalMessageRepresentation = new BytesMessageImpl((BytesXMLMessage)templateCopy);
            internalMessageRepresentation.setData(payload);
            OutboundMessageImpl outboundMessage = new OutboundMessageImpl((Message)internalMessageRepresentation);
            return outboundMessage;
        }

        @Override
        public OutboundMessage build(String payload) {
            return this.build(payload, (Properties)null);
        }

        @Override
        public OutboundMessage build(String payload, Properties extendedMessageProperties) {
            Validation.nullIllegal(payload, "'null' is an illegal payload value.");
            OutboundMessageTemplate templateCopy = OutboundMessageTemplate.copyTemplate(this.outboundMessageTemplate);
            if (this.outboundMessageTemplate.getApplicationMessageId() != null) {
                templateCopy.setApplicationMessageId(this.outboundMessageTemplate.getApplicationMessageId());
            }
            if (extendedMessageProperties != null && !extendedMessageProperties.isEmpty()) {
                TypedProperties.ConfigurationProperties allProperties = MessagePropertiesConverter.toMixedProperties(extendedMessageProperties);
                templateCopy.setProperties(allProperties);
            }
            TextMessageImpl internalMessageRepresentation = new TextMessageImpl((BytesXMLMessage)templateCopy);
            internalMessageRepresentation.setText(payload);
            OutboundMessageImpl outboundMessage = new OutboundMessageImpl((Message)internalMessageRepresentation);
            return outboundMessage;
        }

        @Override
        public <T extends Serializable> OutboundMessage build(T payload, Converter.ObjectToBytes<T> converter) {
            return this.build(payload, converter, null);
        }

        @Override
        public <T extends Serializable> OutboundMessage build(T payload, Converter.ObjectToBytes<T> converter, Properties extendedMessageProperties) {
            Validation.nullIllegal(payload, "'null' is an illegal payload value.");
            Validation.nullIllegal(converter, "'null' is an illegal ObjectToBytes converter value.");
            if (payload instanceof SolaceSDTMap && converter instanceof SolaceSDTMapToMessageConverter) {
                OutboundMessageTemplate templateCopy = OutboundMessageTemplate.copyTemplate(this.outboundMessageTemplate);
                if (this.outboundMessageTemplate.getApplicationMessageId() != null) {
                    templateCopy.setApplicationMessageId(this.outboundMessageTemplate.getApplicationMessageId());
                }
                if (extendedMessageProperties != null && !extendedMessageProperties.isEmpty()) {
                    TypedProperties.ConfigurationProperties allProperties = MessagePropertiesConverter.toMixedProperties(extendedMessageProperties);
                    templateCopy.setProperties(allProperties);
                }
                MapMessageImpl internalMessageRepresentation = new MapMessageImpl((BytesXMLMessage)templateCopy);
                ((SolaceSDTMapToMessageConverter)converter).set((BytesXMLMessage)internalMessageRepresentation, (SolaceSDTMap)payload);
                OutboundMessageImpl outboundMessage = new OutboundMessageImpl((Message)internalMessageRepresentation);
                return outboundMessage;
            }
            return this.build(converter.toBytes(payload), extendedMessageProperties);
        }

        @Internal
        static OutboundMessage injectExtendedMessageProperties(OutboundMessage message, Properties extendedMessageProperties) throws IllegalArgumentException {
            Validation.nullIllegal(message, "'null' is an illegal message value.");
            Validation.nullIllegal(extendedMessageProperties, "'null' is an illegal extendedMessageProperties value.");
            if (message instanceof OutboundMessageImpl) {
                OutboundMessageImpl outboundMessage = (OutboundMessageImpl)message;
                if (extendedMessageProperties != null && !extendedMessageProperties.isEmpty()) {
                    TypedProperties.ConfigurationProperties allProperties = MessagePropertiesConverter.toMixedProperties(extendedMessageProperties);
                    SolaceMessageUtil.addPropertiesToMessage((XMLMessage)outboundMessage.getSolaceMessage(), allProperties);
                }
            }
            return message;
        }

        @Internal
        static OutboundMessage injectCorrelationKey(OutboundMessage message, Object correlationKey) throws IllegalArgumentException {
            Validation.nullIllegal(message, "'null' is an illegal message value.");
            Validation.nullIllegal(correlationKey, "'null' is an illegal correlationKey value.");
            if (message instanceof OutboundMessageImpl) {
                OutboundMessageImpl outboundMessage = (OutboundMessageImpl)message;
                if (correlationKey != null) {
                    outboundMessage.getSolaceMessage().setCorrelationKey(correlationKey);
                }
            }
            return message;
        }

        @Internal
        static OutboundMessage injectAckImmediately(OutboundMessage message, boolean ackImmediately) throws IllegalArgumentException {
            Validation.nullIllegal(message, "'null' is an illegal message value.");
            if (message instanceof OutboundMessageImpl) {
                OutboundMessageImpl outboundMessage = (OutboundMessageImpl)message;
                outboundMessage.getSolaceMessage().setAckImmediately(ackImmediately);
            }
            return message;
        }

        @Internal
        static OutboundMessage injectDeliveryMode(OutboundMessage message, DeliveryMode deliveryMode) throws IllegalArgumentException {
            OutboundMessageImpl outboundMessage;
            Validation.nullIllegal(message, "'null' is an illegal message value.");
            Validation.nullIllegal(deliveryMode, "'null' is an illegal deliveryMode value.");
            if (message instanceof OutboundMessageImpl && (outboundMessage = (OutboundMessageImpl)message).getSolaceMessage() != null) {
                outboundMessage.getSolaceMessage().setDeliveryMode(deliveryMode);
            }
            return message;
        }

        @Internal
        @ProviderType
        static class OutboundMessageImpl
        extends Message.SolaceMessageImpl
        implements OutboundMessage {
            private static final long serialVersionUID = 8928003160399642314L;

            OutboundMessageImpl(Message solaceMessage) {
                super((BytesXMLMessage)solaceMessage);
            }

            @Internal
            private BytesXMLMessage getSolaceMessage() {
                return this.solaceMessage;
            }

            @Internal
            static MessageImpl copyMessageImpl(MessageImpl toClone) {
                BytesXMLMessage wrappedMessage = toClone.getWrappedMessage();
                if (wrappedMessage instanceof JCSMPGenericXMLMessage) {
                    JCSMPGenericXMLMessage copy = JCSMPBasicSession.createGenericXMLMessage((JCSMPGenericXMLMessage)((JCSMPGenericXMLMessage)wrappedMessage), (boolean)true, (boolean)false);
                    if (toClone instanceof BytesMessageImpl) {
                        return new BytesMessageImpl((BytesXMLMessage)copy);
                    }
                    if (toClone instanceof TextMessageImpl) {
                        return new TextMessageImpl((BytesXMLMessage)copy);
                    }
                    if (toClone instanceof MapMessageImpl) {
                        return new MapMessageImpl((BytesXMLMessage)copy);
                    }
                    if (toClone instanceof StreamMessageImpl) {
                        StreamMessageImpl streamMsg = new StreamMessageImpl((BytesXMLMessage)copy);
                        streamMsg.getStream();
                        return streamMsg;
                    }
                }
                throw new IllegalArgumentException("Not supported message type :" + wrappedMessage.getClass());
            }

            static BytesXMLMessage toByteMessage(OutboundMessage message) {
                if (message instanceof OutboundMessageImpl) {
                    return ((OutboundMessageImpl)message).solaceMessage;
                }
                throw new IllegalArgumentException("Not supported message type " + message.getClass());
            }
        }
    }
}

