/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.receiver;

import com.solace.messaging.Message;
import com.solace.messaging.PubSubPlusClientException;
import com.solace.messaging.receiver.InboundMessage;
import com.solace.messaging.util.AsyncLifecycleControl;
import com.solace.messaging.util.Converter;
import com.solace.messaging.util.LifecycleControl;
import com.solace.messaging.util.ManageableReceiver;
import com.solace.messaging.util.MessageToSDTMapConverter;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.Validation;
import com.solacesystems.jcsmp.BytesMessage;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPNotComparableException;
import com.solacesystems.jcsmp.ReplicationGroupMessageId;
import com.solacesystems.jcsmp.XMLMessage;
import com.solacesystems.jcsmp.impl.BytesMessageImpl;
import com.solacesystems.jcsmp.impl.JCSMPGenericXMLMessage;
import com.solacesystems.jcsmp.impl.ReplicationGroupMessageIdImpl;
import com.solacesystems.jcsmp.impl.TextMessageImpl;
import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface MessageReceiver
extends LifecycleControl,
AsyncLifecycleControl,
ManageableReceiver {
    @Override
    public MessageReceiver start() throws PubSubPlusClientException, IllegalStateException;

    public <MessageReceiver> CompletableFuture<MessageReceiver> startAsync() throws PubSubPlusClientException, IllegalStateException;

    public void setReceiveFailureListener(ReceiveFailureListener var1);

    @Internal
    @ProviderType
    public static class InboundMessageImpl
    extends Message.SolaceMessageImpl
    implements InboundMessage {
        private static final long serialVersionUID = 3942883399970901822L;
        private final InboundMessage.MessageDiscardNotification discardNotification;
        private final AtomicBoolean internalDiscardIndicator = new AtomicBoolean(false);

        protected InboundMessageImpl(BytesXMLMessage solaceMessage) {
            super(solaceMessage);
            this.discardNotification = new InboundMessage.MessageDiscardNotification(){
                private static final long serialVersionUID = 5255957937771863494L;
                final AtomicBoolean d;
                {
                    this.d = internalDiscardIndicator;
                }

                public String toString() {
                    return "MessageDiscardNotification{hasBrokerDiscardIndication=" + this.hasBrokerDiscardIndication() + ", hasInternalDiscardIndication=" + this.hasInternalDiscardIndication() + '}';
                }

                @Override
                public boolean hasBrokerDiscardIndication() {
                    return solaceMessage.getDiscardIndication();
                }

                @Override
                public boolean hasInternalDiscardIndication() {
                    return this.d.get();
                }
            };
        }

        public void indicateDiscard() {
            this.internalDiscardIndicator.set(true);
        }

        @Override
        public boolean isRedelivered() {
            return this.solaceMessage.getRedelivered();
        }

        @Override
        public InboundMessage.MessageDiscardNotification getMessageDiscardNotification() {
            return this.discardNotification;
        }

        @Override
        public <T extends Serializable> T getAndConvertPayload(Converter.BytesToObject<T> converter, Class<T> outputType) {
            Validation.nullIllegal(converter, "Converter can't be null");
            Validation.nullIllegal(outputType, "Output type parameter can't be null");
            if (converter instanceof MessageToSDTMapConverter) {
                MessageToSDTMapConverter sdtConverter = (MessageToSDTMapConverter)converter;
                return (T)sdtConverter.get(this.solaceMessage);
            }
            if (this.solaceMessage instanceof BytesMessage) {
                byte[] b = ((BytesMessage)this.solaceMessage).getData();
                return converter.convert(b);
            }
            throw new PubSubPlusClientException.IncompatibleMessageException("Incompatible message, provided converter can't be used");
        }

        @Override
        public String getDestinationName() {
            Destination d = this.solaceMessage.getDestination();
            return d != null ? d.getName() : null;
        }

        @Override
        public long getTimeStamp() {
            return this.solaceMessage.getReceiveTimestamp();
        }

        @Override
        public boolean isCached() {
            return this.solaceMessage.isCacheMessage();
        }

        @Override
        public InboundMessage.ReplicationGroupMessageId getReplicationGroupMessageId() {
            ReplicationGroupMessageId rgmid = this.solaceMessage.getReplicationGroupMessageId();
            if (rgmid == null) {
                return null;
            }
            return InboundMessage.ReplicationGroupMessageId.of(rgmid.toString());
        }

        @Override
        public int getClassOfService() {
            return this.solaceMessage.getCos() != null ? this.solaceMessage.getCos().value() : 0;
        }

        @Override
        public String getApplicationMessageType() {
            return this.solaceMessage.getApplicationMessageType();
        }

        @Override
        public Long getSenderTimestamp() {
            return this.solaceMessage.getSenderTimestamp();
        }

        @Override
        public String getSenderId() {
            return this.solaceMessage.getSenderId();
        }

        @Override
        public String toString() {
            return "InboundMessage{, discardNotification=" + this.discardNotification + ", solaceMessage=" + this.solaceMessage.dump() + '}';
        }

        void doAck() {
            this.solaceMessage.ackMessage();
        }

        void settle(XMLMessage.Outcome outcome) throws JCSMPException {
            this.solaceMessage.settle(outcome);
        }

        public static InboundMessage toInboundMessage(BytesXMLMessage rawMessage) throws PubSubPlusClientException {
            return new InboundMessageImpl(rawMessage);
        }

        @Internal
        @ProviderType
        static class ReplicationGroupMessageIdImpl
        implements InboundMessage.ReplicationGroupMessageId {
            private static final String RMID_NULL = "Replication Group Message ID is null";
            private final ReplicationGroupMessageId mRmid;

            private ReplicationGroupMessageIdImpl(ReplicationGroupMessageId rmid) {
                this.mRmid = rmid;
            }

            static InboundMessage.ReplicationGroupMessageId create(String replicationGroupMessageIdString) throws IllegalArgumentException {
                if (replicationGroupMessageIdString == null) {
                    throw new NullPointerException(RMID_NULL);
                }
                try {
                    return new ReplicationGroupMessageIdImpl(com.solacesystems.jcsmp.impl.ReplicationGroupMessageIdImpl.createReplicationGroupMessageId((String)replicationGroupMessageIdString));
                }
                catch (JCSMPException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
            }

            @Override
            public int compare(InboundMessage.ReplicationGroupMessageId replicationGroupMessageId) throws IllegalArgumentException {
                try {
                    return this.mRmid.compare(((ReplicationGroupMessageIdImpl)replicationGroupMessageId).mRmid);
                }
                catch (JCSMPNotComparableException | ClassCastException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
            }

            @Override
            public String toString() {
                return this.mRmid.toString();
            }
        }
    }

    @ProviderType
    public static class FailedReceiveEvent
    implements Serializable {
        private final long timeStamp;
        private final PubSubPlusClientException exception;

        public FailedReceiveEvent(PubSubPlusClientException exception, long timeStamp) {
            this.timeStamp = timeStamp;
            this.exception = exception;
        }

        public FailedReceiveEvent(PubSubPlusClientException exception) {
            this(exception, Instant.now().toEpochMilli());
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public PubSubPlusClientException getException() {
            return this.exception;
        }

        public String toString() {
            return "FailedReceiveEvent{timeStamp=" + this.timeStamp + ", exception=" + this.exception + '}';
        }
    }

    public static interface ReceiveFailureListener {
        public void onFailedReceive(FailedReceiveEvent var1);
    }

    @ProviderType
    public static interface InboundMessageSupplier
    extends Supplier<InboundMessage> {
        public static InboundMessageSupplier nullMessageSupplier() {
            return () -> null;
        }

        public static InboundMessageSupplier byteMessageSupplier(byte[] payload) {
            return () -> {
                JCSMPGenericXMLMessage lowLevelMessage = new JCSMPGenericXMLMessage(4096){};
                BytesMessageImpl bytesMessage = new BytesMessageImpl((BytesXMLMessage)lowLevelMessage);
                bytesMessage.setData(payload);
                InboundMessageImpl message = new InboundMessageImpl((BytesXMLMessage)bytesMessage);
                return message;
            };
        }

        public static InboundMessageSupplier stringMessageSupplier(String payload) {
            return () -> {
                JCSMPGenericXMLMessage lowLevelMessage = new JCSMPGenericXMLMessage(4096){};
                TextMessageImpl textMessage = new TextMessageImpl((BytesXMLMessage)lowLevelMessage);
                textMessage.setText(payload);
                InboundMessageImpl message = new InboundMessageImpl((BytesXMLMessage)textMessage);
                return message;
            };
        }
    }

    @FunctionalInterface
    public static interface MessageHandler {
        public void onMessage(InboundMessage var1);
    }
}

