/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.receiver;

import com.solace.messaging.PubSubPlusClientException;
import com.solace.messaging.publisher.OutboundMessage;
import com.solace.messaging.receiver.InboundMessage;
import com.solace.messaging.receiver.MessageReceiver;
import com.solace.messaging.resources.Destination;
import com.solace.messaging.util.CompletionListener;
import java.io.Serializable;
import java.time.Instant;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface RequestReplyMessageReceiver
extends MessageReceiver {
    @Override
    public RequestReplyMessageReceiver start() throws PubSubPlusClientException;

    public <RequestReplyMessageReceiver> CompletableFuture<RequestReplyMessageReceiver> startAsync();

    public <RequestReplyMessageReceiver> void startAsync(CompletionListener<RequestReplyMessageReceiver> var1) throws PubSubPlusClientException, IllegalStateException;

    public void receiveMessage(RequestMessageHandler var1) throws PubSubPlusClientException;

    public void receiveMessage(RequestMessageHandler var1, long var2) throws PubSubPlusClientException;

    public void receiveAsync(RequestMessageHandler var1) throws PubSubPlusClientException;

    public void receiveAsync(RequestMessageHandler var1, ExecutorService var2) throws PubSubPlusClientException;

    public void setReplyFailureListener(ReplyFailureListener var1);

    @ProviderType
    public static class FailedReplyEvent
    implements Serializable {
        private static final long serialVersionUID = -6259777861655945170L;
        private final OutboundMessage replyMessage;
        private final InboundMessage requestMessage;
        final Destination destination;
        private final long timeStamp;
        private final PubSubPlusClientException exception;

        FailedReplyEvent(InboundMessage requestMessage, OutboundMessage replyMessage, Destination destination, PubSubPlusClientException exception, long timeStamp) {
            this.requestMessage = requestMessage;
            this.replyMessage = replyMessage;
            this.destination = destination;
            this.timeStamp = timeStamp;
            this.exception = exception;
        }

        FailedReplyEvent(InboundMessage requestMessage, OutboundMessage replyMessage, Destination destination, PubSubPlusClientException exception) {
            this(requestMessage, replyMessage, destination, exception, Instant.now().toEpochMilli());
        }

        public InboundMessage getRequestMessage() {
            return this.requestMessage;
        }

        public OutboundMessage getReplyMessage() {
            return this.replyMessage;
        }

        public Destination getDestination() {
            return this.destination;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public PubSubPlusClientException getException() {
            return this.exception;
        }

        public String toString() {
            return "FailedReplyEvent{destination=" + this.destination + ", timeStamp=" + this.timeStamp + ", exception=" + this.exception + '}';
        }
    }

    public static interface ReplyFailureListener {
        public void onFailedReply(FailedReplyEvent var1);
    }

    public static interface Replier {
        public void reply(OutboundMessage var1) throws PubSubPlusClientException.PublisherOverflowException, PubSubPlusClientException, IllegalStateException;

        public void reply(OutboundMessage var1, Properties var2) throws PubSubPlusClientException.PublisherOverflowException, PubSubPlusClientException, IllegalStateException;
    }

    @FunctionalInterface
    public static interface RequestMessageHandler {
        public void onMessage(InboundMessage var1, Replier var2);
    }
}

