/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.trace.propagation;

import com.solace.messaging.trace.propagation.MessageTracingSupport;
import com.solace.messaging.trace.propagation.TraceContext;
import io.opentelemetry.api.internal.OtelEncodingUtils;
import io.opentelemetry.api.internal.TemporaryBuffers;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.context.propagation.TextMapGetter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SolaceJCSMPTextMapGetter
implements TextMapGetter<Object> {
    private static final Logger logger = Logger.getLogger(SolaceJCSMPTextMapGetter.class.getName());
    private static final String VERSION = "00";
    private static final int VERSION_SIZE = 2;
    private static final char TRACEPARENT_DELIMITER = '-';
    private static final int TRACEPARENT_DELIMITER_SIZE = 1;
    private static final int TRACE_ID_HEX_SIZE = TraceId.getLength();
    private static final int SPAN_ID_HEX_SIZE = SpanId.getLength();
    private static final int TRACE_OPTION_HEX_SIZE = TraceFlags.getLength();
    private static final int TRACE_ID_OFFSET = 3;
    private static final int SPAN_ID_OFFSET = 3 + TRACE_ID_HEX_SIZE + 1;
    private static final int TRACE_OPTION_OFFSET = SPAN_ID_OFFSET + SPAN_ID_HEX_SIZE + 1;
    private static final int TRACEPARENT_HEADER_SIZE = TRACE_OPTION_OFFSET + TRACE_OPTION_HEX_SIZE;
    private static final List<String> FIELDS = Collections.unmodifiableList(Arrays.asList("tracestate", "traceparent", "baggage"));
    private static final String SAMPLED_HEX;
    private static final String DEFAULT_HEX;

    public Iterable<String> keys(Object carrier) {
        return FIELDS;
    }

    public String get(Object m, String key) {
        if (null == key || key.isEmpty()) {
            return null;
        }
        if (!(m instanceof MessageTracingSupport)) {
            logger.finest("Invalid trace carrier, key not retrieved");
            return null;
        }
        MessageTracingSupport messageWithTracingSupport = (MessageTracingSupport)m;
        if ("traceparent".equals(key)) {
            return this.extractContext(messageWithTracingSupport);
        }
        if ("tracestate".equals(key)) {
            return this.extractTraceState(messageWithTracingSupport);
        }
        if ("baggage".equals(key) && messageWithTracingSupport.baggage() != null) {
            return messageWithTracingSupport.baggage().getBaggage();
        }
        return null;
    }

    private String extractContext(MessageTracingSupport messageWithTracingSupport) {
        try {
            TraceContext transportContext = messageWithTracingSupport.transportContext();
            String transportContextString = this.traceContextAsString(transportContext);
            if (transportContextString != null && !transportContextString.isEmpty()) {
                return transportContextString;
            }
            TraceContext creationContext = messageWithTracingSupport.creationContext();
            String creationContextString = this.traceContextAsString(creationContext);
            if (creationContextString != null && !creationContextString.isEmpty()) {
                return creationContextString;
            }
            return null;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to retrieve trace parent as string from MessageWithTracingSupport", e);
            return null;
        }
    }

    private String traceContextAsString(TraceContext traceContext) {
        if (traceContext == null || traceContext.getTraceIdBytes16() == null || traceContext.getSpanIdBytes8() == null) {
            return null;
        }
        byte[] tracingIdBytes = traceContext.getTraceIdBytes16();
        byte[] spanIdBytes = traceContext.getSpanIdBytes8();
        boolean sampledBool = traceContext.isSampled();
        char[] rawArray = new char[TRACEPARENT_HEADER_SIZE];
        TemporaryBuffers.chars((int)TRACEPARENT_HEADER_SIZE);
        rawArray[0] = VERSION.charAt(0);
        rawArray[1] = VERSION.charAt(1);
        rawArray[2] = 45;
        String traceId = SolaceJCSMPTextMapGetter.traceIdToString(tracingIdBytes);
        SolaceJCSMPTextMapGetter.toCharArray(traceId, 0, rawArray, 3, traceId.length());
        rawArray[SolaceJCSMPTextMapGetter.SPAN_ID_OFFSET - 1] = 45;
        String spanId = SolaceJCSMPTextMapGetter.spanIdToString(spanIdBytes);
        SolaceJCSMPTextMapGetter.toCharArray(spanId, 0, rawArray, SPAN_ID_OFFSET, spanId.length());
        rawArray[SolaceJCSMPTextMapGetter.TRACE_OPTION_OFFSET - 1] = 45;
        boolean sampled = sampledBool;
        String traceFlagsHex = sampled ? SAMPLED_HEX : DEFAULT_HEX;
        rawArray[SolaceJCSMPTextMapGetter.TRACE_OPTION_OFFSET] = traceFlagsHex.charAt(0);
        rawArray[SolaceJCSMPTextMapGetter.TRACE_OPTION_OFFSET + 1] = traceFlagsHex.charAt(1);
        return new String(rawArray, 0, TRACEPARENT_HEADER_SIZE);
    }

    private String extractTraceState(MessageTracingSupport messageWithTracingSupport) {
        String s;
        String traceState = null;
        if (messageWithTracingSupport.transportContext() != null && (s = messageWithTracingSupport.transportContext().getTraceState()) != null && !s.isEmpty()) {
            traceState = s;
        }
        if (messageWithTracingSupport.creationContext() != null && (s = messageWithTracingSupport.creationContext().getTraceState()) != null && !s.isEmpty()) {
            traceState = traceState != null && !traceState.equals(s) ? traceState + "," + s : s;
        }
        return traceState;
    }

    private static String traceIdToString(byte[] traceId) {
        return TraceId.fromBytes((byte[])traceId);
    }

    private static String spanIdToString(byte[] traceId) {
        return SpanId.fromBytes((byte[])traceId);
    }

    private static void toCharArray(String s, int srcBegin, char[] dest, int dstBegin, int length) {
        char[] c = s.toCharArray();
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (length > c.length) {
            throw new StringIndexOutOfBoundsException(length);
        }
        System.arraycopy(c, srcBegin, dest, dstBegin, length);
    }

    static {
        char[] r1 = new char[2];
        OtelEncodingUtils.byteToBase16((byte)1, (char[])r1, (int)0);
        SAMPLED_HEX = new String(r1);
        char[] r2 = new char[2];
        OtelEncodingUtils.byteToBase16((byte)0, (char[])r2, (int)0);
        DEFAULT_HEX = new String(r2);
    }
}

