/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.trace.propagation;

import com.solace.messaging.trace.propagation.MessageTracingSupport;
import com.solace.messaging.trace.propagation.SpanContextUtil;
import com.solace.messaging.trace.propagation.TraceContextSetter;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.propagation.BaggageUtil;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.api.trace.propagation.internal.W3CTraceContextEncoding;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SolaceJCSMPTextMapSetter
implements TextMapSetter<Object> {
    private static final Logger logger = Logger.getLogger(SolaceJCSMPTextMapSetter.class.getName());
    static final String TRACE_PARENT = "traceparent";
    static final String TRACE_STATE = "tracestate";
    static final String BAGGAGE = "baggage";

    public void set(Object m, String key, String value) {
        if (m == null || key == null || value == null || key.isEmpty() || value.isEmpty()) {
            return;
        }
        if (!(m instanceof MessageTracingSupport)) {
            logger.finest("Invalid trace carrier, key not set");
            return;
        }
        MessageTracingSupport messageWithTracingSupport = (MessageTracingSupport)m;
        if (TRACE_PARENT.equals(key)) {
            this.injectContext(value, messageWithTracingSupport);
        } else if (TRACE_STATE.equals(key)) {
            this.injectTraceState(value, messageWithTracingSupport);
        } else if (BAGGAGE.equals(key)) {
            this.injectBaggage(value, messageWithTracingSupport);
        }
    }

    private void injectContext(String toInject, MessageTracingSupport messageWithTracingSupport) {
        try {
            SpanContext sc = SpanContextUtil.fromString(toInject);
            if (SpanContext.getInvalid().equals(sc)) {
                logger.finest("Invalid span context detected, won't be injected into a Solace message");
                return;
            }
            TraceContextSetter contextSetter = messageWithTracingSupport.contextSetter();
            if (contextSetter != null) {
                contextSetter.setTraceIdBytes16(sc.getTraceIdBytes());
                contextSetter.setSpanIdBytes8(sc.getSpanIdBytes());
                contextSetter.setSampled(sc.isSampled());
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Trace parent injection failed.", e);
        }
    }

    private void injectTraceState(String toInject, MessageTracingSupport messageWithTracingSupport) {
        try {
            TraceState traceState = W3CTraceContextEncoding.decodeTraceState((String)toInject);
            String encodedTraceState = W3CTraceContextEncoding.encodeTraceState((TraceState)traceState);
            TraceContextSetter contextSetter = messageWithTracingSupport.contextSetter();
            if (contextSetter != null) {
                contextSetter.setTraceState(encodedTraceState);
            } else {
                logger.log(Level.WARNING, "Trace state injection failed as trace context doesn't exist");
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Trace state injection failed: ", e);
        }
    }

    private void injectBaggage(String toInject, MessageTracingSupport messageWithTracingSupport) {
        try {
            Baggage baggage = BaggageUtil.extractBaggage(toInject);
            if (baggage != null) {
                String encodedBaggage = BaggageUtil.baggageToString(baggage);
                messageWithTracingSupport.baggage().setBaggage(encodedBaggage);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Baggage injection failed: ", e);
        }
    }
}

