/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.trace.propagation;

import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SpanContextUtil {
    private static final Logger logger = Logger.getLogger(SpanContextUtil.class.getName());
    private static final Set<String> VALID_VERSIONS = new HashSet<String>();
    private static final MethodHandle EXTRACT_CONTEXT_FROM_TRACE_METHOD;

    private SpanContextUtil() {
    }

    public static SpanContext fromString(String spanContextAsString) {
        if (spanContextAsString == null || spanContextAsString.isEmpty()) {
            return null;
        }
        try {
            return EXTRACT_CONTEXT_FROM_TRACE_METHOD.invokeExact(spanContextAsString);
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "Span context decoding failed: ", throwable);
            return null;
        }
    }

    static {
        for (int i = 0; i < 255; ++i) {
            String version = Long.toHexString(i);
            if (version.length() < 2) {
                version = '0' + version;
            }
            VALID_VERSIONS.add(version);
        }
        Class<W3CTraceContextPropagator> propagatorClass = W3CTraceContextPropagator.class;
        try {
            Method extractContextFromTraceParentMethod = propagatorClass.getDeclaredMethod("extractContextFromTraceParent", String.class);
            extractContextFromTraceParentMethod.setAccessible(true);
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            EXTRACT_CONTEXT_FROM_TRACE_METHOD = lookup.unreflect(extractContextFromTraceParentMethod);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

