/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.baggage.propagation;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.baggage.BaggageEntry;
import io.opentelemetry.api.baggage.propagation.Parser;
import io.opentelemetry.api.internal.PercentEscaper;
import io.opentelemetry.api.internal.StringUtils;

public class BaggageUtil {
    private static final PercentEscaper URL_ESCAPER = PercentEscaper.create();

    private BaggageUtil() {
    }

    public static Baggage extractBaggage(String baggageAsString) {
        if (baggageAsString == null) {
            return null;
        }
        BaggageBuilder baggageBuilder = Baggage.builder();
        try {
            new Parser(baggageAsString).parseInto(baggageBuilder);
            return baggageBuilder.build();
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static String baggageToString(Baggage baggage) {
        if (baggage == null) {
            return null;
        }
        StringBuilder headerContent = new StringBuilder();
        baggage.forEach((key, baggageEntry) -> {
            if (BaggageUtil.baggageIsInvalid(key, baggageEntry)) {
                return;
            }
            headerContent.append((String)key).append("=").append(BaggageUtil.encodeValue(baggageEntry.getValue()));
            String metadataValue = baggageEntry.getMetadata().getValue();
            if (metadataValue != null && !metadataValue.isEmpty()) {
                headerContent.append(";").append(BaggageUtil.encodeValue(metadataValue));
            }
            headerContent.append(",");
        });
        if (headerContent.length() == 0) {
            return "";
        }
        headerContent.setLength(headerContent.length() - 1);
        return headerContent.toString();
    }

    private static String encodeValue(String value) {
        return URL_ESCAPER.escape(value);
    }

    private static boolean baggageIsInvalid(String key, BaggageEntry baggageEntry) {
        return !BaggageUtil.isValidBaggageKey(key) || baggageEntry.getValue() == null;
    }

    private static boolean isValidBaggageKey(String name) {
        return name != null && !name.isEmpty() && StringUtils.isPrintableString((String)name);
    }
}

