/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.trace.propagation;

import com.solace.messaging.trace.propagation.internal.ClassLoaderReflectionUtil;
import io.opentelemetry.context.propagation.TextMapGetter;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SolaceJCSMPTextMapGetter
implements TextMapGetter<Object> {
    private static final Logger logger = Logger.getLogger(SolaceJCSMPTextMapGetter.class.getName());

    public Iterable<String> keys(Object carrier) {
        return Collections.unmodifiableList(Arrays.asList("tracestate", "traceparent", "baggage"));
    }

    public String get(Object m, String key) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        Object messageWithTracingSupport = ClassLoaderReflectionUtil.getSolMessageWithTracingSupport(m);
        if (messageWithTracingSupport == null) {
            logger.log(Level.FINEST, "Invalid trace carrier, key not retrieved");
            return null;
        }
        switch (key) {
            case "traceparent": {
                return ClassLoaderReflectionUtil.getTraceParentAsString(messageWithTracingSupport);
            }
            case "tracestate": {
                return ClassLoaderReflectionUtil.getTraceStateAsString(messageWithTracingSupport);
            }
            case "baggage": {
                return ClassLoaderReflectionUtil.getBaggageAsString(messageWithTracingSupport);
            }
        }
        return null;
    }
}

