/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.trace.propagation;

import com.solace.messaging.trace.propagation.internal.ClassLoaderReflectionUtil;
import com.solace.messaging.trace.propagation.internal.SpanContextUtil;
import com.solace.messaging.trace.propagation.internal.TraceStateUtil;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.propagation.BaggageUtil;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SolaceJCSMPTextMapSetter
implements TextMapSetter<Object> {
    private static final Logger logger = Logger.getLogger(SolaceJCSMPTextMapSetter.class.getName());
    static final String TRACE_PARENT = "traceparent";
    static final String TRACE_STATE = "tracestate";
    static final String BAGGAGE = "baggage";

    public void set(Object m, String key, String value) {
        if (m == null || key == null || value == null || key.isEmpty() || value.isEmpty()) {
            return;
        }
        Object messageWithTracingSupport = ClassLoaderReflectionUtil.getSolMessageWithTracingSupport(m);
        if (messageWithTracingSupport == null) {
            logger.log(Level.FINEST, "Invalid trace carrier, key not set");
            return;
        }
        try {
            switch (key) {
                case "traceparent": {
                    SpanContext sc = SpanContextUtil.fromString(value);
                    if (sc.isValid()) {
                        ClassLoaderReflectionUtil.injectSpanContext(messageWithTracingSupport, sc);
                        break;
                    }
                    logger.log(Level.FINEST, "Invalid span context detected, will not be injected into a Solace message");
                    break;
                }
                case "tracestate": {
                    TraceState ts = TraceStateUtil.decodeTraceState(value);
                    ClassLoaderReflectionUtil.injectTraceState(messageWithTracingSupport, ts);
                    break;
                }
                case "baggage": {
                    Baggage baggage = BaggageUtil.extractBaggage(value);
                    ClassLoaderReflectionUtil.injectBaggage(messageWithTracingSupport, baggage);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, key + " injection failed.", e);
        }
    }
}

