/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.trace.propagation.internal;

import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.api.trace.TraceState;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SpanContextUtil {
    private static final Logger logger = Logger.getLogger(SpanContextUtil.class.getName());
    private static final Set<String> VALID_VERSIONS;
    private static final String VERSION_00 = "00";
    private static final int VERSION_SIZE = 2;
    private static final char TRACEPARENT_DELIMITER = '-';
    private static final int TRACEPARENT_DELIMITER_SIZE = 1;
    private static final int TRACE_ID_HEX_SIZE;
    private static final int SPAN_ID_HEX_SIZE;
    private static final int TRACE_OPTION_HEX_SIZE;
    private static final int TRACE_ID_OFFSET = 3;
    private static final int SPAN_ID_OFFSET;
    private static final int TRACE_OPTION_OFFSET;
    private static final int TRACEPARENT_HEADER_SIZE;
    private static final byte[] DECODING;
    private static final boolean[] VALID_HEX;
    private static final int NUM_ASCII_CHARACTERS = 128;
    private static final String ALPHABET = "0123456789abcdef";

    private SpanContextUtil() {
    }

    public static SpanContext fromString(String spanContextString) {
        if (spanContextString == null || spanContextString.isEmpty()) {
            return null;
        }
        try {
            return SpanContextUtil.extractContextFromTraceParent(spanContextString);
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "Span context decoding failed: ", throwable);
            return null;
        }
    }

    private static SpanContext extractContextFromTraceParent(String traceparent) {
        boolean isValid;
        boolean bl = isValid = (traceparent.length() == TRACEPARENT_HEADER_SIZE || traceparent.length() > TRACEPARENT_HEADER_SIZE && traceparent.charAt(TRACEPARENT_HEADER_SIZE) == '-') && traceparent.charAt(2) == '-' && traceparent.charAt(SPAN_ID_OFFSET - 1) == '-' && traceparent.charAt(TRACE_OPTION_OFFSET - 1) == '-';
        if (!isValid) {
            logger.fine("Unparseable traceparent header. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        String version = traceparent.substring(0, 2);
        if (!VALID_VERSIONS.contains(version)) {
            return SpanContext.getInvalid();
        }
        if (version.equals(VERSION_00) && traceparent.length() > TRACEPARENT_HEADER_SIZE) {
            return SpanContext.getInvalid();
        }
        String traceId = traceparent.substring(3, 3 + TraceId.getLength());
        String spanId = traceparent.substring(SPAN_ID_OFFSET, SPAN_ID_OFFSET + SpanId.getLength());
        char firstTraceFlagsChar = traceparent.charAt(TRACE_OPTION_OFFSET);
        char secondTraceFlagsChar = traceparent.charAt(TRACE_OPTION_OFFSET + 1);
        if (!SpanContextUtil.isValidBase16Character(firstTraceFlagsChar) || !SpanContextUtil.isValidBase16Character(secondTraceFlagsChar)) {
            return SpanContext.getInvalid();
        }
        TraceFlags traceFlags = TraceFlags.fromByte((byte)SpanContextUtil.byteFromBase16(firstTraceFlagsChar, secondTraceFlagsChar));
        return SpanContext.createFromRemoteParent((String)traceId, (String)spanId, (TraceFlags)traceFlags, (TraceState)TraceState.getDefault());
    }

    private static boolean[] buildValidHexArray() {
        boolean[] validHex = new boolean[65535];
        for (int i = 0; i < 65535; ++i) {
            validHex[i] = 48 <= i && i <= 57 || 97 <= i && i <= 102;
        }
        return validHex;
    }

    public static boolean isValidBase16Character(char b) {
        return VALID_HEX[b];
    }

    public static byte byteFromBase16(char first, char second) {
        if (first >= '\u0080' || DECODING[first] == -1) {
            throw new IllegalArgumentException("invalid character " + first);
        }
        if (second >= '\u0080' || DECODING[second] == -1) {
            throw new IllegalArgumentException("invalid character " + second);
        }
        int decoded = DECODING[first] << 4 | DECODING[second];
        return (byte)decoded;
    }

    private static byte[] buildDecodingArray() {
        byte[] decoding = new byte[128];
        Arrays.fill(decoding, (byte)-1);
        for (int i = 0; i < ALPHABET.length(); ++i) {
            char c = ALPHABET.charAt(i);
            decoding[c] = (byte)i;
        }
        return decoding;
    }

    static {
        TRACE_ID_HEX_SIZE = TraceId.getLength();
        SPAN_ID_HEX_SIZE = SpanId.getLength();
        TRACE_OPTION_HEX_SIZE = TraceFlags.getLength();
        SPAN_ID_OFFSET = 3 + TRACE_ID_HEX_SIZE + 1;
        TRACE_OPTION_OFFSET = SPAN_ID_OFFSET + SPAN_ID_HEX_SIZE + 1;
        TRACEPARENT_HEADER_SIZE = TRACE_OPTION_OFFSET + TRACE_OPTION_HEX_SIZE;
        DECODING = SpanContextUtil.buildDecodingArray();
        VALID_HEX = SpanContextUtil.buildValidHexArray();
        VALID_VERSIONS = new HashSet<String>();
        for (int i = 0; i < 255; ++i) {
            String version = Long.toHexString(i);
            if (version.length() < 2) {
                version = '0' + version;
            }
            VALID_VERSIONS.add(version);
        }
    }
}

