/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.trace.propagation.internal;

import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.api.trace.TraceStateBuilder;
import java.util.regex.Pattern;

public class TraceStateUtil {
    private static final int TRACESTATE_MAX_SIZE = 512;
    private static final int TRACESTATE_MAX_MEMBERS = 32;
    private static final char TRACESTATE_KEY_VALUE_DELIMITER = '=';
    private static final char TRACESTATE_ENTRY_DELIMITER = ',';
    private static final Pattern TRACESTATE_ENTRY_DELIMITER_SPLIT_PATTERN = Pattern.compile("[ \t]*,[ \t]*");

    public static TraceState decodeTraceState(String traceStateHeader) {
        TraceStateBuilder traceStateBuilder = TraceState.builder();
        String[] listMembers = TRACESTATE_ENTRY_DELIMITER_SPLIT_PATTERN.split(traceStateHeader);
        TraceStateUtil.checkArgument(listMembers.length <= 32, "TraceState has too many elements.");
        for (int i = listMembers.length - 1; i >= 0; --i) {
            String listMember = listMembers[i];
            int index = listMember.indexOf(61);
            TraceStateUtil.checkArgument(index != -1, "Invalid TraceState list-member format.");
            traceStateBuilder.put(listMember.substring(0, index), listMember.substring(index + 1));
        }
        TraceState traceState = traceStateBuilder.build();
        if (traceState.size() != listMembers.length) {
            return TraceState.getDefault();
        }
        return traceState;
    }

    public static String encodeTraceState(TraceState traceState) {
        if (traceState.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder(512);
        traceState.forEach((key, value) -> {
            if (builder.length() != 0) {
                builder.append(',');
            }
            builder.append((String)key).append('=').append((String)value);
        });
        return builder.toString();
    }

    public static void checkArgument(boolean isValid, String errorMessage) {
        if (!isValid) {
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

