/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.trace.propagation.javaagent;

import com.solace.messaging.trace.propagation.SolaceJCSMPTextMapGetter;
import com.solace.messaging.trace.propagation.SolaceJCSMPTextMapSetter;
import com.solace.messaging.trace.propagation.internal.MessagingAttribute;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.Consumer;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.Endpoint;
import com.solacesystems.jcsmp.FlowReceiver;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPVersion;
import com.solacesystems.jcsmp.Queue;
import com.solacesystems.jcsmp.RequestReplyListener;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.TopicEndpoint;
import com.solacesystems.jcsmp.XMLMessageListener;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import java.util.concurrent.TimeUnit;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class SolaceJCSMPConsumerInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<ClassLoader> classLoaderOptimization() {
        return AgentElementMatchers.hasClassesNamed((String[])new String[]{"com.solacesystems.jcsmp.XMLMessageListener", "com.solacesystems.jcsmp.RequestReplyListener", "com.solacesystems.jcsmp.Consumer"});
    }

    public ElementMatcher<TypeDescription> typeMatcher() {
        return AgentElementMatchers.implementsInterface((ElementMatcher)ElementMatchers.namedOneOf((String[])new String[]{"com.solacesystems.jcsmp.XMLMessageListener", "com.solacesystems.jcsmp.RequestReplyListener", "com.solacesystems.jcsmp.Consumer"}));
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"onReceive")).and((ElementMatcher)ElementMatchers.takesArguments((int)1)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"com.solacesystems.jcsmp.BytesXMLMessage"))), this.getClass().getName() + "$ListenerAsyncReceiveMethodAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"onException")).and((ElementMatcher)ElementMatchers.takesArguments((int)1)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"com.solacesystems.jcsmp.JCSMPException"))), this.getClass().getName() + "$ListenerAsyncExceptionMethodAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"onReply")).and((ElementMatcher)ElementMatchers.takesArguments((int)2)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"com.solacesystems.jcsmp.BytesXMLMessage"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)Object.class.getName()))), this.getClass().getName() + "$RequestReplyListenerOnReplyMethodAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"receive")).and((ElementMatcher)ElementMatchers.takesArguments((int)1)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)Integer.TYPE.getName()))), this.getClass().getName() + "$ConsumerReceiveMethodAdvice");
    }

    public static class ConsumerReceiveMethodAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void before(@Advice.Local(value="spanStartTime") Long spanStartTime) {
            spanStartTime = System.currentTimeMillis();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.This Consumer consumer, @Advice.Thrown Throwable throwable, @Advice.Argument(value=0) int timeout, @Advice.Return BytesXMLMessage message, @Advice.Local(value="otelSpan") Span span, @Advice.Local(value="spanStartTime") Long spanStartTime) {
            if (message == null) {
                return;
            }
            if (message.getDestination() instanceof Topic && consumer instanceof FlowReceiver && timeout > 0 && message.getConsumerEndpoint() == null) {
                return;
            }
            OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
            Tracer tracer = GlobalOpenTelemetry.getTracer((String)"solace-opentelemetry-jcsmp-integration", (String)"1.2.0");
            Context context = Context.current();
            if (context == Context.root()) {
                context = openTelemetry.getPropagators().getTextMapPropagator().extract(Context.current(), (Object)message, (TextMapGetter)new SolaceJCSMPTextMapGetter());
            }
            try (Scope parentScope = context.makeCurrent();){
                Destination destination;
                String spanDestName;
                String destName;
                String destKind = "";
                String topicName = "";
                boolean isTemporary = false;
                boolean isAnonymous = false;
                Endpoint endpoint = message.getConsumerEndpoint();
                if (endpoint != null) {
                    spanDestName = destName = endpoint.getName();
                    if (endpoint instanceof Queue) {
                        destKind = "queue";
                        isTemporary = ((Queue)endpoint).isTemporary();
                        isAnonymous = isTemporary && ((Queue)endpoint).isAnonymous();
                    } else if (endpoint instanceof TopicEndpoint) {
                        destKind = "topic endpoint";
                        isTemporary = ((TopicEndpoint)endpoint).isTemporary();
                        isAnonymous = isTemporary && ((TopicEndpoint)endpoint).isAnonymous();
                    }
                } else {
                    Topic topic = (Topic)message.getDestination();
                    destName = topic.getName();
                    spanDestName = "(topic)";
                    destKind = "topic";
                    isAnonymous = isTemporary = topic.isTemporary();
                }
                span = tracer.spanBuilder("consume " + (isAnonymous ? "(anonymous)" : spanDestName)).setSpanKind(SpanKind.CONSUMER).setAttribute(MessagingAttribute.API_NAME.toString(), "jcsmp").setAttribute(MessagingAttribute.API_VERSION.toString(), new JCSMPVersion().getSwVersion()).setAttribute(MessagingAttribute.DELIVERY_MODE.toString(), message.getDeliveryMode().toString()).setAttribute(MessagingAttribute.DESTINATION.toString(), destName).setAttribute(MessagingAttribute.DESTINATION_TYPE.toString(), destKind).setAttribute(MessagingAttribute.OPERATION.toString(), "consume").setAttribute(MessagingAttribute.OPERATION_TYPE.toString(), "receive").setAttribute(MessagingAttribute.SYSTEM.toString(), "SolacePubSub+").setStartTimestamp(spanStartTime.longValue(), TimeUnit.MILLISECONDS).setParent(context).startSpan();
                if ((destKind.equals("topic endpoint") || destKind.equals("queue")) && (destination = message.getDestination()) instanceof Topic) {
                    span.setAttribute(MessagingAttribute.SOLACE_TOPIC_NAME.toString(), destination.getName());
                }
                if (message.getApplicationMessageId() != null) {
                    span.setAttribute(MessagingAttribute.MESSAGE_ID.toString(), message.getApplicationMessageId());
                }
                if (isTemporary) {
                    span.setAttribute(MessagingAttribute.DESTINATION_TEMPORARY.toString(), true);
                }
                if (isAnonymous) {
                    span.setAttribute(MessagingAttribute.DESTINATION_ANONYMOUS.toString(), true);
                }
                if (throwable != null) {
                    span.setAttribute(MessagingAttribute.ERROR_TYPE.toString(), throwable.getClass().getName());
                    span.recordException(throwable);
                    span.setStatus(StatusCode.ERROR);
                }
                try (Scope scope = span.makeCurrent();){
                    TextMapPropagator propagator = openTelemetry.getPropagators().getTextMapPropagator();
                    propagator.inject(Context.current(), (Object)message, (TextMapSetter)new SolaceJCSMPTextMapSetter());
                }
                span.end();
            }
        }
    }

    public static class ListenerAsyncExceptionMethodAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Scope before(@Advice.This XMLMessageListener listener, @Advice.Argument(value=0) JCSMPException exception, @Advice.Local(value="otelSpan") Span span) {
            OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
            Tracer tracer = GlobalOpenTelemetry.getTracer((String)"solace-opentelemetry-jcsmp-integration", (String)"1.2.0");
            Context context = Context.current();
            Scope parentScope = context.makeCurrent();
            span = tracer.spanBuilder("consume ERROR").setSpanKind(SpanKind.CONSUMER).setAttribute(MessagingAttribute.API_NAME.toString(), "jcsmp").setAttribute(MessagingAttribute.API_VERSION.toString(), new JCSMPVersion().getSwVersion()).setAttribute(MessagingAttribute.OPERATION.toString(), "consume").setAttribute(MessagingAttribute.OPERATION_TYPE.toString(), "process").setAttribute(MessagingAttribute.SYSTEM.toString(), "SolacePubSub+").setAttribute(MessagingAttribute.ERROR_TYPE.toString(), exception.getClass().getName()).setParent(context).startSpan();
            span.recordException((Throwable)exception);
            span.setStatus(StatusCode.ERROR);
            return parentScope;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.Thrown Throwable throwable, @Advice.Local(value="otelSpan") Span span, @Advice.Enter Scope scope) {
            if (throwable != null) {
                span.setAttribute(MessagingAttribute.ERROR_TYPE.toString(), throwable.getClass().getName());
                span.recordException(throwable);
                span.setStatus(StatusCode.ERROR);
            }
            scope.close();
            span.end();
        }
    }

    public static class ListenerAsyncReceiveMethodAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Scope before(@Advice.This XMLMessageListener listener, @Advice.Argument(value=0) BytesXMLMessage message, @Advice.Local(value="otelSpan") Span span) {
            Destination destination;
            String spanDestName;
            String destName;
            OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
            Tracer tracer = GlobalOpenTelemetry.getTracer((String)"solace-opentelemetry-jcsmp-integration", (String)"1.2.0");
            Context context = Context.current();
            if (context == Context.root()) {
                context = openTelemetry.getPropagators().getTextMapPropagator().extract(Context.current(), (Object)message, (TextMapGetter)new SolaceJCSMPTextMapGetter());
            }
            String destKind = "";
            String topicName = "";
            boolean isTemporary = false;
            boolean isAnonymous = false;
            Endpoint endpoint = message.getConsumerEndpoint();
            if (endpoint != null) {
                spanDestName = destName = endpoint.getName();
                if (endpoint instanceof Queue) {
                    destKind = "queue";
                    isTemporary = ((Queue)endpoint).isTemporary();
                    isAnonymous = isTemporary && ((Queue)endpoint).isAnonymous();
                } else if (endpoint instanceof TopicEndpoint) {
                    destKind = "topic endpoint";
                    isTemporary = ((TopicEndpoint)endpoint).isTemporary();
                    isAnonymous = isTemporary && ((TopicEndpoint)endpoint).isAnonymous();
                }
            } else {
                Topic topic = (Topic)message.getDestination();
                destName = topic.getName();
                spanDestName = "(topic)";
                destKind = "topic";
                isAnonymous = isTemporary = topic.isTemporary();
            }
            span = tracer.spanBuilder("consume " + (isAnonymous ? "(anonymous)" : spanDestName)).setSpanKind(SpanKind.CONSUMER).setAttribute(MessagingAttribute.API_NAME.toString(), "jcsmp").setAttribute(MessagingAttribute.API_VERSION.toString(), new JCSMPVersion().getSwVersion()).setAttribute(MessagingAttribute.DELIVERY_MODE.toString(), message.getDeliveryMode().toString()).setAttribute(MessagingAttribute.DESTINATION.toString(), destName).setAttribute(MessagingAttribute.DESTINATION_TYPE.toString(), destKind).setAttribute(MessagingAttribute.OPERATION.toString(), "consume").setAttribute(MessagingAttribute.OPERATION_TYPE.toString(), "process").setAttribute(MessagingAttribute.SYSTEM.toString(), "SolacePubSub+").setParent(context).startSpan();
            if ((destKind.equals("topic endpoint") || destKind.equals("queue")) && (destination = message.getDestination()) instanceof Topic) {
                span.setAttribute(MessagingAttribute.SOLACE_TOPIC_NAME.toString(), destination.getName());
            }
            if (message.getApplicationMessageId() != null) {
                span.setAttribute(MessagingAttribute.MESSAGE_ID.toString(), message.getApplicationMessageId());
            }
            if (isTemporary) {
                span.setAttribute(MessagingAttribute.DESTINATION_TEMPORARY.toString(), true);
            }
            if (isAnonymous) {
                span.setAttribute(MessagingAttribute.DESTINATION_ANONYMOUS.toString(), true);
            }
            Scope scope = span.makeCurrent();
            TextMapPropagator propagator = openTelemetry.getPropagators().getTextMapPropagator();
            propagator.inject(Context.current(), (Object)message, (TextMapSetter)new SolaceJCSMPTextMapSetter());
            return scope;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.Thrown Throwable throwable, @Advice.Local(value="otelSpan") Span span, @Advice.Enter Scope scope) {
            if (throwable != null) {
                span.setAttribute(MessagingAttribute.ERROR_TYPE.toString(), throwable.getClass().getName());
                span.recordException(throwable);
                span.setStatus(StatusCode.ERROR);
            }
            scope.close();
            span.end();
        }
    }

    public static class RequestReplyListenerOnReplyMethodAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Scope before(@Advice.This RequestReplyListener listener, @Advice.Argument(value=0) BytesXMLMessage message, @Advice.Argument(value=1) Object key, @Advice.Local(value="otelSpan") Span span) {
            Destination destination;
            String spanDestName;
            String destName;
            OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
            Tracer tracer = GlobalOpenTelemetry.getTracer((String)"solace-opentelemetry-jcsmp-integration", (String)"1.2.0");
            Context context = Context.current();
            if (context == Context.root()) {
                context = openTelemetry.getPropagators().getTextMapPropagator().extract(Context.current(), (Object)message, (TextMapGetter)new SolaceJCSMPTextMapGetter());
            }
            Scope parentScope = context.makeCurrent();
            String destKind = "";
            String topicName = "";
            boolean isTemporary = false;
            boolean isAnonymous = false;
            Endpoint endpoint = message.getConsumerEndpoint();
            if (endpoint != null) {
                spanDestName = destName = endpoint.getName();
                if (endpoint instanceof Queue) {
                    destKind = "queue";
                    isTemporary = ((Queue)endpoint).isTemporary();
                    isAnonymous = isTemporary && ((Queue)endpoint).isAnonymous();
                } else if (endpoint instanceof TopicEndpoint) {
                    destKind = "topic endpoint";
                    isTemporary = ((TopicEndpoint)endpoint).isTemporary();
                    isAnonymous = isTemporary && ((TopicEndpoint)endpoint).isAnonymous();
                }
            } else {
                Topic topic = (Topic)message.getDestination();
                destName = topic.getName();
                spanDestName = "(topic)";
                destKind = "topic";
                isAnonymous = isTemporary = topic.isTemporary();
            }
            span = tracer.spanBuilder("consume " + (isAnonymous ? "(anonymous)" : spanDestName)).setSpanKind(SpanKind.CONSUMER).setAttribute(MessagingAttribute.API_NAME.toString(), "jcsmp").setAttribute(MessagingAttribute.API_VERSION.toString(), new JCSMPVersion().getSwVersion()).setAttribute(MessagingAttribute.DELIVERY_MODE.toString(), message.getDeliveryMode().toString()).setAttribute(MessagingAttribute.DESTINATION.toString(), destName).setAttribute(MessagingAttribute.DESTINATION_TYPE.toString(), destKind).setAttribute(MessagingAttribute.OPERATION.toString(), "consume").setAttribute(MessagingAttribute.OPERATION_TYPE.toString(), "process").setAttribute(MessagingAttribute.SYSTEM.toString(), "SolacePubSub+").setParent(context).startSpan();
            if ((destKind.equals("topic endpoint") || destKind.equals("queue")) && (destination = message.getDestination()) instanceof Topic) {
                span.setAttribute(MessagingAttribute.SOLACE_TOPIC_NAME.toString(), destination.getName());
            }
            if (message.getApplicationMessageId() != null) {
                span.setAttribute(MessagingAttribute.MESSAGE_ID.toString(), message.getApplicationMessageId());
            }
            if (isTemporary) {
                span.setAttribute(MessagingAttribute.DESTINATION_TEMPORARY.toString(), true);
            }
            if (isAnonymous) {
                span.setAttribute(MessagingAttribute.DESTINATION_ANONYMOUS.toString(), true);
            }
            return parentScope;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.Thrown Throwable throwable, @Advice.Local(value="otelSpan") Span span, @Advice.Enter Scope scope) {
            if (throwable != null) {
                span.setAttribute(MessagingAttribute.ERROR_TYPE.toString(), throwable.getClass().getName());
                span.recordException(throwable);
                span.setStatus(StatusCode.ERROR);
            }
            scope.close();
            span.end();
        }
    }
}

