/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.trace.propagation.javaagent;

import com.solace.messaging.trace.propagation.MessageTracingSupport;
import com.solace.messaging.trace.propagation.SolaceJCSMPTextMapGetter;
import com.solace.messaging.trace.propagation.SolaceJCSMPTextMapSetter;
import com.solace.messaging.trace.propagation.internal.MessagingAttribute;
import com.solace.messaging.trace.propagation.internal.MessagingOperation;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.DeliveryMode;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.Endpoint;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPSendMultipleEntry;
import com.solacesystems.jcsmp.JCSMPVersion;
import com.solacesystems.jcsmp.Queue;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.TopicEndpoint;
import com.solacesystems.jcsmp.XMLMessage;
import com.solacesystems.jcsmp.XMLMessageProducer;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class SolaceJCSMPProducerInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<ClassLoader> classLoaderOptimization() {
        return AgentElementMatchers.hasClassesNamed((String[])new String[]{"com.solacesystems.jcsmp.XMLMessageProducer", "com.solacesystems.jcsmp.Requestor"});
    }

    public ElementMatcher<TypeDescription> typeMatcher() {
        return AgentElementMatchers.implementsInterface((ElementMatcher)ElementMatchers.namedOneOf((String[])new String[]{"com.solacesystems.jcsmp.XMLMessageProducer", "com.solacesystems.jcsmp.Requestor"}));
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"send")).and((ElementMatcher)ElementMatchers.takesArguments((int)2)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"com.solacesystems.jcsmp.XMLMessage"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"com.solacesystems.jcsmp.Destination"))), this.getClass().getName() + "$ProducerSendWithDestinationMethodAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"sendMultiple")).and((ElementMatcher)ElementMatchers.takesArguments((int)4)).and((ElementMatcher)new ElementMatcher<MethodDescription>(){

            public boolean matches(MethodDescription methodDescription) {
                return ((ParameterDescription)methodDescription.getParameters().get(0)).getType().isArray() && ((ParameterDescription)methodDescription.getParameters().get(0)).getType().getComponentType().getTypeName().endsWith("JCSMPSendMultipleEntry");
            }
        }).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)Integer.TYPE.getName()))).and((ElementMatcher)ElementMatchers.takesArgument((int)2, (ElementMatcher)ElementMatchers.named((String)Integer.TYPE.getName()))).and((ElementMatcher)ElementMatchers.takesArgument((int)3, (ElementMatcher)ElementMatchers.named((String)Integer.TYPE.getName()))), this.getClass().getName() + "$ProducerSendMultipleEntryMethodAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"request")).and((ElementMatcher)ElementMatchers.takesArguments((int)3)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"com.solacesystems.jcsmp.XMLMessage"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)Long.TYPE.getName()))).and((ElementMatcher)ElementMatchers.takesArgument((int)2, (ElementMatcher)ElementMatchers.named((String)"com.solacesystems.jcsmp.Destination"))), this.getClass().getName() + "$BlockingRequestMethodAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"request")).and((ElementMatcher)ElementMatchers.takesArguments((int)5)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"com.solacesystems.jcsmp.XMLMessage"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"com.solacesystems.jcsmp.RequestReplyListener"))).and((ElementMatcher)ElementMatchers.takesArgument((int)2, (ElementMatcher)ElementMatchers.named((String)Long.TYPE.getName()))).and((ElementMatcher)ElementMatchers.takesArgument((int)3, (ElementMatcher)ElementMatchers.named((String)"com.solacesystems.jcsmp.Destination"))).and((ElementMatcher)ElementMatchers.takesArgument((int)4, (ElementMatcher)ElementMatchers.named((String)Object.class.getName()))), this.getClass().getName() + "$AsyncRequestMethodAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"sendReply")).and((ElementMatcher)ElementMatchers.takesArguments((int)2)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"com.solacesystems.jcsmp.XMLMessage"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"com.solacesystems.jcsmp.XMLMessage"))), this.getClass().getName() + "$ProducerSendReplyMethodAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"ackTraceHook")).and((ElementMatcher)ElementMatchers.takesArguments((int)1)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)Object.class.getName()))), this.getClass().getName() + "$ProducerAckTraceHookMethodAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"errorTraceHook")).and((ElementMatcher)ElementMatchers.takesArguments((int)2)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)Object.class.getName()))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"com.solacesystems.jcsmp.JCSMPException"))), this.getClass().getName() + "$ProducerErrorTraceHookMethodAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"errorTraceHook")).and((ElementMatcher)ElementMatchers.takesArguments((int)1)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"com.solacesystems.jcsmp.JCSMPException"))), this.getClass().getName() + "$ProducerErrorTraceHookWithOnlyExceptionMethodAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"unAckedTraceHook")).and((ElementMatcher)ElementMatchers.takesArguments((int)1)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)Object.class.getName()))), this.getClass().getName() + "$ProducerUnAckedTraceHookMethodAdvice");
    }

    public static class ProducerUnAckedTraceHookMethodAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Scope before(@Advice.Argument(value=0) Object contextObj, @Advice.Local(value="otelSpan") Span span) {
            Logger logger = Logger.getLogger(ProducerUnAckedTraceHookMethodAdvice.class.getName());
            OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
            Tracer tracer = GlobalOpenTelemetry.getTracer((String)"solace-opentelemetry-jcsmp-integration", (String)"1.2.0");
            if (contextObj != null) {
                if (contextObj instanceof Context) {
                    Context context = (Context)contextObj;
                    Scope parentScope = context.makeCurrent();
                    span = Span.fromContext((Context)context);
                    span.setAttribute(MessagingAttribute.ERROR_TYPE.toString(), JCSMPException.class.getName());
                    span.setStatus(StatusCode.ERROR);
                    span.recordException((Throwable)new JCSMPException("Published message was never acknowledged"));
                    return parentScope;
                }
                logger.log(Level.SEVERE, "Unexpected context type: " + contextObj.getClass().getName());
                return null;
            }
            logger.log(Level.SEVERE, "No context set on the message");
            return null;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.Local(value="otelSpan") Span span, @Advice.Enter Scope scope) {
            if (scope != null) {
                scope.close();
                span.end(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            }
        }
    }

    public static class ProducerErrorTraceHookWithOnlyExceptionMethodAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Scope before(@Advice.Argument(value=0) JCSMPException exception, @Advice.Local(value="otelSpan") Span span) {
            OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
            Tracer tracer = GlobalOpenTelemetry.getTracer((String)"solace-opentelemetry-jcsmp-integration", (String)"1.2.0");
            Context context = Context.current();
            Scope parentScope = context.makeCurrent();
            span = tracer.spanBuilder("publish ERROR").setSpanKind(SpanKind.PRODUCER).setAttribute(MessagingAttribute.API_NAME.toString(), "jcsmp").setAttribute(MessagingAttribute.API_VERSION.toString(), new JCSMPVersion().getSwVersion()).setAttribute(MessagingAttribute.OPERATION.toString(), "publish").setAttribute(MessagingAttribute.OPERATION_TYPE.toString(), "publish").setAttribute(MessagingAttribute.SYSTEM.toString(), "SolacePubSub+").setAttribute(MessagingAttribute.ERROR_TYPE.toString(), exception.getClass().getName()).setParent(context).startSpan();
            span.recordException((Throwable)exception);
            span.setStatus(StatusCode.ERROR);
            return parentScope;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.Thrown Throwable throwable, @Advice.Local(value="otelSpan") Span span, @Advice.Enter Scope scope) {
            if (throwable != null) {
                span.setAttribute(MessagingAttribute.ERROR_TYPE.toString(), throwable.getClass().getName());
                span.recordException(throwable);
                span.setStatus(StatusCode.ERROR);
            }
            scope.close();
            span.end();
        }
    }

    public static class ProducerErrorTraceHookMethodAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Scope before(@Advice.Argument(value=0) Object contextObj, @Advice.Argument(value=1) JCSMPException cause, @Advice.Local(value="otelSpan") Span span) {
            Logger logger = Logger.getLogger(ProducerErrorTraceHookMethodAdvice.class.getName());
            OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
            Tracer tracer = GlobalOpenTelemetry.getTracer((String)"solace-opentelemetry-jcsmp-integration", (String)"1.2.0");
            if (contextObj != null) {
                if (contextObj instanceof Context) {
                    Context context = (Context)contextObj;
                    Scope parentScope = context.makeCurrent();
                    span = Span.fromContext((Context)context);
                    span.setAttribute(MessagingAttribute.ERROR_TYPE.toString(), cause.getClass().getName());
                    span.recordException((Throwable)cause);
                    span.setStatus(StatusCode.ERROR);
                    return parentScope;
                }
                logger.log(Level.SEVERE, "Unexpected context type: " + contextObj.getClass().getName());
                return null;
            }
            logger.log(Level.SEVERE, "No context set on the message");
            return null;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.Local(value="otelSpan") Span span, @Advice.Enter Scope scope) {
            if (scope != null) {
                scope.close();
                span.end(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            }
        }
    }

    public static class ProducerAckTraceHookMethodAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Scope before(@Advice.Argument(value=0) Object contextObj, @Advice.Local(value="otelSpan") Span span) {
            Logger logger = Logger.getLogger(ProducerAckTraceHookMethodAdvice.class.getName());
            OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
            Tracer tracer = GlobalOpenTelemetry.getTracer((String)"solace-opentelemetry-jcsmp-integration", (String)"1.2.0");
            if (contextObj != null) {
                if (contextObj instanceof Context) {
                    Context context = (Context)contextObj;
                    Scope parentScope = context.makeCurrent();
                    span = Span.fromContext((Context)context);
                    return parentScope;
                }
                logger.log(Level.SEVERE, "Unexpected context type: " + contextObj.getClass().getName());
                return null;
            }
            logger.log(Level.SEVERE, "No context set on the message");
            return null;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.Thrown Throwable throwable, @Advice.Local(value="otelSpan") Span span, @Advice.Enter Scope scope) {
            if (scope != null) {
                scope.close();
                if (throwable != null) {
                    span.setAttribute(MessagingAttribute.ERROR_TYPE.toString(), throwable.getClass().getName());
                    span.recordException(throwable);
                    span.setStatus(StatusCode.ERROR);
                }
                span.end(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            }
        }
    }

    public static class ProducerSendReplyMethodAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Scope before(@Advice.This XMLMessageProducer producer, @Advice.Argument(value=0) XMLMessage requestMessage, @Advice.Argument(value=1) XMLMessage replyMessage, @Advice.Local(value="otelSpan") Span span) {
            OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
            Tracer tracer = GlobalOpenTelemetry.getTracer((String)"solace-opentelemetry-jcsmp-integration", (String)"1.2.0");
            Context context = Context.current();
            if (context == Context.root()) {
                context = openTelemetry.getPropagators().getTextMapPropagator().extract(Context.current(), (Object)requestMessage, (TextMapGetter)new SolaceJCSMPTextMapGetter());
            }
            Scope parentScope = context.makeCurrent();
            String destKind = "";
            String spanDestName = "";
            Destination destination = requestMessage.getReplyTo();
            boolean isTemporary = destination.isTemporary();
            boolean isAnonymous = false;
            if (destination instanceof Queue) {
                destKind = "queue";
                isAnonymous = isTemporary && ((Queue)destination).isAnonymous();
                spanDestName = destination.getName();
            } else if (destination instanceof Topic) {
                destKind = "topic";
                spanDestName = "(topic)";
                isAnonymous = isTemporary;
            }
            span = tracer.spanBuilder((Object)((Object)MessagingOperation.publish) + " " + (isAnonymous ? "(anonymous)" : spanDestName)).setSpanKind(SpanKind.PRODUCER).setAttribute(MessagingAttribute.API_NAME.toString(), "jcsmp").setAttribute(MessagingAttribute.API_VERSION.toString(), new JCSMPVersion().getSwVersion()).setAttribute(MessagingAttribute.DESTINATION.toString(), destination.getName()).setAttribute(MessagingAttribute.DESTINATION_TYPE.toString(), destKind).setAttribute(MessagingAttribute.DELIVERY_MODE.toString(), replyMessage.getDeliveryMode().toString()).setAttribute(MessagingAttribute.OPERATION.toString(), "publish").setAttribute(MessagingAttribute.OPERATION_TYPE.toString(), "publish").setAttribute(MessagingAttribute.SYSTEM.toString(), "SolacePubSub+").setParent(context).startSpan();
            if (replyMessage.getApplicationMessageId() != null) {
                span.setAttribute(MessagingAttribute.MESSAGE_ID.toString(), replyMessage.getApplicationMessageId());
            }
            if (isTemporary) {
                span.setAttribute(MessagingAttribute.DESTINATION_TEMPORARY.toString(), true);
            }
            if (isAnonymous) {
                span.setAttribute(MessagingAttribute.DESTINATION_ANONYMOUS.toString(), true);
            }
            if (replyMessage.getDeliveryMode() == DeliveryMode.DIRECT || producer.isTransacted()) {
                try (Scope scope = span.makeCurrent();){
                    TextMapPropagator propagator = openTelemetry.getPropagators().getTextMapPropagator();
                    propagator.inject(Context.current(), (Object)replyMessage, (TextMapSetter)new SolaceJCSMPTextMapSetter());
                }
            } else if (replyMessage.getDeliveryMode() == DeliveryMode.NON_PERSISTENT || replyMessage.getDeliveryMode() == DeliveryMode.PERSISTENT) {
                Context otelContext = Context.current().with((ImplicitContextKeyed)span);
                if (replyMessage instanceof MessageTracingSupport) {
                    ((MessageTracingSupport)replyMessage).setContext((Object)otelContext);
                }
                TextMapPropagator propagator = openTelemetry.getPropagators().getTextMapPropagator();
                propagator.inject(Context.current().with((ImplicitContextKeyed)span), (Object)replyMessage, (TextMapSetter)new SolaceJCSMPTextMapSetter());
            }
            return parentScope;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.Thrown Throwable throwable, @Advice.Local(value="otelSpan") Span span, @Advice.Enter Scope scope, @Advice.Argument(value=1) XMLMessage replyMessage, @Advice.This XMLMessageProducer producer) {
            if (throwable != null) {
                span.setAttribute(MessagingAttribute.ERROR_TYPE.toString(), throwable.getClass().getName());
                span.recordException(throwable);
                span.setStatus(StatusCode.ERROR);
                scope.close();
                span.end();
                return;
            }
            scope.close();
            if (replyMessage.getDeliveryMode() == DeliveryMode.DIRECT || producer.isTransacted()) {
                span.end();
            }
        }
    }

    public static class BlockingRequestMethodAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Scope before(@Advice.Argument(value=0) XMLMessage message, @Advice.Argument(value=2) Destination destination, @Advice.Local(value="otelSpan") Span span, @Advice.Local(value="otelTracer") Tracer tracer, @Advice.Local(value="otel") OpenTelemetry openTelemetry) {
            boolean isTemporary;
            openTelemetry = GlobalOpenTelemetry.get();
            tracer = GlobalOpenTelemetry.getTracer((String)"solace-opentelemetry-jcsmp-integration", (String)"1.2.0");
            Context context = Context.current();
            if (context == Context.root()) {
                context = openTelemetry.getPropagators().getTextMapPropagator().extract(Context.current(), (Object)message, (TextMapGetter)new SolaceJCSMPTextMapGetter());
            }
            Scope parentScope = context.makeCurrent();
            String destKind = "topic";
            String spanDestName = "(topic)";
            boolean isAnonymous = isTemporary = destination.isTemporary();
            span = tracer.spanBuilder((Object)((Object)MessagingOperation.publish) + " " + (isAnonymous ? "(anonymous)" : spanDestName)).setSpanKind(SpanKind.PRODUCER).setAttribute(MessagingAttribute.API_NAME.toString(), "jcsmp").setAttribute(MessagingAttribute.API_VERSION.toString(), new JCSMPVersion().getSwVersion()).setAttribute(MessagingAttribute.DESTINATION.toString(), destination.getName()).setAttribute(MessagingAttribute.DESTINATION_TYPE.toString(), destKind).setAttribute(MessagingAttribute.DELIVERY_MODE.toString(), message.getDeliveryMode().toString()).setAttribute(MessagingAttribute.OPERATION.toString(), "publish").setAttribute(MessagingAttribute.OPERATION_TYPE.toString(), "publish").setAttribute(MessagingAttribute.SYSTEM.toString(), "SolacePubSub+").setParent(context).startSpan();
            if (message.getApplicationMessageId() != null) {
                span.setAttribute(MessagingAttribute.MESSAGE_ID.toString(), message.getApplicationMessageId());
            }
            if (isTemporary) {
                span.setAttribute(MessagingAttribute.DESTINATION_TEMPORARY.toString(), true);
            }
            if (isAnonymous) {
                span.setAttribute(MessagingAttribute.DESTINATION_ANONYMOUS.toString(), true);
            }
            try (Scope scope = span.makeCurrent();){
                TextMapPropagator propagator = openTelemetry.getPropagators().getTextMapPropagator();
                propagator.inject(Context.current(), (Object)message, (TextMapSetter)new SolaceJCSMPTextMapSetter());
            }
            return parentScope;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.Thrown Throwable throwable, @Advice.Local(value="otelSpan") Span span, @Advice.Enter Scope scope, @Advice.Return BytesXMLMessage replyMessage, @Advice.Local(value="otelTracer") Tracer tracer, @Advice.Local(value="otel") OpenTelemetry openTelemetry) {
            if (throwable != null) {
                span.setAttribute(MessagingAttribute.ERROR_TYPE.toString(), throwable.getClass().getName());
                span.recordException(throwable);
                span.setStatus(StatusCode.ERROR);
                scope.close();
                span.end();
                return;
            }
            scope.close();
            span.end();
            if (replyMessage != null) {
                Context context = Context.current();
                if (context == Context.root()) {
                    context = openTelemetry.getPropagators().getTextMapPropagator().extract(Context.current(), (Object)replyMessage, (TextMapGetter)new SolaceJCSMPTextMapGetter());
                }
                try (Scope parentScope = Context.current().makeCurrent();){
                    Destination destination;
                    String spanDestName;
                    String destName;
                    String destKind = "";
                    String topicName = "";
                    boolean isTemporary = false;
                    boolean isAnonymous = false;
                    Endpoint endpoint = replyMessage.getConsumerEndpoint();
                    if (endpoint != null) {
                        spanDestName = destName = endpoint.getName();
                        if (endpoint instanceof Queue) {
                            destKind = "queue";
                            isTemporary = ((Queue)endpoint).isTemporary();
                            isAnonymous = isTemporary && ((Queue)endpoint).isAnonymous();
                        } else if (endpoint instanceof TopicEndpoint) {
                            destKind = "topic endpoint";
                            isTemporary = ((TopicEndpoint)endpoint).isTemporary();
                            isAnonymous = isTemporary && ((TopicEndpoint)endpoint).isAnonymous();
                        }
                    } else {
                        Topic topic = (Topic)replyMessage.getDestination();
                        destName = topic.getName();
                        spanDestName = "(topic)";
                        destKind = "topic";
                        isAnonymous = isTemporary = topic.isTemporary();
                    }
                    Span replyMessageSpan = tracer.spanBuilder("consume " + (isAnonymous ? "(anonymous)" : spanDestName)).setSpanKind(SpanKind.CONSUMER).setAttribute(MessagingAttribute.API_NAME.toString(), "jcsmp").setAttribute(MessagingAttribute.API_VERSION.toString(), new JCSMPVersion().getSwVersion()).setAttribute(MessagingAttribute.DELIVERY_MODE.toString(), replyMessage.getDeliveryMode().toString()).setAttribute(MessagingAttribute.DESTINATION.toString(), destName).setAttribute(MessagingAttribute.DESTINATION_TYPE.toString(), destKind).setAttribute(MessagingAttribute.OPERATION.toString(), "consume").setAttribute(MessagingAttribute.OPERATION_TYPE.toString(), "receive").setAttribute(MessagingAttribute.SYSTEM.toString(), "SolacePubSub+").setParent(context).startSpan();
                    if ((destKind.equals("topic endpoint") || destKind.equals("queue")) && (destination = replyMessage.getDestination()) instanceof Topic) {
                        replyMessageSpan.setAttribute(MessagingAttribute.SOLACE_TOPIC_NAME.toString(), destination.getName());
                    }
                    if (replyMessage.getApplicationMessageId() != null) {
                        replyMessageSpan.setAttribute(MessagingAttribute.MESSAGE_ID.toString(), replyMessage.getApplicationMessageId());
                    }
                    if (isTemporary) {
                        replyMessageSpan.setAttribute(MessagingAttribute.DESTINATION_TEMPORARY.toString(), true);
                    }
                    if (isAnonymous) {
                        replyMessageSpan.setAttribute(MessagingAttribute.DESTINATION_ANONYMOUS.toString(), true);
                    }
                    try (Scope scope2 = span.makeCurrent();){
                        TextMapPropagator propagator = openTelemetry.getPropagators().getTextMapPropagator();
                        propagator.inject(Context.current(), (Object)replyMessage, (TextMapSetter)new SolaceJCSMPTextMapSetter());
                    }
                    replyMessageSpan.end();
                }
            }
        }
    }

    public static class AsyncRequestMethodAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Scope before(@Advice.Argument(value=0) XMLMessage requestMessage, @Advice.Argument(value=3) Destination destination, @Advice.Local(value="otelSpan") Span span) {
            boolean isTemporary;
            OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
            Tracer tracer = GlobalOpenTelemetry.getTracer((String)"solace-opentelemetry-jcsmp-integration", (String)"1.2.0");
            Context context = Context.current();
            if (context == Context.root()) {
                context = openTelemetry.getPropagators().getTextMapPropagator().extract(Context.current(), (Object)requestMessage, (TextMapGetter)new SolaceJCSMPTextMapGetter());
            }
            Scope parentScope = context.makeCurrent();
            String destKind = "topic";
            String spanDestName = "(topic)";
            boolean isAnonymous = isTemporary = destination.isTemporary();
            span = tracer.spanBuilder((Object)((Object)MessagingOperation.publish) + " " + (isAnonymous ? "(anonymous)" : spanDestName)).setSpanKind(SpanKind.PRODUCER).setAttribute(MessagingAttribute.API_NAME.toString(), "jcsmp").setAttribute(MessagingAttribute.API_VERSION.toString(), new JCSMPVersion().getSwVersion()).setAttribute(MessagingAttribute.DESTINATION.toString(), destination.getName()).setAttribute(MessagingAttribute.DESTINATION_TYPE.toString(), destKind).setAttribute(MessagingAttribute.DELIVERY_MODE.toString(), requestMessage.getDeliveryMode().toString()).setAttribute(MessagingAttribute.OPERATION.toString(), "publish").setAttribute(MessagingAttribute.OPERATION_TYPE.toString(), "publish").setAttribute(MessagingAttribute.SYSTEM.toString(), "SolacePubSub+").setParent(context).startSpan();
            if (requestMessage.getApplicationMessageId() != null) {
                span.setAttribute(MessagingAttribute.MESSAGE_ID.toString(), requestMessage.getApplicationMessageId());
            }
            if (isTemporary) {
                span.setAttribute(MessagingAttribute.DESTINATION_TEMPORARY.toString(), true);
            }
            if (isAnonymous) {
                span.setAttribute(MessagingAttribute.DESTINATION_ANONYMOUS.toString(), true);
            }
            try (Scope scope = span.makeCurrent();){
                TextMapPropagator propagator = openTelemetry.getPropagators().getTextMapPropagator();
                propagator.inject(Context.current(), (Object)requestMessage, (TextMapSetter)new SolaceJCSMPTextMapSetter());
            }
            return parentScope;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.Thrown Throwable throwable, @Advice.Local(value="otelSpan") Span span, @Advice.Enter Scope scope) {
            if (throwable != null) {
                span.setAttribute(MessagingAttribute.ERROR_TYPE.toString(), throwable.getClass().getName());
                span.recordException(throwable);
                span.setStatus(StatusCode.ERROR);
                scope.close();
                span.end();
                return;
            }
            scope.close();
            span.end();
        }
    }

    public static class ProducerSendMultipleEntryMethodAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void before(@Advice.This XMLMessageProducer producer, @Advice.Argument(value=0) JCSMPSendMultipleEntry[] entries, @Advice.Argument(value=1) int offset, @Advice.Argument(value=2) int length, @Advice.Local(value="otelSpan") Span[] spans, @Advice.Local(value="otelScope") Scope[] scopes, @Advice.Local(value="isGuaranteedMsg") boolean isGuaranteedMsg) {
            scopes = new Scope[length - offset];
            spans = new Span[length - offset];
            OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
            Tracer tracer = GlobalOpenTelemetry.getTracer((String)"solace-opentelemetry-jcsmp-integration", (String)"1.2.0");
            for (int i = offset; i < length; ++i) {
                XMLMessage message = entries[i].getMessage();
                Context context = Context.current();
                if (context == Context.root()) {
                    context = openTelemetry.getPropagators().getTextMapPropagator().extract(Context.current(), (Object)message, (TextMapGetter)new SolaceJCSMPTextMapGetter());
                }
                scopes[i] = context.makeCurrent();
                Destination destination = entries[i].getDestination();
                String destKind = "";
                String spanDestName = "";
                boolean isTemporary = destination.isTemporary();
                boolean isAnonymous = false;
                if (destination instanceof Queue) {
                    destKind = "queue";
                    isAnonymous = isTemporary && ((Queue)destination).isAnonymous();
                    spanDestName = destination.getName();
                } else if (destination instanceof Topic) {
                    destKind = "topic";
                    spanDestName = "(topic)";
                    isAnonymous = isTemporary;
                }
                spans[i] = tracer.spanBuilder((Object)((Object)MessagingOperation.publish) + " " + (isAnonymous ? "(anonymous)" : spanDestName)).setSpanKind(SpanKind.PRODUCER).setAttribute(MessagingAttribute.API_NAME.toString(), "jcsmp").setAttribute(MessagingAttribute.API_VERSION.toString(), new JCSMPVersion().getSwVersion()).setAttribute(MessagingAttribute.DESTINATION.toString(), destination.getName()).setAttribute(MessagingAttribute.DESTINATION_TYPE.toString(), destKind).setAttribute(MessagingAttribute.DELIVERY_MODE.toString(), message.getDeliveryMode().toString()).setAttribute(MessagingAttribute.OPERATION.toString(), "publish").setAttribute(MessagingAttribute.OPERATION_TYPE.toString(), "publish").setAttribute(MessagingAttribute.SYSTEM.toString(), "SolacePubSub+").setParent(context).startSpan();
                if (message.getApplicationMessageId() != null) {
                    spans[i].setAttribute(MessagingAttribute.MESSAGE_ID.toString(), message.getApplicationMessageId());
                }
                if (isTemporary) {
                    spans[i].setAttribute(MessagingAttribute.DESTINATION_TEMPORARY.toString(), true);
                }
                if (isAnonymous) {
                    spans[i].setAttribute(MessagingAttribute.DESTINATION_ANONYMOUS.toString(), true);
                }
                if (message.getDeliveryMode() == DeliveryMode.DIRECT || producer.isTransacted()) {
                    try (Scope scope = spans[i].makeCurrent();){
                        TextMapPropagator propagator = openTelemetry.getPropagators().getTextMapPropagator();
                        propagator.inject(Context.current(), (Object)message, (TextMapSetter)new SolaceJCSMPTextMapSetter());
                        continue;
                    }
                }
                if (message.getDeliveryMode() != DeliveryMode.NON_PERSISTENT && message.getDeliveryMode() != DeliveryMode.PERSISTENT) continue;
                isGuaranteedMsg = true;
                Context otelContext = Context.current().with((ImplicitContextKeyed)spans[i]);
                if (message instanceof MessageTracingSupport) {
                    ((MessageTracingSupport)message).setContext((Object)otelContext);
                }
                TextMapPropagator propagator = openTelemetry.getPropagators().getTextMapPropagator();
                propagator.inject(Context.current().with((ImplicitContextKeyed)spans[i]), (Object)message, (TextMapSetter)new SolaceJCSMPTextMapSetter());
            }
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.Thrown Throwable throwable, @Advice.Argument(value=0) JCSMPSendMultipleEntry[] entries, @Advice.Local(value="otelSpan") Span[] spans, @Advice.Local(value="otelScope") Scope[] scopes, @Advice.Local(value="isGuaranteedMsg") boolean isGuaranteedMsg, @Advice.This XMLMessageProducer producer) {
            if (throwable != null) {
                for (int i = 0; i < scopes.length; ++i) {
                    spans[i].setAttribute(MessagingAttribute.ERROR_TYPE.toString(), throwable.getClass().getName());
                    spans[i].recordException(throwable);
                    spans[i].setStatus(StatusCode.ERROR);
                    scopes[i].close();
                    spans[i].end();
                }
                return;
            }
            for (int i = 0; i < scopes.length; ++i) {
                scopes[i].close();
                if (isGuaranteedMsg) continue;
                spans[i].end();
            }
        }
    }

    public static class ProducerSendWithDestinationMethodAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Scope before(@Advice.This XMLMessageProducer producer, @Advice.Argument(value=0) XMLMessage message, @Advice.Argument(value=1) Destination destination, @Advice.Local(value="otelSpan") Span span) {
            if (message.isReplyMessage() && message.getReplyTo() == null && message.getCorrelationId().startsWith("#REQ")) {
                return null;
            }
            if (!message.isReplyMessage() && message.getReplyTo() != null && message.getCorrelationId().startsWith("#REQ") && message.getDeliveryMode() == DeliveryMode.DIRECT) {
                return null;
            }
            OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
            Tracer tracer = GlobalOpenTelemetry.getTracer((String)"solace-opentelemetry-jcsmp-integration", (String)"1.2.0");
            Context context = Context.current();
            if (context == Context.root()) {
                context = openTelemetry.getPropagators().getTextMapPropagator().extract(Context.current(), (Object)message, (TextMapGetter)new SolaceJCSMPTextMapGetter());
            }
            if (message.isReplyMessage()) {
                context = Context.root();
            }
            Scope parentScope = context.makeCurrent();
            String destKind = "";
            String spanDestName = "";
            boolean isTemporary = destination.isTemporary();
            boolean isAnonymous = false;
            if (destination instanceof Queue) {
                destKind = "queue";
                isAnonymous = isTemporary && ((Queue)destination).isAnonymous();
                spanDestName = destination.getName();
            } else if (destination instanceof Topic) {
                destKind = "topic";
                spanDestName = "(topic)";
                isAnonymous = isTemporary;
            }
            span = tracer.spanBuilder((Object)((Object)MessagingOperation.publish) + " " + (isAnonymous ? "(anonymous)" : spanDestName)).setSpanKind(SpanKind.PRODUCER).setAttribute(MessagingAttribute.API_NAME.toString(), "jcsmp").setAttribute(MessagingAttribute.API_VERSION.toString(), new JCSMPVersion().getSwVersion()).setAttribute(MessagingAttribute.DESTINATION.toString(), destination.getName()).setAttribute(MessagingAttribute.DESTINATION_TYPE.toString(), destKind).setAttribute(MessagingAttribute.DELIVERY_MODE.toString(), message.getDeliveryMode().toString()).setAttribute(MessagingAttribute.OPERATION.toString(), "publish").setAttribute(MessagingAttribute.OPERATION_TYPE.toString(), "publish").setAttribute(MessagingAttribute.SYSTEM.toString(), "SolacePubSub+").setParent(context).startSpan();
            if (message.getApplicationMessageId() != null) {
                span.setAttribute(MessagingAttribute.MESSAGE_ID.toString(), message.getApplicationMessageId());
            }
            if (isTemporary) {
                span.setAttribute(MessagingAttribute.DESTINATION_TEMPORARY.toString(), true);
            }
            if (isAnonymous) {
                span.setAttribute(MessagingAttribute.DESTINATION_ANONYMOUS.toString(), true);
            }
            if (message.getDeliveryMode() == DeliveryMode.DIRECT || producer.isTransacted()) {
                try (Scope scope = span.makeCurrent();){
                    TextMapPropagator propagator = openTelemetry.getPropagators().getTextMapPropagator();
                    propagator.inject(Context.current(), (Object)message, (TextMapSetter)new SolaceJCSMPTextMapSetter());
                }
            } else if (message.getDeliveryMode() == DeliveryMode.NON_PERSISTENT || message.getDeliveryMode() == DeliveryMode.PERSISTENT) {
                Context otelContext = Context.current().with((ImplicitContextKeyed)span);
                if (message instanceof MessageTracingSupport) {
                    ((MessageTracingSupport)message).setContext((Object)otelContext);
                }
                TextMapPropagator propagator = openTelemetry.getPropagators().getTextMapPropagator();
                propagator.inject(Context.current().with((ImplicitContextKeyed)span), (Object)message, (TextMapSetter)new SolaceJCSMPTextMapSetter());
            }
            return parentScope;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.Thrown Throwable throwable, @Advice.Local(value="otelSpan") Span span, @Advice.Enter Scope scope, @Advice.Argument(value=0) XMLMessage message, @Advice.This XMLMessageProducer producer) {
            if (scope == null) {
                return;
            }
            if (throwable != null) {
                span.setAttribute(MessagingAttribute.ERROR_TYPE.toString(), throwable.getClass().getName());
                span.recordException(throwable);
                span.setStatus(StatusCode.ERROR);
                scope.close();
                span.end();
                return;
            }
            scope.close();
            if (message.getDeliveryMode() == DeliveryMode.DIRECT || producer.isTransacted()) {
                span.end();
            }
        }
    }
}

