/*
 * Copyright 2025 Solace Corporation. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.solace.serdes;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;

/**
 * Internal encoding utility class to handle {@link StringSerializer} and {@link StringDeserializer} encoding configuration.
 */
class EncodingUtil {
    private EncodingUtil(){}
    public static Charset getEncoding(Object encodingValue){
        if (encodingValue instanceof String) {
            String name = (String)encodingValue;
            try {
                return Charset.forName(name);
            } catch (UnsupportedCharsetException | IllegalCharsetNameException e) {
                throw new IllegalArgumentException("Unsupported charset encoding " + name, e);
            }
        } else if (encodingValue instanceof Charset && ((Charset) encodingValue).canEncode()) {
            return (Charset) encodingValue;
        } else {
            throw new IllegalArgumentException("Unsupported charset encoding type");
        }
    }
}
