/*
 * Copyright 2025 Solace Corporation. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.solace.serdes;

import java.util.Map;

/**
 * Runtime exception raised when an error occurs as a part of {@link Deserializer} or {@link Serializer} operation.
 * <br>
 * Example operations:
 * <ul>
 *     <li>{@link Serializer#serialize(String, Object)}</li>
 *     <li>{@link Serializer#serialize(String, Object, Map)}</li>
 *     <li>{@link Deserializer#deserialize(String, byte[])}</li>
 *     <li>{@link Deserializer#deserialize(String, byte[], Map)}</li>
 * </ul>
 *
 * @since 1.0
 */
public class SerializationException extends RuntimeException {
    /**
     * Constructs a new serialization exception with null as its detail message.
     */
    public SerializationException() {
        super();
    }

    /**
     * Constructs a new serialization exception with message.
     * @param message the detail message.
     */
    public SerializationException(final String message) {
        super(message);
    }

    /**
     * Constructs a new serialization exception with the specified cause and a detail message of (cause==null ? null : cause.toString()) (which typically contains the class and detail message of cause). This constructor is useful for serialization exceptions that are little more than wrappers for other throwables.
     * @param cause the cause. (A null value is permitted, and indicates that the cause is nonexistent or unknown.)
     */
    public SerializationException(final Throwable cause) {
        super(cause);
    }

    /**
     * Constructs a new serialization exception with the specified detail message and cause.
     * Note that the detail message associated with cause is not automatically incorporated in this serialization exception's detail message.
     * @param message the detail message.
     * @param cause the cause. (A null value is permitted, and indicates that the cause is nonexistent or unknown.)
     */
    public SerializationException(final String message, final Throwable cause) {
        super(message, cause);
    }
}
