/*
 * Copyright 2025 Solace Corporation. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.solace.serdes.version;

/**
 * Provides access to the artifact's version and build revision information.
 */
public interface VersionInfo {

    /**
     * Gets a VersionInfo instance.
     * @return A VersionInfo instance.
     */
    static VersionInfo getInfo() {
        return new VersionInfoImpl();
    }

    /**
     * Gets the version string of the artifact.
     * Typically corresponds to the Maven project version.
     * @return The artifact version.
     */
    String getVersion();

    /**
     * Gets the SCM revision identifier (Git commit hash) of the build.
     * @return The SCM revision string.
     */
    String getRevision();

    /**
     * Gets the module name of the artifact.
     *
     * @return The module name string
     */
    String getModule();
}
