/*
 * Decompiled with CFR 0.152.
 */
package com.solace.spring.cloud.stream.binder;

import com.solace.spring.cloud.stream.binder.inbound.BatchCollector;
import com.solace.spring.cloud.stream.binder.inbound.JCSMPInboundChannelAdapter;
import com.solace.spring.cloud.stream.binder.inbound.JCSMPMessageSource;
import com.solace.spring.cloud.stream.binder.meter.SolaceMeterAccessor;
import com.solace.spring.cloud.stream.binder.outbound.JCSMPOutboundMessageHandler;
import com.solace.spring.cloud.stream.binder.properties.SolaceCommonProperties;
import com.solace.spring.cloud.stream.binder.properties.SolaceConsumerProperties;
import com.solace.spring.cloud.stream.binder.properties.SolaceExtendedBindingProperties;
import com.solace.spring.cloud.stream.binder.properties.SolaceProducerProperties;
import com.solace.spring.cloud.stream.binder.provisioning.SolaceConsumerDestination;
import com.solace.spring.cloud.stream.binder.provisioning.SolaceProvisioningUtil;
import com.solace.spring.cloud.stream.binder.provisioning.SolaceQueueProvisioner;
import com.solace.spring.cloud.stream.binder.util.ErrorQueueInfrastructure;
import com.solace.spring.cloud.stream.binder.util.JCSMPSessionProducerManager;
import com.solace.spring.cloud.stream.binder.util.RetryableTaskService;
import com.solace.spring.cloud.stream.binder.util.SolaceErrorMessageHandler;
import com.solace.spring.cloud.stream.binder.util.SolaceMessageHeaderErrorMessageStrategy;
import com.solacesystems.jcsmp.Context;
import com.solacesystems.jcsmp.EndpointProperties;
import com.solacesystems.jcsmp.JCSMPSession;
import com.solacesystems.jcsmp.Queue;
import com.solacesystems.jcsmp.XMLMessage;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.cloud.stream.binder.AbstractMessageChannelBinder;
import org.springframework.cloud.stream.binder.BinderSpecificPropertiesProvider;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.DefaultPollableMessageSource;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedPropertiesBinder;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.integration.StaticMessageHeaderAccessor;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.support.ErrorMessageStrategy;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.retry.RecoveryCallback;

public class SolaceMessageChannelBinder
extends AbstractMessageChannelBinder<ExtendedConsumerProperties<SolaceConsumerProperties>, ExtendedProducerProperties<SolaceProducerProperties>, SolaceQueueProvisioner>
implements ExtendedPropertiesBinder<MessageChannel, SolaceConsumerProperties, SolaceProducerProperties>,
DisposableBean {
    private final JCSMPSession jcsmpSession;
    private final Context jcsmpContext;
    private final JCSMPSessionProducerManager sessionProducerManager;
    private final AtomicBoolean consumersRemoteStopFlag = new AtomicBoolean(false);
    private final String errorHandlerProducerKey = UUID.randomUUID().toString();
    private SolaceMeterAccessor solaceMeterAccessor;
    private SolaceExtendedBindingProperties extendedBindingProperties = new SolaceExtendedBindingProperties();
    private final RetryableTaskService taskService = new RetryableTaskService();
    private static final SolaceMessageHeaderErrorMessageStrategy errorMessageStrategy = new SolaceMessageHeaderErrorMessageStrategy();

    public SolaceMessageChannelBinder(JCSMPSession jcsmpSession, SolaceQueueProvisioner solaceQueueProvisioner) {
        this(jcsmpSession, null, solaceQueueProvisioner);
    }

    public SolaceMessageChannelBinder(JCSMPSession jcsmpSession, Context jcsmpContext, SolaceQueueProvisioner solaceQueueProvisioner) {
        super(new String[0], (ProvisioningProvider)solaceQueueProvisioner);
        this.jcsmpSession = jcsmpSession;
        this.jcsmpContext = jcsmpContext;
        this.sessionProducerManager = new JCSMPSessionProducerManager(jcsmpSession);
    }

    public void destroy() {
        this.logger.info((Object)String.format("Closing JCSMP session %s", this.jcsmpSession.getSessionName()));
        if (this.taskService != null) {
            this.taskService.close();
        }
        this.sessionProducerManager.release(this.errorHandlerProducerKey);
        this.consumersRemoteStopFlag.set(true);
        this.jcsmpSession.closeSession();
        if (this.jcsmpContext != null) {
            this.jcsmpContext.destroy();
        }
    }

    protected MessageHandler createProducerMessageHandler(ProducerDestination destination, ExtendedProducerProperties<SolaceProducerProperties> producerProperties, MessageChannel errorChannel) {
        JCSMPOutboundMessageHandler handler = new JCSMPOutboundMessageHandler(destination, this.jcsmpSession, errorChannel, this.sessionProducerManager, producerProperties, this.solaceMeterAccessor);
        if (errorChannel != null) {
            handler.setErrorMessageStrategy((ErrorMessageStrategy)errorMessageStrategy);
        }
        return handler;
    }

    protected MessageProducer createConsumerEndpoint(ConsumerDestination destination, String group, ExtendedConsumerProperties<SolaceConsumerProperties> properties) {
        SolaceConsumerDestination solaceDestination = (SolaceConsumerDestination)destination;
        JCSMPInboundChannelAdapter adapter = new JCSMPInboundChannelAdapter(solaceDestination, this.jcsmpSession, this.taskService, properties, this.getConsumerEndpointProperties(properties), this.solaceMeterAccessor);
        adapter.setRemoteStopFlag(this.consumersRemoteStopFlag);
        adapter.setPostStart(this.getConsumerPostStart(solaceDestination, properties));
        if (((SolaceConsumerProperties)properties.getExtension()).isAutoBindErrorQueue()) {
            adapter.setErrorQueueInfrastructure(new ErrorQueueInfrastructure(this.sessionProducerManager, this.errorHandlerProducerKey, solaceDestination.getErrorQueueName(), (SolaceConsumerProperties)properties.getExtension(), this.taskService));
        }
        AbstractMessageChannelBinder.ErrorInfrastructure errorInfra = this.registerErrorInfrastructure(destination, group, (ConsumerProperties)properties);
        if (properties.getMaxAttempts() > 1) {
            adapter.setRetryTemplate(this.buildRetryTemplate((ConsumerProperties)properties));
            adapter.setRecoveryCallback((RecoveryCallback)errorInfra.getRecoverer());
        } else {
            adapter.setErrorChannel((MessageChannel)errorInfra.getErrorChannel());
        }
        adapter.setErrorMessageStrategy((ErrorMessageStrategy)errorMessageStrategy);
        return adapter;
    }

    protected AbstractMessageChannelBinder.PolledConsumerResources createPolledConsumerResources(String name, String group, ConsumerDestination destination, ExtendedConsumerProperties<SolaceConsumerProperties> consumerProperties) {
        if (consumerProperties.getConcurrency() > 1) {
            this.logger.warn((Object)"Polled consumers do not support concurrency > 1, it will be ignored...");
        }
        SolaceConsumerDestination solaceDestination = (SolaceConsumerDestination)destination;
        EndpointProperties endpointProperties = this.getConsumerEndpointProperties(consumerProperties);
        JCSMPMessageSource messageSource = new JCSMPMessageSource(solaceDestination, this.jcsmpSession, consumerProperties.isBatchMode() ? new BatchCollector((SolaceConsumerProperties)consumerProperties.getExtension()) : null, this.taskService, consumerProperties, endpointProperties, this.solaceMeterAccessor);
        messageSource.setRemoteStopFlag(this.consumersRemoteStopFlag::get);
        messageSource.setPostStart(this.getConsumerPostStart(solaceDestination, consumerProperties));
        if (((SolaceConsumerProperties)consumerProperties.getExtension()).isAutoBindErrorQueue()) {
            messageSource.setErrorQueueInfrastructure(new ErrorQueueInfrastructure(this.sessionProducerManager, this.errorHandlerProducerKey, solaceDestination.getErrorQueueName(), (SolaceConsumerProperties)consumerProperties.getExtension(), this.taskService));
        }
        AbstractMessageChannelBinder.ErrorInfrastructure errorInfra = this.registerErrorInfrastructure(destination, group, (ConsumerProperties)consumerProperties, true);
        return new AbstractMessageChannelBinder.PolledConsumerResources((MessageSource)messageSource, errorInfra);
    }

    protected void postProcessPollableSource(DefaultPollableMessageSource bindingTarget) {
        bindingTarget.setAttributesProvider((accessor, message) -> {
            Object sourceData = StaticMessageHeaderAccessor.getSourceData((Message)message);
            if (sourceData == null || sourceData instanceof XMLMessage || sourceData instanceof List) {
                accessor.setAttribute("solace_sourceData", sourceData);
            }
        });
    }

    protected MessageHandler getErrorMessageHandler(ConsumerDestination destination, String group, ExtendedConsumerProperties<SolaceConsumerProperties> consumerProperties) {
        return new SolaceErrorMessageHandler();
    }

    protected MessageHandler getPolledConsumerErrorMessageHandler(ConsumerDestination destination, String group, ExtendedConsumerProperties<SolaceConsumerProperties> consumerProperties) {
        MessageHandler handler = this.getErrorMessageHandler(destination, group, consumerProperties);
        if (handler != null) {
            return handler;
        }
        return super.getPolledConsumerErrorMessageHandler(destination, group, consumerProperties);
    }

    protected ErrorMessageStrategy getErrorMessageStrategy() {
        return errorMessageStrategy;
    }

    protected String errorsBaseName(ConsumerDestination destination, String group, ExtendedConsumerProperties<SolaceConsumerProperties> consumerProperties) {
        SolaceConsumerDestination solaceDestination = (SolaceConsumerDestination)destination;
        StringBuilder errorsBaseName = new StringBuilder(solaceDestination.getBindingDestinationName()).append('.');
        if (solaceDestination.isTemporary()) {
            errorsBaseName.append("anon").append('.');
        }
        return errorsBaseName.append(solaceDestination.getPhysicalGroupName()).append(".errors").toString();
    }

    public SolaceConsumerProperties getExtendedConsumerProperties(String channelName) {
        return (SolaceConsumerProperties)this.extendedBindingProperties.getExtendedConsumerProperties(channelName);
    }

    public SolaceProducerProperties getExtendedProducerProperties(String channelName) {
        return (SolaceProducerProperties)this.extendedBindingProperties.getExtendedProducerProperties(channelName);
    }

    public String getDefaultsPrefix() {
        return this.extendedBindingProperties.getDefaultsPrefix();
    }

    public Class<? extends BinderSpecificPropertiesProvider> getExtendedPropertiesEntryClass() {
        return this.extendedBindingProperties.getExtendedPropertiesEntryClass();
    }

    public void setExtendedBindingProperties(SolaceExtendedBindingProperties extendedBindingProperties) {
        this.extendedBindingProperties = extendedBindingProperties;
    }

    public void setSolaceMeterAccessor(SolaceMeterAccessor solaceMeterAccessor) {
        this.solaceMeterAccessor = solaceMeterAccessor;
    }

    private EndpointProperties getConsumerEndpointProperties(ExtendedConsumerProperties<SolaceConsumerProperties> properties) {
        return SolaceProvisioningUtil.getEndpointProperties((SolaceCommonProperties)((SolaceCommonProperties)properties.getExtension()));
    }

    private Consumer<Queue> getConsumerPostStart(SolaceConsumerDestination destination, ExtendedConsumerProperties<SolaceConsumerProperties> properties) {
        return queue -> {
            ((SolaceQueueProvisioner)this.provisioningProvider).addSubscriptionToQueue(queue, destination.getBindingDestinationName(), (SolaceCommonProperties)properties.getExtension(), true);
            for (String subscription : destination.getAdditionalSubscriptions()) {
                ((SolaceQueueProvisioner)this.provisioningProvider).addSubscriptionToQueue(queue, subscription, (SolaceCommonProperties)properties.getExtension(), false);
            }
        };
    }
}

