/*
 * Decompiled with CFR 0.152.
 */
package com.solace.spring.cloud.stream.binder.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.Status;

public class SolaceBinderHealthIndicator
implements HealthIndicator {
    private static final String STATUS_RECONNECTING = "RECONNECTING";
    private static final String INFO = "info";
    private static final String RESPONSE_CODE = "responseCode";
    private volatile Health healthStatus;
    private static final Log logger = LogFactory.getLog(SolaceBinderHealthIndicator.class);

    public void up() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Solace binder status is %s", Status.UP));
        }
        this.healthStatus = Health.up().build();
    }

    public void reconnecting() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Solace binder status is %s", STATUS_RECONNECTING));
        }
        this.healthStatus = Health.status((String)STATUS_RECONNECTING).build();
    }

    public void down(Exception exception, int responseCode, String info) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Solace binder status is %s", Status.DOWN));
        }
        Health.Builder builder = Health.down();
        if (exception != null) {
            builder.withException((Throwable)exception);
        }
        if (responseCode != 0) {
            builder.withDetail(RESPONSE_CODE, (Object)responseCode);
        }
        if (info != null && !info.isEmpty()) {
            builder.withDetail(INFO, (Object)info);
        }
        this.healthStatus = builder.build();
    }

    public Health health() {
        return this.healthStatus;
    }
}

