/*
 * Decompiled with CFR 0.152.
 */
package com.solace.spring.cloud.stream.binder.util;

import com.solace.spring.cloud.stream.binder.util.SolaceBinderHealthIndicator;
import com.solacesystems.jcsmp.SessionEvent;
import com.solacesystems.jcsmp.SessionEventArgs;
import com.solacesystems.jcsmp.SessionEventHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component
public class SolaceSessionEventHandler
implements SessionEventHandler {
    private final SolaceBinderHealthIndicator solaceBinderHealthIndicator;
    private static final Log logger = LogFactory.getLog(SolaceSessionEventHandler.class);

    public SolaceSessionEventHandler(SolaceBinderHealthIndicator solaceBinderHealthIndicator) {
        this.solaceBinderHealthIndicator = solaceBinderHealthIndicator;
    }

    public void handleEvent(SessionEventArgs sessionEvent) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Received Solace session event %s.", sessionEvent));
        }
        if (sessionEvent.getEvent() == SessionEvent.DOWN_ERROR) {
            this.solaceBinderHealthIndicator.down(sessionEvent.getException(), sessionEvent.getResponseCode(), sessionEvent.getInfo());
        } else if (sessionEvent.getEvent() == SessionEvent.RECONNECTING) {
            this.solaceBinderHealthIndicator.reconnecting();
        } else if (sessionEvent.getEvent() == SessionEvent.RECONNECTED) {
            this.solaceBinderHealthIndicator.up();
        }
    }

    public void connected() {
        this.solaceBinderHealthIndicator.up();
    }
}

