-- Based off https://groups.google.com/g/pandoc-discuss/c/65G0Kuih1wA
-- requires pandoc 2.19+

local admonitions = {
  warning   = 'WARNING',
  note      = 'NOTE',
  tip       = 'TIP',
  important = 'IMPORTANT',
  caution   = 'CAUTION'
}

local opts = pandoc.WriterOptions(PANDOC_WRITER_OPTIONS) -- reuse options to render snippets
opts.template = pandoc.template.compile('$body$')        -- render a snippet

function Div (div)
  local admonition_text = admonitions[div.classes[1]]
  if not admonition_text then return nil end  -- not an admonition: exit

  local md = '> **' .. admonition_text .. '**\n\n' .. pandoc.write(pandoc.Pandoc(div.content), 'markdown', opts)
  return pandoc.RawBlock(
    'markdown',
    md:gsub('\n*$', '')   -- remove trailing newlines
      :gsub('\n', '\n> ') -- add block quote
  )
end
