/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.impl;

import com.solacesystems.common.HostInfo;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.InvalidOperationException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.SessionEvent;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessage;
import com.solacesystems.jcsmp.impl.SessionEventArgsImpl;
import com.solacesystems.jcsmp.protocol.impl.TcpClientChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChannelOpStrategy {
    private static final Log Trace = LogFactory.getLog(ChannelOpStrategy.class);
    protected TcpClientChannel channel;
    protected TcpClientChannel.ChannelData c_refs;

    public ChannelOpStrategy(TcpClientChannel channel) {
        this.channel = channel;
    }

    public abstract void performOpen(boolean var1) throws JCSMPException;

    public void populateChannelRefs(TcpClientChannel.ChannelData c_refs) {
        this.c_refs = c_refs;
    }

    public abstract void updateClientDescription(String var1) throws JCSMPException;

    public abstract void updateClientName(String var1, String var2) throws JCSMPException;

    public boolean isUserCloseable() {
        return false;
    }

    public void checkSendDestination(Destination destination) {
    }

    protected void checkVridChangeOnLogin(String oldvrid, String newvrid) throws JCSMPException {
        if (oldvrid != null && oldvrid.length() > 0 && !oldvrid.equals(newvrid)) {
            String str = String.format("Host VRID (virtual router name) changed (%s -> %s)", oldvrid, newvrid);
            Trace.info((Object)str);
            this.c_refs.session.notifyVridChange();
            SessionEventArgsImpl ev = new SessionEventArgsImpl(SessionEvent.VIRTUAL_ROUTER_NAME_CHANGED, str, null, 0);
            this.c_refs.session.handleSessionEvent(ev);
        }
    }

    public abstract void establishP2pSub() throws JCSMPException;

    public List<HostInfo> getModeAwareHostList() {
        ArrayList<HostInfo> hlist = new ArrayList<HostInfo>();
        hlist.add(this.c_refs.hostList.get(0));
        return hlist;
    }

    public abstract void buildSendMsgHeader(JCSMPXMLMessage var1, Destination var2, long var3, long var5, long var7, boolean var9) throws InvalidOperationException;
}

