/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.solcache;

import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.SDTException;
import com.solacesystems.jcsmp.SDTStream;
import com.solacesystems.jcsmp.StreamMessage;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessage;
import com.solacesystems.jcsmp.impl.flow.FlowHandleImpl;

public class CacheGetResponse {
    public static final Long OK = 1L;
    private Long mMessageId = null;
    private Long mVersion = null;
    private Long mResponseCode = null;
    private String mResponseString = null;
    private String mMatchTopic = null;
    private Long mSessionId = null;
    private Boolean mSuspect = null;
    private Boolean mMore = null;
    private Boolean mTimestamps = null;
    private SDTStream mClusterNames = null;
    private SDTStream mMessages = null;

    public CacheGetResponse(JCSMPXMLMessage message) throws JCSMPException {
        BytesXMLMessage structMsg = FlowHandleImpl.createStructuredType(message);
        if (!(structMsg instanceof StreamMessage)) {
            throw new JCSMPException("Cache Response Format Error");
        }
        try {
            SDTStream stream = ((StreamMessage)structMsg).getStream();
            this.mMessageId = stream.readLong();
            this.mVersion = stream.readLong();
            this.mResponseCode = stream.readLong();
            this.mResponseString = stream.readString();
            this.mMatchTopic = stream.readString();
            this.mSessionId = stream.readLong();
            this.mSuspect = stream.readBoolean();
            this.mMore = stream.readBoolean();
            this.mTimestamps = stream.readBoolean();
            SDTStream stream1 = null;
            SDTStream stream2 = null;
            if (stream.hasRemaining()) {
                stream1 = stream.readStream();
                if (stream.hasRemaining()) {
                    stream2 = stream.readStream();
                }
            }
            if (stream2 == null) {
                this.mMessages = stream1;
            } else {
                this.mClusterNames = stream1;
                this.mMessages = stream2;
            }
        }
        catch (SDTException e) {
            throw new JCSMPException("Cache Response Format Error", e);
        }
    }

    public Long getMessageId() {
        return this.mMessageId;
    }

    public Long getVersion() {
        return this.mVersion;
    }

    public Long getResponseCode() {
        return this.mResponseCode;
    }

    public String getResponseString() {
        return this.mResponseString;
    }

    public String getMatchTopic() {
        return this.mMatchTopic;
    }

    public Long getSessionId() {
        return this.mSessionId;
    }

    public Boolean isSuspect() {
        return this.mSuspect;
    }

    public Boolean hasMore() {
        return this.mMore;
    }

    public Boolean hasTimestamps() {
        return this.mTimestamps;
    }

    public SDTStream getClusterNames() {
        return this.mClusterNames;
    }

    public SDTStream getMessages() {
        return this.mMessages;
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("MessageId=");
        bldr.append(this.mMessageId);
        bldr.append(", ");
        bldr.append("Version=");
        bldr.append(this.mVersion);
        bldr.append(", ");
        bldr.append("ResponseCode=");
        bldr.append(this.mResponseCode);
        bldr.append(", ");
        bldr.append("ResponseString=");
        bldr.append(this.mResponseString);
        bldr.append(", ");
        bldr.append("MatchTopic=");
        bldr.append(this.mMatchTopic);
        bldr.append(", ");
        bldr.append("SessionId=");
        bldr.append(this.mSessionId);
        bldr.append(", ");
        bldr.append("Suspect=");
        bldr.append(this.mSuspect);
        bldr.append(", ");
        bldr.append("More=");
        bldr.append(this.mMore);
        bldr.append(", ");
        bldr.append("Timestamps=");
        bldr.append(this.mTimestamps);
        bldr.append(", HasClusterNames=");
        bldr.append(this.mClusterNames != null && this.mClusterNames.hasRemaining());
        bldr.append(", HasSMFMessages=");
        bldr.append(this.mMessages != null && this.mMessages.hasRemaining());
        return bldr.toString();
    }
}

