/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.common.util.ByteArray;
import com.solacesystems.jcsmp.impl.SubscriptionMatchEntry;
import com.solacesystems.jcsmp.impl.SubscriptionRemoveResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionHashMap<T> {
    private HashMap<ByteArray, List<T>> mSubscriptionMap = null;

    public Map<ByteArray, List<T>> getMap() {
        return this.mSubscriptionMap;
    }

    public void get(byte[] data, List<SubscriptionMatchEntry<T>> entries) {
        ByteArray ba;
        List<T> matches;
        if (this.mSubscriptionMap != null && (matches = this.mSubscriptionMap.get(ba = new ByteArray(data))) != null) {
            entries.add(new SubscriptionMatchEntry<T>(data, matches));
        }
    }

    public SubscriptionHashMap<T> put(byte[] data, T entry) {
        SubscriptionHashMap<T> retMap = new SubscriptionHashMap<T>();
        retMap.mSubscriptionMap = this.mSubscriptionMap == null ? new HashMap() : new HashMap<ByteArray, List<T>>(this.mSubscriptionMap);
        ByteArray subBytes = new ByteArray(data);
        List<T> entries = retMap.mSubscriptionMap.get(subBytes);
        entries = entries == null ? new ArrayList<T>() : new ArrayList<T>(entries);
        retMap.mSubscriptionMap.put(subBytes, entries);
        entries.add(entry);
        return retMap;
    }

    public SubscriptionHashMap<T> remove(byte[] data, T entry, SubscriptionRemoveResult result) {
        if (this.mSubscriptionMap != null) {
            SubscriptionHashMap<T> retMap = new SubscriptionHashMap<T>();
            retMap.mSubscriptionMap = new HashMap<ByteArray, List<T>>(this.mSubscriptionMap);
            ByteArray subBytes = new ByteArray(data);
            List<T> entries = retMap.mSubscriptionMap.get(subBytes);
            if (entries != null) {
                result.setNumEntriesFound(entries.size());
                for (int i = 0; i < entries.size(); ++i) {
                    T value = entries.get(i);
                    if (value != entry) continue;
                    result.setFound();
                    if (entries.size() == 1) {
                        if (retMap.mSubscriptionMap.size() == 1) {
                            retMap.mSubscriptionMap = null;
                        } else {
                            retMap.mSubscriptionMap.remove(subBytes);
                        }
                    } else {
                        entries = new ArrayList<T>(entries);
                        entries.remove(i);
                        retMap.mSubscriptionMap.put(subBytes, entries);
                    }
                    return retMap;
                }
            }
        }
        return this;
    }

    public void clear() {
        this.mSubscriptionMap = null;
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        if (this.mSubscriptionMap == null) {
            bldr.append("null");
        } else {
            Iterator<ByteArray> it = this.mSubscriptionMap.keySet().iterator();
            while (it.hasNext()) {
                ByteArray ba = it.next();
                bldr.append(new String(ba.getBuffer(), ba.getOffset(), ba.getLength()));
                if (!it.hasNext()) continue;
                bldr.append("\r\n");
            }
        }
        return bldr.toString();
    }
}

