/*
 * Decompiled with CFR 0.152.
 */
package com.solace.transport.impl.netty;

import com.solace.transport.SocketLevelStats;
import com.solace.transport.SolTransport;
import com.solace.transport.TransportConfiguration;
import com.solace.transport.TransportHttpProxyConfiguration;
import com.solace.transport.TransportSSLConfiguration;
import com.solace.transport.TransportSockProxyConfiguration;
import com.solace.transport.handler.SolCompressedStatsHandler;
import com.solace.transport.handler.SolSSLStatsHandler;
import com.solace.transport.impl.netty.NettyTransportEventExceptionHandler;
import com.solace.transport.impl.netty.NettyTransportExecutorService;
import com.solace.transport.impl.netty.NettyTransportInboundFrameDecoderAdapter;
import com.solacesystems.common.util.InetAddressUtil;
import com.solacesystems.common.util.SNIUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class NettySolTransport
implements SolTransport {
    private static final Log Trace = LogFactory.getLog(NettySolTransport.class);
    private static final String ZLIB_ENCODER_NAME = "zlibEncoder";
    private static final String ZLIB_DECODER_NAME = "zlibDecoder";
    private static final String COMPRESSED_STATS_NAME = "compressedStats";
    private static final String EVENT_EMITTER = "eventEmitter";
    private static final String IDLE_EVENT_CALLER = "idleEventCaller";
    private static final String SSL_HANDLER_NAME = "ssl";
    private static final String SSL_STATS_NAME = "SslStats";
    private static final String DECODER_NAME = "frame_decoder";
    private static final String HTTP_PROXY_NAME = "httpProxy";
    private static final String SOCKS5_PROXY_NAME = "socks5Proxy";
    protected NettyTransportExecutorService executor;
    private Bootstrap bootstrap;
    protected volatile ChannelFuture channelFuture;
    private SslHandler sslHandler = null;
    private final TransportConfiguration config;
    private String logInfoRemote = null;
    private String logInfoLocal = null;
    private String logInfoProxy = null;
    protected String hanlderNameBeforeWSStatsHandler = null;
    private final NettyTransportEventExceptionHandler eventHandler;
    static final AttributeKey<Long> TOTAL_SOCKET_BYTES_SENT = AttributeKey.newInstance((String)SolTransport.Stats.TOTAL_SOCKET_BYTES_SENT.getNameValue());
    static final AttributeKey<Long> TOTAL_SOCKET_BYTES_RECVED = AttributeKey.newInstance((String)SolTransport.Stats.TOTAL_SOCKET_BYTES_RECVED.getNameValue());
    static final AttributeKey<Long> TOTAL_SOCKET_SSL_BYTES_SENT = AttributeKey.newInstance((String)SolTransport.Stats.TOTAL_SOCKET_SSL_BYTES_SENT.getNameValue());
    static final AttributeKey<Long> TOTAL_SOCKET_SSL_BYTES_RECVED = AttributeKey.newInstance((String)SolTransport.Stats.TOTAL_SOCKET_SSL_BYTES_RECVED.getNameValue());
    static final AttributeKey<Long> TOTAL_SOCKET_COMPRESSED_BYTES_SENT = AttributeKey.newInstance((String)SolTransport.Stats.TOTAL_SOCKET_COMPRESSED_BYTES_SENT.getNameValue());
    static final AttributeKey<Long> TOTAL_SOCKET_COMPRESSED_BYTES_RECVED = AttributeKey.newInstance((String)SolTransport.Stats.TOTAL_SOCKET_COMPRESSED_BYTES_RECVED.getNameValue());
    static final AttributeKey<Long> TOTAL_SOCKET_WEBSOCKET_BYTES_SENT = AttributeKey.newInstance((String)SolTransport.Stats.TOTAL_SOCKET_WEBSOCKET_BYTES_SENT.getNameValue());
    static final AttributeKey<Long> TOTAL_SOCKET_WEBSOCKET_BYTES_RECVED = AttributeKey.newInstance((String)SolTransport.Stats.TOTAL_SOCKET_WEBSOCKET_BYTES_RECVED.getNameValue());

    NettySolTransport(final TransportConfiguration transportConfiguration, NettyTransportExecutorService executorService, final NettyTransportInboundFrameDecoderAdapter frameDecoder, final NettyTransportEventExceptionHandler transportEventEmitter) {
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)"create NettySolTransport");
        }
        this.config = transportConfiguration;
        this.eventHandler = transportEventEmitter;
        this.bootstrap = new Bootstrap();
        executorService.bootstrap(this.bootstrap);
        this.executor = executorService;
        if (executorService.isEpollSupported()) {
            this.bootstrap.channel(EpollSocketChannel.class);
        } else {
            this.bootstrap.channel(NioSocketChannel.class);
        }
        this.bootstrap.remoteAddress(transportConfiguration.getHost(), transportConfiguration.getPort());
        this.bootstrap.option(ChannelOption.TCP_NODELAY, (Object)transportConfiguration.getTcpNoDelay());
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)transportConfiguration.getConnectTimeoutInMillis());
        this.bootstrap.option(ChannelOption.SO_BROADCAST, (Object)transportConfiguration.getSoBroadcast());
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)transportConfiguration.getSoKeepalive());
        this.bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)transportConfiguration.getSoReuseAddr());
        this.bootstrap.option(ChannelOption.SO_RCVBUF, (Object)transportConfiguration.getSoRcvBuf());
        this.bootstrap.option(ChannelOption.SO_TIMEOUT, (Object)transportConfiguration.getSoTimeout());
        this.bootstrap.option(ChannelOption.SO_LINGER, (Object)transportConfiguration.getSoLinger());
        this.bootstrap.option(ChannelOption.SO_BACKLOG, (Object)transportConfiguration.getSoBacklog());
        if (transportConfiguration.getLocalAddress() != null) {
            this.bootstrap.localAddress((SocketAddress)new InetSocketAddress(transportConfiguration.getLocalAddress(), 0));
        } else {
            this.bootstrap.localAddress(null);
        }
        if (transportConfiguration.getHttpProxyConfig() != null || transportConfiguration.getSockProxyConfig() != null) {
            this.bootstrap.disableResolver();
        }
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) throws Exception {
                Object proxyConfig;
                if (transportConfiguration.getHttpProxyConfig() != null) {
                    proxyConfig = transportConfiguration.getHttpProxyConfig();
                    if (((TransportHttpProxyConfiguration)proxyConfig).getUsername() != null) {
                        channel.pipeline().addLast(NettySolTransport.HTTP_PROXY_NAME, (ChannelHandler)new HttpProxyHandler((SocketAddress)new InetSocketAddress(((TransportHttpProxyConfiguration)proxyConfig).getHost(), ((TransportHttpProxyConfiguration)proxyConfig).getPort()), ((TransportHttpProxyConfiguration)proxyConfig).getUsername(), ((TransportHttpProxyConfiguration)proxyConfig).getPassword()));
                    } else {
                        channel.pipeline().addLast(NettySolTransport.HTTP_PROXY_NAME, (ChannelHandler)new HttpProxyHandler((SocketAddress)new InetSocketAddress(((TransportHttpProxyConfiguration)proxyConfig).getHost(), ((TransportHttpProxyConfiguration)proxyConfig).getPort())));
                    }
                    NettySolTransport.this.hanlderNameBeforeWSStatsHandler = NettySolTransport.HTTP_PROXY_NAME;
                } else if (transportConfiguration.getSockProxyConfig() != null) {
                    proxyConfig = transportConfiguration.getSockProxyConfig();
                    if (((TransportSockProxyConfiguration)proxyConfig).getUsername() != null) {
                        channel.pipeline().addLast(NettySolTransport.SOCKS5_PROXY_NAME, (ChannelHandler)new Socks5ProxyHandler((SocketAddress)new InetSocketAddress(((TransportSockProxyConfiguration)proxyConfig).getHost(), ((TransportSockProxyConfiguration)proxyConfig).getPort()), ((TransportSockProxyConfiguration)proxyConfig).getUsername(), ((TransportSockProxyConfiguration)proxyConfig).getPassword()));
                    } else {
                        channel.pipeline().addLast(NettySolTransport.SOCKS5_PROXY_NAME, (ChannelHandler)new Socks5ProxyHandler((SocketAddress)new InetSocketAddress(((TransportSockProxyConfiguration)proxyConfig).getHost(), ((TransportSockProxyConfiguration)proxyConfig).getPort())));
                    }
                    NettySolTransport.this.hanlderNameBeforeWSStatsHandler = NettySolTransport.SOCKS5_PROXY_NAME;
                }
                if (transportConfiguration.getSSLConfig() != null) {
                    NettySolTransport.this.sslHandler = new SslHandler(NettySolTransport.this.createSSLEngine(transportConfiguration.getSSLConfig(), transportConfiguration.getHost(), transportConfiguration.getPort()));
                    channel.pipeline().addLast(NettySolTransport.SSL_HANDLER_NAME, (ChannelHandler)NettySolTransport.this.sslHandler);
                    NettySolTransport.this.hanlderNameBeforeWSStatsHandler = NettySolTransport.SSL_HANDLER_NAME;
                }
                if (transportConfiguration.getCompressionConfig() != null) {
                    channel.pipeline().addLast(NettySolTransport.ZLIB_DECODER_NAME, (ChannelHandler)ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.NONE));
                    channel.pipeline().addLast(NettySolTransport.ZLIB_ENCODER_NAME, (ChannelHandler)ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.NONE, (int)transportConfiguration.getCompressionConfig().getCompressionLevel()));
                    NettySolTransport.this.hanlderNameBeforeWSStatsHandler = NettySolTransport.ZLIB_ENCODER_NAME;
                }
                NettySolTransport.this.addAdditionalHandlers(channel.pipeline(), transportConfiguration);
                if (transportConfiguration.getIdleReadTimeout() != null || transportConfiguration.getIdleWriteTimeout() != null) {
                    int readIdle = transportConfiguration.getIdleReadTimeout() != null ? transportConfiguration.getIdleReadTimeout() : 0;
                    int writeIdle = transportConfiguration.getIdleWriteTimeout() != null ? transportConfiguration.getIdleWriteTimeout() : 0;
                    channel.pipeline().addLast(NettySolTransport.IDLE_EVENT_CALLER, (ChannelHandler)new IdleStateHandler(readIdle, writeIdle, 0));
                }
                channel.pipeline().addLast(NettySolTransport.DECODER_NAME, (ChannelHandler)frameDecoder);
                if (transportEventEmitter != null) {
                    channel.pipeline().addLast(NettySolTransport.EVENT_EMITTER, (ChannelHandler)transportEventEmitter);
                }
            }
        });
    }

    private String[] getCiphersToUse(SSLEngine engine, TransportSSLConfiguration serviceAttrs) throws Exception {
        HashSet<String> supportedCiphersSet = new HashSet<String>();
        ArrayList<String> ciphersToUseArray = new ArrayList<String>();
        String[] supportedCiphers = engine.getSupportedCipherSuites();
        for (int i = 0; i < supportedCiphers.length; ++i) {
            if (serviceAttrs.getApiCipherMap().get(supportedCiphers[i].toUpperCase()) == null) continue;
            supportedCiphersSet.add(supportedCiphers[i].toUpperCase());
        }
        String[] specifiedCiphers = serviceAttrs.getSpecifiedCipherSuites();
        block1: for (int i = 0; i < specifiedCiphers.length; ++i) {
            String cipher = specifiedCiphers[i];
            if (supportedCiphersSet.contains(cipher.toUpperCase())) {
                ciphersToUseArray.add(cipher);
                continue;
            }
            String[] aliases = serviceAttrs.getApiCipheAliasesMap().get(specifiedCiphers[i].toUpperCase());
            if (aliases == null) continue;
            for (int j = 0; j < aliases.length; ++j) {
                if (!supportedCiphersSet.contains(aliases[j])) continue;
                ciphersToUseArray.add(aliases[j]);
                continue block1;
            }
        }
        if (ciphersToUseArray.size() == 0) {
            throw new Exception("No cipher to use");
        }
        if (Trace.isInfoEnabled()) {
            Trace.info((Object)("TLS Ciphers: " + ciphersToUseArray.toString()));
        }
        return ciphersToUseArray.toArray(new String[ciphersToUseArray.size()]);
    }

    private String[] getProtocolToUse(SSLEngine engine, TransportSSLConfiguration serviceAttrs) throws Exception {
        HashSet<String> supportedProtocolsSet = new HashSet<String>();
        ArrayList<String> protocolsToUseArray = new ArrayList<String>();
        String[] supportedProtocols = engine.getSupportedProtocols();
        for (int i = 0; i < supportedProtocols.length; ++i) {
            for (int j = 0; j < serviceAttrs.getApiSupportedProtocols().length; ++j) {
                if (!supportedProtocols[i].toUpperCase().equals(serviceAttrs.getApiSupportedProtocols()[j].toUpperCase())) continue;
                supportedProtocolsSet.add(supportedProtocols[i].toUpperCase());
            }
        }
        String[] specifiedProtocols = serviceAttrs.getSpecifiedProtocols();
        for (int i = 0; i < specifiedProtocols.length; ++i) {
            if (!supportedProtocolsSet.contains(specifiedProtocols[i].toUpperCase())) continue;
            protocolsToUseArray.add(specifiedProtocols[i]);
        }
        if (protocolsToUseArray.size() == 0) {
            throw new Exception("No protocol to use");
        }
        if (Trace.isInfoEnabled()) {
            Trace.info((Object)("TLS Protocols: " + protocolsToUseArray.toString()));
        }
        return protocolsToUseArray.toArray(new String[protocolsToUseArray.size()]);
    }

    private SSLEngine createSSLEngine(TransportSSLConfiguration serviceAttrs, String remote_host, int remote_port) throws Exception {
        SSLParameters sslParameters;
        SSLEngine sslEngine = serviceAttrs.getSslContext().createSSLEngine(remote_host, remote_port);
        sslEngine.setUseClientMode(true);
        sslEngine.setEnabledProtocols(this.getProtocolToUse(sslEngine, serviceAttrs));
        sslEngine.setEnabledCipherSuites(this.getCiphersToUse(sslEngine, serviceAttrs));
        if (InetAddressUtil.isIPv4Address(remote_host) || InetAddressUtil.isIPv6Address(remote_host)) {
            if (Trace.isDebugEnabled()) {
                Trace.debug((Object)"Literal IPv4 and IPv6 addresses are not permitted in 'Hostname'");
            }
        } else {
            sslParameters = sslEngine.getSSLParameters();
            SNIUtil.setServerNames(sslParameters, remote_host);
            sslEngine.setSSLParameters(sslParameters);
        }
        if (serviceAttrs.isHostNameValivationEnabled()) {
            sslParameters = sslEngine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            sslEngine.setSSLParameters(sslParameters);
        }
        return sslEngine;
    }

    private void addSSLStatsHandler(Channel channel) {
        channel.pipeline().addBefore(SSL_HANDLER_NAME, SSL_STATS_NAME, (ChannelHandler)new SolSSLStatsHandler());
    }

    private void addCompressionStatsHandler(Channel channel) {
        channel.pipeline().addBefore(ZLIB_DECODER_NAME, COMPRESSED_STATS_NAME, (ChannelHandler)new SolCompressedStatsHandler());
    }

    protected final void checkConnected() throws IOException {
        if (!this.isOpen()) {
            throw new IOException("Channel is disconnected!");
        }
    }

    private void initStats(Channel channel, SocketLevelStats stats) {
        channel.attr(TOTAL_SOCKET_BYTES_SENT).set((Object)stats.getByteSent());
        channel.attr(TOTAL_SOCKET_BYTES_RECVED).set((Object)stats.getByteReceived());
        channel.attr(TOTAL_SOCKET_SSL_BYTES_SENT).set((Object)stats.getSSLByteSent());
        channel.attr(TOTAL_SOCKET_SSL_BYTES_RECVED).set((Object)stats.getSSLByteReceived());
        channel.attr(TOTAL_SOCKET_COMPRESSED_BYTES_SENT).set((Object)stats.getCompressedByteSent());
        channel.attr(TOTAL_SOCKET_COMPRESSED_BYTES_RECVED).set((Object)stats.getCompressedByteReceived());
        channel.attr(TOTAL_SOCKET_WEBSOCKET_BYTES_SENT).set((Object)stats.getWebSocketByteSent());
        channel.attr(TOTAL_SOCKET_WEBSOCKET_BYTES_RECVED).set((Object)stats.getWebSocketByteReceived());
    }

    protected ChannelPipeline getPipeline() {
        return this.channelFuture.channel().pipeline();
    }

    protected void addAdditionalHandlers(ChannelPipeline pipeline, TransportConfiguration transportConfiguration) {
    }

    protected Integer getConnectTimeoutInMillis() {
        return this.config.getConnectTimeoutInMillis();
    }

    @Override
    public void open(SocketLevelStats stats) throws Throwable {
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)"open netty channel");
        }
        this.channelFuture = this.bootstrap.connect().sync();
        if (this.channelFuture.isSuccess()) {
            if (this.sslHandler != null) {
                this.sslHandler.handshakeFuture().await((long)this.getConnectTimeoutInMillis().intValue(), TimeUnit.MILLISECONDS);
                if (!this.sslHandler.handshakeFuture().isDone() || !this.sslHandler.handshakeFuture().isSuccess()) {
                    Throwable ex = this.sslHandler.handshakeFuture().cause();
                    if (ex != null) {
                        if (Trace.isInfoEnabled()) {
                            Trace.info((Object)("SSL handshake failed: " + ex));
                        }
                        throw ex;
                    }
                    throw new SSLHandshakeException("SSL handshake timeout");
                }
                this.addSSLStatsHandler(this.channelFuture.channel());
            }
            if (this.config.getCompressionConfig() != null) {
                this.addCompressionStatsHandler(this.channelFuture.channel());
            }
            this.initStats(this.channelFuture.channel(), stats);
            this.logInfoRemote = this.channelFuture.channel().remoteAddress().toString();
            this.logInfoLocal = this.channelFuture.channel().localAddress().toString();
            if (this.config.getHttpProxyConfig() != null) {
                this.logInfoProxy = this.config.getHttpProxyConfig().toString();
            } else if (this.config.getSockProxyConfig() != null) {
                this.logInfoProxy = this.config.getSockProxyConfig().toString();
            }
        } else {
            throw this.channelFuture.cause();
        }
    }

    @Override
    public void close() throws IOException {
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)"close netty channel");
        }
        if (this.channelFuture == null || !this.channelFuture.channel().isOpen()) {
            this.channelFuture = null;
            return;
        }
        try {
            this.eventHandler.close();
            this.channelFuture.channel().close().sync();
        }
        catch (InterruptedException e) {
            throw new IOException("channel closing interrupted", e);
        }
        catch (Exception e) {
            throw new IOException("channel closing failed: " + e.getMessage(), e);
        }
        finally {
            this.channelFuture = null;
        }
    }

    @Override
    public boolean isOpen() {
        return this.channelFuture != null && this.channelFuture.channel().isOpen();
    }

    @Override
    public boolean isActive() {
        return this.channelFuture != null && this.channelFuture.channel().isActive();
    }

    @Override
    public void flush() {
        if (this.isOpen()) {
            this.channelFuture.channel().flush();
        }
    }

    protected void updateByteSentStats(long bytes) {
        this.channelFuture.channel().attr(TOTAL_SOCKET_BYTES_SENT).set((Object)((Long)this.channelFuture.channel().attr(TOTAL_SOCKET_BYTES_SENT).get() + bytes));
    }

    @Override
    public synchronized void write(ByteBuffer msg) throws InterruptedException, IOException {
        this.checkConnected();
        this.updateByteSentStats(msg.limit() - msg.position());
        if (this.channelFuture.channel().isWritable() || this.executor.isManagedThread()) {
            this.channelFuture.channel().writeAndFlush((Object)Unpooled.wrappedBuffer((ByteBuffer)msg), this.channelFuture.channel().voidPromise());
        } else {
            this.channelFuture.channel().writeAndFlush((Object)Unpooled.wrappedBuffer((ByteBuffer)msg)).sync();
        }
    }

    @Override
    public void enableCompression(int level) throws Exception {
        this.checkConnected();
        if (this.channelFuture.channel().pipeline().get(SSL_HANDLER_NAME) != null) {
            this.channelFuture.channel().pipeline().addAfter(SSL_HANDLER_NAME, COMPRESSED_STATS_NAME, (ChannelHandler)new SolCompressedStatsHandler());
        } else {
            this.channelFuture.channel().pipeline().addFirst(COMPRESSED_STATS_NAME, (ChannelHandler)new SolCompressedStatsHandler());
        }
        this.channelFuture.channel().pipeline().addAfter(COMPRESSED_STATS_NAME, ZLIB_DECODER_NAME, (ChannelHandler)ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.NONE));
        this.channelFuture.channel().pipeline().addAfter(ZLIB_DECODER_NAME, ZLIB_ENCODER_NAME, (ChannelHandler)ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.NONE, (int)level));
    }

    @Override
    public void shutdownSSL() throws Exception {
        this.checkConnected();
        ((SslHandler)this.channelFuture.channel().pipeline().get(SSL_HANDLER_NAME)).closeOutbound();
        ((SslHandler)this.channelFuture.channel().pipeline().get(SSL_HANDLER_NAME)).sslCloseFuture().sync();
        this.channelFuture.channel().pipeline().remove(SSL_STATS_NAME);
        this.channelFuture.channel().pipeline().remove(SSL_HANDLER_NAME);
    }

    @Override
    public long getTransportStats(SolTransport.Stats stats) {
        AttributeKey attr_key = AttributeKey.valueOf((String)stats.getNameValue());
        return (Long)this.channelFuture.channel().attr(attr_key).get();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        if (this.channelFuture == null) {
            return null;
        }
        return (InetSocketAddress)this.channelFuture.channel().localAddress();
    }

    @Override
    public void resumeReading() throws IOException {
        this.checkConnected();
        this.channelFuture.channel().config().setAutoRead(true);
    }

    @Override
    public void pauseReading() throws IOException {
        this.checkConnected();
        this.channelFuture.channel().config().setAutoRead(false);
    }

    @Override
    public boolean canWrite() throws IOException {
        this.checkConnected();
        return this.isSocketWritable();
    }

    private final boolean isSocketWritable() {
        return this.channelFuture.channel().isWritable();
    }

    public String toString() {
        if (this.logInfoLocal != null && this.logInfoRemote != null) {
            if (this.logInfoProxy != null) {
                return "local(" + this.logInfoLocal + ") remote(" + this.logInfoRemote + ") " + this.logInfoProxy;
            }
            return "local(" + this.logInfoLocal + ") remote(" + this.logInfoRemote + ")";
        }
        return "";
    }
}

