/*
 * Decompiled with CFR 0.152.
 */
package com.solace.transport.impl.netty;

import com.solace.transport.SocketLevelStats;
import com.solace.transport.TransportConfiguration;
import com.solace.transport.handler.SolWebSocketStatsHandler;
import com.solace.transport.handler.WebSocketClientHandler;
import com.solace.transport.impl.netty.NettySolTransport;
import com.solace.transport.impl.netty.NettyTransportEventExceptionHandler;
import com.solace.transport.impl.netty.NettyTransportExecutorService;
import com.solace.transport.impl.netty.NettyTransportInboundFrameDecoderAdapter;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class NettySolWebSocketTransport
extends NettySolTransport {
    static final InternalLogger Trace = InternalLoggerFactory.getInstance(NettySolWebSocketTransport.class);
    private static final String WS_HTTP_CODEC = "http-codec";
    private static final String WS_HTTP_AGREGATOR = "http-object-aggregator";
    private static final String WS_HANDLER = "ws-handler";
    private static final String WEBSOCKET_STATS_NAME = "ws-stats";
    public static final int DEFAULT_LENGTH = 65536;
    final WebSocketClientHandler wsHandler;

    NettySolWebSocketTransport(TransportConfiguration transportConfiguration, NettyTransportExecutorService executorService, NettyTransportInboundFrameDecoderAdapter frameDecoder, NettyTransportEventExceptionHandler transportEventEmitter) {
        super(transportConfiguration, executorService, frameDecoder, transportEventEmitter);
        URI uri = transportConfiguration.isSecure() ? URI.create("wss://" + transportConfiguration.getHost() + ":" + transportConfiguration.getPort()) : URI.create("ws://" + transportConfiguration.getHost() + ":" + transportConfiguration.getPort());
        this.wsHandler = new WebSocketClientHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)false, (HttpHeaders)EmptyHttpHeaders.INSTANCE, (int)transportConfiguration.getWebsocketFrameSize()));
    }

    @Override
    protected void addAdditionalHandlers(ChannelPipeline pipeline, TransportConfiguration transportConfiguration) {
        pipeline.addLast(WS_HTTP_CODEC, (ChannelHandler)new HttpClientCodec());
        pipeline.addLast(WS_HTTP_AGREGATOR, (ChannelHandler)new HttpObjectAggregator(65536));
        pipeline.addLast(WS_HANDLER, (ChannelHandler)this.wsHandler);
    }

    @Override
    public void open(SocketLevelStats stats) throws Throwable {
        super.open(stats);
        if (this.hanlderNameBeforeWSStatsHandler == null) {
            this.getPipeline().addFirst(WEBSOCKET_STATS_NAME, (ChannelHandler)new SolWebSocketStatsHandler());
        } else {
            this.getPipeline().addAfter(this.hanlderNameBeforeWSStatsHandler, WEBSOCKET_STATS_NAME, (ChannelHandler)new SolWebSocketStatsHandler());
        }
        this.wsHandler.handshakeFuture().await((long)this.getConnectTimeoutInMillis().intValue(), TimeUnit.MILLISECONDS);
        if (!this.wsHandler.handshakeFuture().isDone() || !this.wsHandler.handshakeFuture().isSuccess()) {
            Throwable ex = this.wsHandler.handshakeFuture().cause();
            if (ex != null) {
                if (Trace.isInfoEnabled()) {
                    Trace.info("WebSocket handshake failed: " + ex);
                }
                throw ex;
            }
            throw new Throwable("WebSocket handshake timeout");
        }
    }

    @Override
    public void write(ByteBuffer message) throws InterruptedException, IOException {
        this.checkConnected();
        this.updateByteSentStats(message.limit() - message.position());
        if (this.channelFuture.channel().isWritable() || this.executor.isManagedThread()) {
            this.channelFuture.channel().writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((ByteBuffer)message)), this.channelFuture.channel().voidPromise());
        } else {
            this.channelFuture.channel().writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((ByteBuffer)message))).sync();
        }
    }
}

