/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf.impl;

import com.solacesystems.common.util.Base64;
import com.solacesystems.common.util.BitTwiddleUtil;
import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.jcsmp.impl.AbstractDestination;
import com.solacesystems.jcsmp.impl.MessageDestinationAdapter;
import com.solacesystems.jcsmp.protocol.smf.FastSmfParamContainer;
import com.solacesystems.jcsmp.protocol.smf.SMFPubMsgHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SmfExtendedStreamTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.SmfTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.impl.GrowableByteBuffer;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvCoderUtil;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvParameterFactory;
import java.nio.charset.Charset;

public class TlvParameterFactorySmf
extends TlvParameterFactory {
    private static TlvParameterFactorySmf _self = new TlvParameterFactorySmf();
    private static final byte[][] DELIVERY_MODES = new byte[4][];
    private static final byte[] CORRELATION_ID_FIRST_BYTE = new byte[1];
    private static final byte[] ACK_IMMEDIATELY = new byte[1];
    private static final byte TOPIC_NAME_OFFSET_FIRST_BYTE;
    private static final byte QUEUE_NAME_OFFSET_FIRST_BYTE;
    private static final byte MSG_CONTENT_SUMMARY_FIRST_BYTE;

    private TlvParameterFactorySmf() {
    }

    public static TlvParameterFactorySmf instance() {
        return _self;
    }

    public SmfTLVParameter getCorrelationId(long seqNum) {
        byte[] seqNum24 = NetworkByteOrderNumberUtil.intToThreeByte(seqNum);
        return new SmfTLVParameter(0, 32, seqNum24);
    }

    public void addCorrelationId(SMFPubMsgHeaderBean h, long seqNum) {
        h.addEncodedParam(CORRELATION_ID_FIRST_BYTE);
        h.addEncodedParam(NetworkByteOrderNumberUtil.intToThreeByte(seqNum));
    }

    public void addTopicNameOffset(SMFPubMsgHeaderBean h, int offset, int length) {
        FastSmfParamContainer smfcontainer = h.getParamContainer();
        byte[] out = smfcontainer.getBuffer();
        int off = smfcontainer.getOffset();
        int bwritten = 0;
        out[off + bwritten] = TOPIC_NAME_OFFSET_FIRST_BYTE;
        out[off + ++bwritten] = NetworkByteOrderNumberUtil.intToOneByte(offset);
        out[off + ++bwritten] = NetworkByteOrderNumberUtil.intToOneByte(length);
        smfcontainer.incrementOffset(++bwritten);
    }

    public void addQueueNameOffset(SMFPubMsgHeaderBean h, int offset, int length) {
        FastSmfParamContainer smfcontainer = h.getParamContainer();
        byte[] out = smfcontainer.getBuffer();
        int off = smfcontainer.getOffset();
        int bwritten = 0;
        out[off + bwritten] = QUEUE_NAME_OFFSET_FIRST_BYTE;
        out[off + ++bwritten] = NetworkByteOrderNumberUtil.intToOneByte(offset);
        out[off + ++bwritten] = NetworkByteOrderNumberUtil.intToOneByte(length);
        smfcontainer.incrementOffset(++bwritten);
    }

    public void addTrTopicName(SMFPubMsgHeaderBean h, byte[] topicNameBytes) {
        h.addParam(2, 24, topicNameBytes);
    }

    public SmfTLVParameter getTrTopicName(AbstractDestination dest) {
        return new SmfTLVParameter(2, 24, MessageDestinationAdapter.getTrmTopicRepresentation(dest));
    }

    public SmfTLVParameter getUsername(String username) {
        return new SmfTLVParameter(0, 6, Base64.encodeBytes(username.getBytes(Charset.forName("UTF-8")), 8).getBytes(Charset.forName("UTF-8")));
    }

    public void addUsername(SMFPubMsgHeaderBean h, String username) {
        h.addParam(0, 6, Base64.encodeBytes(username.getBytes(Charset.forName("UTF-8")), 8).getBytes(Charset.forName("UTF-8")));
    }

    public SmfTLVParameter getPassword(String pass) {
        return new SmfTLVParameter(0, 7, Base64.encodeBytes(pass.getBytes(Charset.forName("UTF-8")), 8).getBytes(Charset.forName("UTF-8")));
    }

    public void addPassword(SMFPubMsgHeaderBean h, String pass) {
        h.addParam(0, 7, Base64.encodeBytes(pass.getBytes(Charset.forName("UTF-8")), 8).getBytes(Charset.forName("UTF-8")));
    }

    public SmfTLVParameter getGSSAPIToken(byte[] token) {
        SmfExtendedStreamTLVParameter p = new SmfExtendedStreamTLVParameter(0);
        p.addTwoByteLengthParameter(0, 40, token);
        return p;
    }

    public SmfTLVParameter getOauthParameters(String oidc_token, String access_token, String identifier) {
        SmfExtendedStreamTLVParameter p = new SmfExtendedStreamTLVParameter(0);
        byte[] stringBytes = null;
        byte[] ntBytes = null;
        if (oidc_token != null) {
            stringBytes = oidc_token.getBytes(Charset.forName("UTF-8"));
            ntBytes = new byte[stringBytes.length + 1];
            System.arraycopy(stringBytes, 0, ntBytes, 0, stringBytes.length);
            p.addTwoByteLengthParameter(0, 48, ntBytes);
        }
        if (access_token != null) {
            stringBytes = access_token.getBytes(Charset.forName("UTF-8"));
            ntBytes = new byte[stringBytes.length + 1];
            System.arraycopy(stringBytes, 0, ntBytes, 0, stringBytes.length);
            p.addTwoByteLengthParameter(0, 49, ntBytes);
        }
        if (identifier != null) {
            stringBytes = identifier.getBytes(Charset.forName("UTF-8"));
            ntBytes = new byte[stringBytes.length + 1];
            System.arraycopy(stringBytes, 0, ntBytes, 0, stringBytes.length);
            p.addTwoByteLengthParameter(0, 47, ntBytes);
        }
        return p;
    }

    public void addGSSAPIToken(SMFPubMsgHeaderBean h, byte[] token) {
        h.addParam(0, 40, token);
    }

    public void addDeliveryMode(SMFPubMsgHeaderBean h, int value) {
        h.addEncodedParam(DELIVERY_MODES[value]);
    }

    public void addMessagePriorty(SMFPubMsgHeaderBean h, int priority) {
        h.addParam(0, 3, new byte[]{NetworkByteOrderNumberUtil.intToOneByte(priority)});
    }

    public void addUserdata(SMFPubMsgHeaderBean h, byte[] data) {
        if (data.length > 253) {
            throw new IllegalArgumentException("Userdata too long, unable to encode.");
        }
        h.addParam(0, 4, data);
    }

    public void addMessageContentSummary(SMFPubMsgHeaderBean h, int metadataLen, int contentLen, int attLen, int binMetaLen) {
        FastSmfParamContainer smfcontainer = h.getParamContainer();
        byte[] out = smfcontainer.getBuffer();
        int off = smfcontainer.getOffset();
        out[off] = MSG_CONTENT_SUMMARY_FIRST_BYTE;
        int bwritten = 2;
        bwritten += this.encodeMessageElementDescription(out, off + bwritten, 0, metadataLen);
        bwritten += this.encodeMessageElementDescription(out, off + bwritten, 1, contentLen);
        bwritten += this.encodeMessageElementDescription(out, off + bwritten, 2, attLen);
        bwritten += this.encodeMessageElementDescription(out, off + bwritten, 4, binMetaLen);
        out[off + 1] = NetworkByteOrderNumberUtil.intToOneByte(bwritten);
        smfcontainer.incrementOffset(bwritten);
    }

    private int encodeMessageElementDescription(byte[] bufferToWriteTo, int offset, int type, int payloadLen) {
        if (payloadLen < 0) {
            return 0;
        }
        int encodedLen = 1;
        if (payloadLen <= 255) {
            ++encodedLen;
            bufferToWriteTo[offset + 1] = NetworkByteOrderNumberUtil.intToOneByte(payloadLen);
        } else if (payloadLen <= 65535) {
            encodedLen += 2;
            NetworkByteOrderNumberUtil.intToTwoByte(payloadLen, bufferToWriteTo, offset + 1);
        } else if (payloadLen <= 0xFFFFFF) {
            encodedLen += 3;
            NetworkByteOrderNumberUtil.intToThreeByte(payloadLen, bufferToWriteTo, offset + 1);
        } else {
            encodedLen += 4;
            NetworkByteOrderNumberUtil.intToFourByte(payloadLen, bufferToWriteTo, offset + 1);
        }
        long word1 = 0L;
        word1 = BitTwiddleUtil.setBits(word1, type, 4, 4);
        word1 = BitTwiddleUtil.setBits(word1, encodedLen, 4, 0);
        bufferToWriteTo[offset] = NetworkByteOrderNumberUtil.intToOneByte((int)word1);
        return encodedLen;
    }

    public void addAssuredMsgId(SMFPubMsgHeaderBean h, long id) {
        this.addNumericParam(h, 2, 17L, id, 8);
    }

    public void addAssuredPrevMsgId(SMFPubMsgHeaderBean h, long id) {
        this.addNumericParam(h, 2, 18L, id, 8);
    }

    public void addAssuredRedeliveredFlag(SMFPubMsgHeaderBean h) {
        h.addParam(2, 19, new byte[0]);
    }

    public void addAssuredTtl(SMFPubMsgHeaderBean h, long ttl) {
        this.addNumericParam(h, 0, 28L, ttl, 8);
    }

    public void addAssuredFlowId(SMFPubMsgHeaderBean h, long flowId) {
        this.addNumericParam(h, 0, 23L, flowId, 4);
    }

    public void addAssuredPublisherId(SMFPubMsgHeaderBean h, long publisherId) {
        this.addNumericParam(h, 0, 1L, publisherId, 4);
    }

    public void addAckImmediately(SMFPubMsgHeaderBean h) {
        h.addEncodedParam(ACK_IMMEDIATELY);
    }

    private void addNumericParam(SMFPubMsgHeaderBean h, int uh, long type_enum, long value, int valuelen) {
        FastSmfParamContainer smfcontainer = h.getParamContainer();
        byte[] out = smfcontainer.getBuffer();
        int offset = smfcontainer.getOffset();
        int bwritten = 0;
        bwritten += TlvCoderUtil.encodeTL(out, offset, uh, type_enum, valuelen);
        switch (valuelen) {
            case 4: {
                NetworkByteOrderNumberUtil.intToFourByte(value, out, offset + bwritten);
                break;
            }
            case 8: {
                NetworkByteOrderNumberUtil.intToEightByte(value, out, offset + bwritten);
                break;
            }
            default: {
                throw new IllegalArgumentException("Numeric param: should be 4 or 8 bytes");
            }
        }
        smfcontainer.incrementOffset(bwritten += valuelen);
    }

    public SmfTLVParameter getResponse(long respCode, String respString) {
        byte[] respStringData = respString.getBytes(Charset.forName("UTF-8"));
        byte[] respCodeData = NetworkByteOrderNumberUtil.intToFourByte(respCode);
        byte[] respData = new byte[respCodeData.length + respStringData.length];
        System.arraycopy(respCodeData, 0, respData, 0, 4);
        System.arraycopy(respStringData, 0, respData, 4, respStringData.length);
        return new SmfTLVParameter(0, 8, respData);
    }

    static {
        GrowableByteBuffer buf = GrowableByteBuffer.allocate(2);
        TlvCoderUtil.encodeTL(buf, 2, 16L, 1);
        byte[] firstTwoBytes = new byte[2];
        buf.flip();
        buf.get(firstTwoBytes);
        TlvParameterFactorySmf.DELIVERY_MODES[0] = new byte[]{firstTwoBytes[0], firstTwoBytes[1], NetworkByteOrderNumberUtil.intToOneByte(0)};
        TlvParameterFactorySmf.DELIVERY_MODES[1] = new byte[]{firstTwoBytes[0], firstTwoBytes[1], NetworkByteOrderNumberUtil.intToOneByte(1)};
        TlvParameterFactorySmf.DELIVERY_MODES[2] = new byte[]{firstTwoBytes[0], firstTwoBytes[1], NetworkByteOrderNumberUtil.intToOneByte(2)};
        TlvParameterFactorySmf.DELIVERY_MODES[3] = new byte[]{firstTwoBytes[0], firstTwoBytes[1], NetworkByteOrderNumberUtil.intToOneByte(3)};
        buf.clear();
        TlvCoderUtil.encodeTL(buf, 0, 32L, 3);
        buf.flip();
        buf.get(CORRELATION_ID_FIRST_BYTE);
        buf.clear();
        TlvCoderUtil.encodeTL(buf, 3, 36L, 2);
        buf.flip();
        TOPIC_NAME_OFFSET_FIRST_BYTE = buf.get();
        buf.clear();
        TlvCoderUtil.encodeTL(buf, 3, 40L, 2);
        buf.flip();
        QUEUE_NAME_OFFSET_FIRST_BYTE = buf.get();
        buf.clear();
        TlvCoderUtil.encodeTL(buf, 0, 44L, 0);
        buf.flip();
        buf.get(ACK_IMMEDIATELY);
        TlvCoderUtil.encodeTL(firstTwoBytes, 0, 2, 22L, 0);
        MSG_CONTENT_SUMMARY_FIRST_BYTE = firstTwoBytes[0];
    }
}

