/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.property;

import com.solacesystems.common.property.PropertyChangeEvent;
import com.solacesystems.common.property.PropertyChangeListener;
import com.solacesystems.common.property.PropertyConversionException;
import com.solacesystems.common.property.PropertyConverter;
import com.solacesystems.common.property.PropertySource;
import com.solacesystems.common.property.PropertySourceChangeEvent;
import com.solacesystems.common.property.PropertySourceChangeListener;
import com.solacesystems.common.property.PropertyVetoException;
import com.solacesystems.common.property.VetoablePropertySourceChangeListener;
import com.solacesystems.common.property.impl.ValueOfConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Property<T>
implements PropertySourceChangeListener<T>,
VetoablePropertySourceChangeListener<T>,
Cloneable {
    public static final String ANONYMOUS_SOURCE = "_anonymous_";
    public static final String DEFAULT_SOURCE = "_default_";
    public static final String NON_PRINTABLE_VALUE_STRING = "******";
    private static final Log log = LogFactory.getLog(Property.class);
    private String mId;
    private T mValue;
    private boolean mIsSet;
    private PropertySource<T> mMaster;
    private HashMap<String, PropertySource<T>> mSources;
    private ArrayList<PropertyChangeListener<T>> mListeners;
    protected ArrayList<VetoablePropertySourceChangeListener<T>> mVetoableListeners;
    private HashMap<String, Object> mUserData;
    private Class<?> mType;
    private boolean mTrimStrings;
    private boolean mPrintable;

    public Property(Property<T> property) {
        this.mId = property.mId;
        this.mValue = null;
        this.mIsSet = false;
        this.mMaster = null;
        this.mListeners = null;
        if (property.mListeners != null) {
            this.mListeners = (ArrayList)property.mListeners.clone();
        }
        this.mVetoableListeners = null;
        if (property.mVetoableListeners != null) {
            this.mVetoableListeners = (ArrayList)property.mVetoableListeners.clone();
        }
        this.mTrimStrings = property.mTrimStrings;
        this.mPrintable = property.mPrintable;
        this.mSources = new HashMap();
        Iterator<PropertySource<T>> it = property.mSources.values().iterator();
        while (it.hasNext()) {
            try {
                this.addSources((PropertySource)it.next().clone());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("error constructing property", e);
            }
        }
        this.mUserData = property.mUserData;
        this.mType = property.mType;
    }

    public Property(Object id) {
        this(id, null);
    }

    public Property(Object id, T defaultValue) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.mId = id.toString();
        this.mValue = defaultValue;
        this.mIsSet = false;
        this.mMaster = null;
        this.mTrimStrings = false;
        this.mPrintable = true;
        this.mSources = new HashMap();
        this.mListeners = null;
        this.mVetoableListeners = null;
        this.mUserData = null;
        if (defaultValue != null) {
            this.setDefaultValue(defaultValue);
            this.mMaster = this.calculateNewMaster();
        }
        this.mType = null;
    }

    public Property(Object id, PropertySource<T> ... sources) {
        this(id, null);
        if (sources != null) {
            this.addSources(sources);
        }
    }

    public Property(Object id, T defaultValue, PropertySource<T> ... sources) {
        this(id, defaultValue);
        if (sources != null) {
            this.addSources(sources);
        }
    }

    public Property(Object id, T defaultValue, boolean trimStrings, PropertySource<T> ... sources) {
        this(id, defaultValue);
        this.mTrimStrings = trimStrings;
        if (sources != null) {
            this.addSources(sources);
        }
    }

    public String getId() {
        return this.mId;
    }

    public T getDefaultValue() {
        PropertySource<T> source = this.mSources.get(DEFAULT_SOURCE);
        if (source != null) {
            return source.getValue();
        }
        return null;
    }

    public void setDefaultValue(T value) {
        PropertySource<T> source = this.mSources.get(DEFAULT_SOURCE);
        if (source == null) {
            source = new PropertySource(DEFAULT_SOURCE, Integer.MAX_VALUE, false);
            this.mSources.put(DEFAULT_SOURCE, source);
        }
        try {
            source.setValue(value);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void setTrimStrings(boolean trimStrings) {
        this.mTrimStrings = trimStrings;
    }

    public boolean getTrimStrings() {
        return this.mTrimStrings;
    }

    public void setPrintable(boolean printable) {
        this.mPrintable = printable;
    }

    public boolean isPrintable() {
        return this.mPrintable;
    }

    public void addListener(PropertyChangeListener<T> listener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        this.mListeners.add(listener);
    }

    public void removeListener(PropertyChangeListener<T> listener) {
        if (this.mListeners != null) {
            this.mListeners.remove(listener);
        }
    }

    public void addVetoableListener(VetoablePropertySourceChangeListener<T> listener) {
        if (this.mVetoableListeners == null) {
            this.mVetoableListeners = new ArrayList();
        }
        this.mVetoableListeners.add(listener);
    }

    public void removeVetoableListener(VetoablePropertySourceChangeListener<T> listener) {
        if (this.mVetoableListeners != null) {
            this.mVetoableListeners.remove(listener);
        }
    }

    public void addSource(PropertySource<T> source) {
        for (PropertySource<T> aSource : this.mSources.values()) {
            if (aSource.getPriority() != source.getPriority()) continue;
            throw new IllegalArgumentException("Duplicate Source Priority");
        }
        this.mSources.put(source.getName(), source);
        source.setTrimStrings(this.mTrimStrings);
        source.setPrintable(this.mPrintable);
        source.addListener(this);
        source.addVetoableListener(this);
        if (source.isSet()) {
            this.update();
        }
    }

    public void addSources(PropertySource<T> ... sources) {
        for (int i = 0; i < sources.length; ++i) {
            this.addSource(sources[i]);
        }
    }

    public void addAllSources(Collection<PropertySource<T>> sources) {
        Iterator<PropertySource<T>> it = sources.iterator();
        while (it.hasNext()) {
            this.addSource(it.next());
        }
    }

    public void initialize() throws PropertyVetoException, PropertyConversionException {
        if (this.mSources == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)String.format("mSources is null in initialize() for Property \"%s\"", this.mId));
            }
            return;
        }
        if (this.mSources.size() == 0) {
            if (log.isErrorEnabled()) {
                log.error((Object)String.format("mSources.size() is == to 0 in initialize() for Property \"%s\"", this.mId));
            }
            return;
        }
        Iterator<PropertySource<T>> it = this.mSources.values().iterator();
        while (it.hasNext()) {
            PropertySource<T> aSource = null;
            try {
                aSource = it.next();
                aSource.initialize();
            }
            catch (Exception ex) {
                if (ex.getMessage().contains("corbaloc:")) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("Failed to initialize PropertySource \"%s\" for Property \"%s\" - %s", aSource.getName(), this.mId, ex.getMessage()));
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Failed to initialize PropertySource \"%s\" for Property \"%s\" - %s", aSource.getName(), this.mId, ex.getMessage()));
            }
        }
    }

    public Collection<PropertySource<T>> getSources() {
        return this.mSources.values();
    }

    public Collection<String> getSourceNames() {
        return this.mSources.keySet();
    }

    public PropertySource<T> getSource(String name) {
        return this.mSources.get(name);
    }

    public HashMap<String, Object> getUserDataMap() {
        if (this.mUserData == null) {
            this.mUserData = new HashMap();
        }
        return this.mUserData;
    }

    public void setUserDataMap(HashMap<String, Object> map) {
        this.mUserData = map;
    }

    public T getSourceValue(String name) {
        PropertySource<T> source = this.mSources.get(name);
        if (source == null) {
            throw new IllegalArgumentException("Source " + name + " does not exist");
        }
        return source.getValue();
    }

    public void setSourceValue(String name, T value) throws PropertyVetoException {
        PropertySource<T> source = this.mSources.get(name);
        if (source == null) {
            throw new IllegalArgumentException("Source " + name + " does not exist");
        }
        source.setValue(value);
    }

    public HashMap<String, Object> getSourceUserDataMap(String name) {
        PropertySource<T> source = this.mSources.get(name);
        if (source == null) {
            throw new IllegalArgumentException("Source " + name + " does not exist");
        }
        return source.getUserDataMap();
    }

    public void setSourceUserDataMap(String name, HashMap<String, Object> map) {
        PropertySource<T> source = this.mSources.get(name);
        if (source == null) {
            throw new IllegalArgumentException("Source " + name + " does not exist");
        }
        source.setUserDataMap(map);
    }

    public boolean isSet() {
        return this.mIsSet;
    }

    public T getValue() {
        return this.mValue;
    }

    public PropertySource<T> getMaster() {
        return this.mMaster;
    }

    public void setValue(T value) throws PropertyVetoException, PropertyConversionException {
        PropertySource<T> source = this.getSingleSourced();
        source.setValue(value);
    }

    public void setObjectValue(Object value) throws PropertyConversionException, PropertyVetoException {
        PropertySource<T> source = this.getSingleSourced();
        source.setObjectValue(value);
    }

    @Override
    public void propertySourceChanged(PropertySourceChangeEvent<T> event) {
        this.update();
    }

    @Override
    public void vetoablePropertySourceChanged(PropertySourceChangeEvent<T> event) throws PropertyVetoException {
        this.notifyVetoableListeners(event);
    }

    public void setType(Class<?> type) {
        this.mType = type;
    }

    public Class<?> getParameterizedClass() {
        if (this.mType != null) {
            return this.mType;
        }
        if (this.mValue != null) {
            return this.mValue.getClass();
        }
        if (this.getDefaultValue() != null) {
            return this.getDefaultValue().getClass();
        }
        for (PropertySource<T> source : this.mSources.values()) {
            PropertyConverter conv = source.getConverter();
            if (!(conv instanceof ValueOfConverter)) continue;
            return ((ValueOfConverter)conv).getDestinationClass();
        }
        return Object.class;
    }

    public Object clone() throws CloneNotSupportedException {
        return new Property<T>(this);
    }

    public String toKeyValueString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append(this.mId);
        bldr.append("=");
        if (this.mPrintable) {
            bldr.append(Property.toValueString(this.mValue));
        } else if (this.mIsSet) {
            bldr.append(NON_PRINTABLE_VALUE_STRING);
        }
        return bldr.toString();
    }

    private static String toValueString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        if (value.getClass().isArray()) {
            Object[] a = (Object[])value;
            StringBuilder bldr = new StringBuilder();
            bldr.append("[");
            for (int i = 0; i < a.length; ++i) {
                if (i > 0) {
                    bldr.append(",");
                }
                bldr.append(Property.toValueString(a[i]));
            }
            bldr.append("]");
            return bldr.toString();
        }
        return value.toString();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean inclID) {
        StringBuilder bldr = new StringBuilder();
        if (inclID) {
            bldr.append("id=\"");
            bldr.append(this.mId);
            bldr.append("\", value=");
        } else {
            bldr.append("value=");
        }
        if (this.mPrintable) {
            if (this.mValue instanceof String) {
                bldr.append("\"");
                bldr.append(this.mValue);
                bldr.append("\"");
            } else {
                bldr.append(this.mValue);
            }
        } else if (this.mIsSet) {
            bldr.append(NON_PRINTABLE_VALUE_STRING);
        }
        bldr.append(", isSet=");
        bldr.append(this.mIsSet);
        bldr.append(", trimStrings=");
        bldr.append(this.mTrimStrings);
        PropertySource<T> master = this.getMaster();
        if (master == null) {
            bldr.append(", master=none, ");
        } else {
            bldr.append(", master=\"");
            bldr.append(master.getName());
            bldr.append("\", ");
        }
        if (this.mSources.size() == 0) {
            bldr.append("sources=none\r\n");
        } else {
            bldr.append("sources={\r\n");
            TreeSet<PropertySource<T>> sourceSet = new TreeSet<PropertySource<T>>(new Comparator<PropertySource<T>>(){

                @Override
                public int compare(PropertySource<T> o1, PropertySource<T> o2) {
                    return o1.getPriority() - o2.getPriority();
                }
            });
            sourceSet.addAll(this.mSources.values());
            Iterator it = sourceSet.iterator();
            while (it.hasNext()) {
                bldr.append("\t");
                bldr.append(it.next());
                bldr.append("\r\n");
            }
            bldr.append("}\r\n");
        }
        return bldr.toString();
    }

    public static String mapToString(Map<String, Property<?>> propertyMap) {
        StringBuilder bldr = new StringBuilder();
        if (propertyMap == null) {
            bldr.append("null");
        } else {
            for (Property<?> prop : propertyMap.values()) {
                bldr.append(String.format("%s - %s\r\n", prop.getId(), prop.toString(false)));
            }
        }
        return bldr.toString();
    }

    protected PropertySource<T> getSingleSourced() {
        PropertySource<T> source = this.getSource(ANONYMOUS_SOURCE);
        PropertySource<T> defaultSource = this.getSource(DEFAULT_SOURCE);
        if (source == null) {
            if (defaultSource == null && this.mSources.size() > 0 || defaultSource != null && this.mSources.size() != 1) {
                throw new IllegalStateException("This method to be used with a single sourced property only");
            }
            source = new PropertySource(ANONYMOUS_SOURCE);
            this.addSources(source);
        } else if (defaultSource == null && this.mSources.size() > 1 || defaultSource != null && this.mSources.size() != 2) {
            throw new IllegalStateException("This method to be used with a single sourced property only");
        }
        return source;
    }

    protected PropertySource<T> calculateNewMaster() {
        PropertySource<T> master = null;
        Iterator<String> it = this.mSources.keySet().iterator();
        while (it.hasNext()) {
            PropertySource<T> source = this.mSources.get(it.next());
            if (!source.isSet()) continue;
            if (master == null) {
                master = source;
                continue;
            }
            if (master.getPriority() <= source.getPriority()) continue;
            master = source;
        }
        return master;
    }

    protected void update() {
        PropertySource<T> master = this.calculateNewMaster();
        if (this.hasChanged(master)) {
            if (master == null) {
                PropertyChangeEvent<Object> event = new PropertyChangeEvent<Object>(this, this.mIsSet, false, this.mValue, null, (PropertySource<Object>)this.mMaster, (PropertySource<Object>)master);
                this.mIsSet = false;
                this.mValue = null;
                this.mMaster = master;
                this.notifyListeners(event);
            } else if (master.getName() == DEFAULT_SOURCE) {
                PropertyChangeEvent<T> event = new PropertyChangeEvent<T>(this, this.mIsSet, false, this.mValue, master.getValue(), this.mMaster, master);
                this.mIsSet = false;
                this.mValue = master.getValue();
                this.mMaster = master;
                this.notifyListeners(event);
            } else {
                PropertyChangeEvent<T> event = new PropertyChangeEvent<T>(this, this.mIsSet, master.isSet(), this.mValue, master.getValue(), this.mMaster, master);
                this.mIsSet = master.isSet();
                this.mValue = master.getValue();
                this.mMaster = master;
                this.notifyListeners(event);
            }
        }
    }

    protected boolean hasChanged(PropertySource<T> source) {
        boolean newIsSet = false;
        Object newValue = null;
        if (source != null) {
            if (this.mMaster == null) {
                return true;
            }
            if (!source.getName().equals(this.mMaster.getName())) {
                return true;
            }
            newIsSet = source.isSet();
            newValue = source.getValue();
        } else if (this.mMaster != null) {
            return true;
        }
        if (this.mIsSet != newIsSet) {
            return true;
        }
        if (!this.mIsSet) {
            return false;
        }
        if (this.mValue == null) {
            return newValue != null;
        }
        if (newValue == null) {
            return true;
        }
        return !this.mValue.equals(newValue);
    }

    protected void notifyListeners(PropertyChangeEvent<T> event) {
        if (this.mListeners == null || this.mListeners.size() == 0) {
            return;
        }
        for (int i = 0; i < this.mListeners.size(); ++i) {
            this.mListeners.get(i).propertyChanged(event);
        }
    }

    protected void notifyVetoableListeners(PropertySourceChangeEvent<T> event) throws PropertyVetoException {
        if (this.mVetoableListeners == null || this.mVetoableListeners.size() == 0) {
            return;
        }
        event.setProperty(this);
        for (int i = 0; i < this.mVetoableListeners.size(); ++i) {
            this.mVetoableListeners.get(i).vetoablePropertySourceChanged(event);
        }
    }
}

