/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jms.SolConnectionIF;
import com.solacesystems.jms.SolQueueReceiver;
import com.solacesystems.jms.SolQueueSender;
import com.solacesystems.jms.SolSession;
import com.solacesystems.jms.SolSessionIF;
import com.solacesystems.jms.SolTemporaryQueue;
import com.solacesystems.jms.impl.JMSState;
import com.solacesystems.jms.impl.SolJMSErrorMessages;
import com.solacesystems.jms.impl.Validator;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;

public class SolQueueSession
extends SolSession
implements QueueSession {
    private final LogWrapper log = new LogWrapper(SolQueueSession.class);
    private static final String Component = "QueueSession";

    public SolQueueSession(SolConnectionIF connection, boolean transacted, int acknowledgeMode, JMSState state) throws JMSException {
        super(connection, transacted, acknowledgeMode, state);
        this.log.setContextInfo(this.getLogContextInfo());
        if (this.log.isDebugEnabled()) {
            this.log.debug("SolQueueSession created.");
        }
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return this.createReceiver(queue, null);
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering createReceiver");
        }
        Validator.checkClosed(this.mState, Component);
        Validator.checkConsumerDestination((Destination)queue, this.mConnection);
        SolQueueReceiver rcvr = new SolQueueReceiver(this, queue, messageSelector, false, this.mState);
        this.mConsumers.add(rcvr);
        if (queue instanceof SolTemporaryQueue) {
            SolTemporaryQueue tempQueue = (SolTemporaryQueue)queue;
            tempQueue.addConsumer(rcvr);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving createReceiver");
        }
        return rcvr;
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering createSender");
        }
        Validator.checkClosed(this.mState, Component);
        Validator.checkProducerDestination(this.mSessionProps.getConnectionProperties().getRouterCapabilities().crMode(), (Destination)queue);
        SolQueueSender sender = new SolQueueSender((SolSessionIF)this, queue);
        this.mProducers.add(sender);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving createSender");
        }
        return sender;
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        throw new IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.consumer.create", "soljms.error.illegalstate", "createDurableSubscriber()"), "soljms.error.illegalstate");
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        throw new IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.consumer.create", "soljms.error.illegalstate", "createDurableSubscriber()"), "soljms.error.illegalstate");
    }

    @Override
    public TemporaryTopic createTemporaryTopic() throws JMSException {
        throw new IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.topic.create", "soljms.error.illegalstate", "createTemporaryTopic()"), "soljms.error.illegalstate");
    }

    @Override
    public Topic createTopic(String topicName) throws JMSException {
        throw new IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.topic.create", "soljms.error.illegalstate", "createTopic()"), "soljms.error.illegalstate");
    }

    @Override
    public void unsubscribe(String name) throws JMSException {
        throw new IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.unsubscribe", "soljms.error.illegalstate", "unsubscribe()"), "soljms.error.illegalstate");
    }
}

