/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.interceptors.impl;

import com.solacesystems.common.SolReserved;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.XMLContentMessage;
import com.solacesystems.jcsmp.interceptors.JCSMPMessageConsumerInterceptor;
import com.solacesystems.jms.SolDestination;
import com.solacesystems.jms.encoding.DefaultJMSEncoder;
import com.solacesystems.jms.encoding.JMSDecoder;
import com.solacesystems.jms.interceptors.MessageReceiverInterceptor;
import com.solacesystems.jms.interceptors.impl.SolReceiverInterceptingContextImpl;
import com.solacesystems.jms.message.SolBytesMessage;
import com.solacesystems.jms.message.SolMapMessage;
import com.solacesystems.jms.message.SolMessage;
import com.solacesystems.jms.message.SolObjectMessage;
import com.solacesystems.jms.message.SolStreamMessage;
import com.solacesystems.jms.message.SolTextMessage;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.annotation.versioning.ProviderType;

@SolReserved
@ProviderType
public class SolJCSMPMessageConsumerInterceptor
implements JCSMPMessageConsumerInterceptor {
    private MessageReceiverInterceptor interceptor = null;
    private static final Log log = LogFactory.getLog(SolJCSMPMessageConsumerInterceptor.class);

    public SolJCSMPMessageConsumerInterceptor(String class_name) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Loading consumer interceptor class: " + class_name));
        }
        this.interceptor = (MessageReceiverInterceptor)Class.forName(class_name).newInstance();
    }

    @Override
    public void onPreReceive(JCSMPMessageConsumerInterceptor.ReceiverInterceptingContext interceptingContext) throws JCSMPException {
        BytesXMLMessage jcsmpMsg = interceptingContext.getMessage();
        try {
            SolMessage solMsg;
            block21: {
                solMsg = JMSDecoder.createJMSMessage(jcsmpMsg);
                try {
                    solMsg.getProperties();
                    if (solMsg instanceof SolMapMessage) {
                        ((SolMapMessage)solMsg).getMap();
                    } else if (solMsg instanceof SolStreamMessage) {
                        ((SolStreamMessage)solMsg).getStream();
                    } else if (solMsg instanceof XMLContentMessage) {
                        ((XMLContentMessage)((Object)solMsg)).getXMLContent();
                    } else if (solMsg instanceof SolTextMessage) {
                        ((SolTextMessage)solMsg).getText();
                    } else if (solMsg instanceof SolBytesMessage) {
                        ((SolBytesMessage)solMsg).readInt();
                    } else if (solMsg instanceof SolObjectMessage) {
                        ((SolObjectMessage)solMsg).getSerializedObject();
                    }
                }
                catch (JMSException e) {
                    if (!log.isDebugEnabled()) break block21;
                    log.debug((Object)"got exception on loading properties or payload: ", (Throwable)e);
                }
            }
            solMsg.clearPropertyReadOnlyFlag();
            SolReceiverInterceptingContextImpl jmsInterceptorConext = new SolReceiverInterceptingContextImpl(solMsg);
            this.interceptor.onPreReceive(jmsInterceptorConext);
            String corid = solMsg.getJMSCorrelationID();
            Destination replyTo = solMsg.getJMSReplyTo();
            long timeStamp = solMsg.getJMSTimestamp();
            String msgId = solMsg.getJMSMessageID();
            long expired = solMsg.getJMSExpiration();
            String msgType = solMsg.getJMSType();
            DefaultJMSEncoder.getInstance().encodeExistingJCSMPMessage(solMsg);
            if (replyTo != null) {
                jcsmpMsg.setReplyTo(((SolDestination)replyTo).getJCSMPDestination());
            }
            if (msgType != null) {
                jcsmpMsg.setAppMessageType(msgType);
            }
            if (msgId != null) {
                jcsmpMsg.setAppMessageID(msgId);
            }
            if (timeStamp > 0L) {
                jcsmpMsg.setSendTimestamp(timeStamp);
            }
            if (corid != null) {
                jcsmpMsg.setCorrelationId(corid);
            }
            if (expired > 0L) {
                jcsmpMsg.setExpiration(expired);
            }
        }
        catch (JMSException e) {
            throw new JCSMPException("got an interceptor exception", e);
        }
    }
}

