/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jms.SolConnectionIF;
import com.solacesystems.jms.SolSession;
import com.solacesystems.jms.SolSessionIF;
import com.solacesystems.jms.SolTopicPublisher;
import com.solacesystems.jms.impl.JMSState;
import com.solacesystems.jms.impl.SolJMSErrorMessages;
import com.solacesystems.jms.impl.Validator;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;

public class SolTopicSession
extends SolSession
implements TopicSession {
    private final LogWrapper log = new LogWrapper(SolTopicSession.class);
    private static final String Component = "TopicSession";

    public SolTopicSession(SolConnectionIF connection, boolean transacted, int acknowledgeMode, JMSState state) throws JMSException {
        super(connection, transacted, acknowledgeMode, state);
        this.log.setContextInfo(this.getLogContextInfo());
        if (this.log.isDebugEnabled()) {
            this.log.debug("SolTopicSession created. Transacted: " + transacted + "  acknowledgeMode: " + acknowledgeMode + " State: " + (Object)((Object)state));
        }
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering createPublisher.  Topic: " + (topic == null ? "null" : topic.getTopicName()));
        }
        Validator.checkClosed(this.mState, Component);
        Validator.checkProducerDestination(this.mSessionProps.getConnectionProperties().getRouterCapabilities().crMode(), (Destination)topic);
        SolTopicPublisher publisher = new SolTopicPublisher((SolSessionIF)this, topic);
        this.mProducers.add(publisher);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving createPublisher");
        }
        return publisher;
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return (TopicSubscriber)super.createConsumer((Destination)topic);
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        return (TopicSubscriber)super.createConsumer((Destination)topic, messageSelector, noLocal);
    }

    @Override
    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        throw new IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.queue.browser", "soljms.error.illegalstate", "createBrowser()"), "soljms.error.illegalstate");
    }

    @Override
    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        throw new IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.queue.browser", "soljms.error.illegalstate", "createBrowser()"), "soljms.error.illegalstate");
    }

    @Override
    public Queue createQueue(String queueName) throws JMSException {
        throw new IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.queue.create", "soljms.error.illegalstate", "createQueue()"), "soljms.error.illegalstate");
    }

    @Override
    public TemporaryQueue createTemporaryQueue() throws JMSException {
        throw new IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.queue.create", "soljms.error.illegalstate", "createTemporaryQueue()"), "soljms.error.illegalstate");
    }
}

