/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jms.SolTopicConnection;
import com.solacesystems.jms.SolXASession;
import com.solacesystems.jms.SolXATopicSession;
import com.solacesystems.jms.impl.SessionTransactionType;
import com.solacesystems.jms.impl.Validator;
import com.solacesystems.jms.property.JMSProperties;
import jakarta.jms.JMSException;
import jakarta.jms.XASession;
import jakarta.jms.XATopicConnection;
import jakarta.jms.XATopicSession;

public class SolXATopicConnection
extends SolTopicConnection
implements XATopicConnection {
    private final LogWrapper log = new LogWrapper(SolXATopicConnection.class);

    public SolXATopicConnection(JMSProperties properties) throws JMSException {
        super(properties, true);
        this.log.setContextInfo(this.getLogContextInfo());
    }

    public SolXATopicConnection(JMSProperties properties, String userName, String password) throws JMSException {
        super(properties, true, userName, password);
        this.log.setContextInfo(this.getLogContextInfo());
    }

    public XASession createXASession() throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering createXASession()");
        }
        this.checkClosed();
        Validator.checkTransactedAndAckMode(SessionTransactionType.XATransaction, 0, this.mConnectionProps.getPropertyBean().getDirectTransport());
        Validator.checkTransactedAndLargeMessaging(SessionTransactionType.XATransaction, this.mJCSMPProperties.getBooleanProperty("large_messaging"));
        this.mHasBeenAccessed = true;
        SolXASession newSession = new SolXASession(this, this.mState);
        this.mSessions.add(newSession);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving createXASession()");
        }
        return newSession;
    }

    public XATopicSession createXATopicSession() throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering createXATopicSession()");
        }
        Validator.checkTransactedAndLargeMessaging(SessionTransactionType.XATransaction, this.mJCSMPProperties.getBooleanProperty("large_messaging"));
        this.checkClosed();
        Validator.checkTransactedAndAckMode(SessionTransactionType.XATransaction, 0, this.mConnectionProps.getPropertyBean().getDirectTransport());
        this.mHasBeenAccessed = true;
        SolXATopicSession newSession = new SolXATopicSession(this, this.mState);
        this.mSessions.add(newSession);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving createXATopicSession()");
        }
        return newSession;
    }
}

