/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.impl;

import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jms.impl.AckHandler;
import com.solacesystems.jms.impl.SolJMSErrorMessages;
import com.solacesystems.jms.impl.UnackedList;
import com.solacesystems.jms.impl.Validator;
import com.solacesystems.jms.message.SolMessage;
import jakarta.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageAckHandlerImpl
implements AckHandler {
    private static final Log log = LogFactory.getLog(MessageAckHandlerImpl.class);
    private final int mAcknowledgeMode;
    private final UnackedList mUnackedlist;

    public MessageAckHandlerImpl(int ackMode) {
        this.mAcknowledgeMode = ackMode;
        this.mUnackedlist = ackMode == 2 ? new UnackedList() : null;
    }

    @Override
    public void onMessageCreate(SolMessage message) {
        if (this.mAcknowledgeMode == 2) {
            this.mUnackedlist.add(message);
        }
    }

    @Override
    public void onMessageSent(SolMessage message) throws JMSException {
        if (this.mAcknowledgeMode == 1 || this.mAcknowledgeMode == 3) {
            try {
                message.getMessage().ackMessage();
            }
            catch (IllegalStateException e) {
                if (e.getMessage().contains(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageConsumer.attemptOpOnClosed"))) {
                    log.warn((Object)SolJMSErrorMessages.getMessage("soljms.operation.ack", "soljms.error.ackonclosedmessageconsumer", null));
                }
                throw Validator.createJMSException("soljms.operation.ack", e);
            }
        }
    }

    @Override
    public void acknowledge(SolMessage message) throws JMSException {
        if (this.mAcknowledgeMode == 2) {
            this.mUnackedlist.acknowledge();
        } else if (this.mAcknowledgeMode == 4 || this.mAcknowledgeMode == 23) {
            try {
                message.getMessage().ackMessage();
            }
            catch (IllegalStateException e) {
                throw Validator.createJMSException("soljms.operation.ack", e);
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)SolJMSErrorMessages.getMessage("soljms.operation.ack", "soljms.error.autoackmode", null));
        }
    }

    @Override
    public void clearUnackedList() {
        if (this.mUnackedlist != null) {
            this.mUnackedlist.clear();
        }
    }
}

