/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.common.HostInfo;
import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jcsmp.Context;
import com.solacesystems.jcsmp.InvalidPropertiesException;
import com.solacesystems.jcsmp.JCSMPChannelProperties;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPFactory;
import com.solacesystems.jcsmp.JCSMPGlobalProperties;
import com.solacesystems.jcsmp.JCSMPIncompleteLargeMessageReceivedException;
import com.solacesystems.jcsmp.JCSMPProperties;
import com.solacesystems.jcsmp.JCSMPSession;
import com.solacesystems.jcsmp.Session;
import com.solacesystems.jcsmp.SessionEvent;
import com.solacesystems.jcsmp.SessionEventArgs;
import com.solacesystems.jcsmp.SessionEventHandler;
import com.solacesystems.jcsmp.XMLMessageConsumer;
import com.solacesystems.jcsmp.XMLMessageListener;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jms.ConfigurationException;
import com.solacesystems.jms.IncompleteLargeMessageException;
import com.solacesystems.jms.SolConnectionConsumer;
import com.solacesystems.jms.SolConnectionConsumerIF;
import com.solacesystems.jms.SolConnectionConsumerRA;
import com.solacesystems.jms.SolConnectionEventListener;
import com.solacesystems.jms.SolConnectionEventSource;
import com.solacesystems.jms.SolConnectionIF;
import com.solacesystems.jms.SolDestinationInfo;
import com.solacesystems.jms.SolSession;
import com.solacesystems.jms.SolSessionIF;
import com.solacesystems.jms.SolTemporaryQueueIF;
import com.solacesystems.jms.SolTemporaryTopicIF;
import com.solacesystems.jms.events.SolConnectionEvent;
import com.solacesystems.jms.events.SolReconnectedEvent;
import com.solacesystems.jms.events.SolReconnectingEvent;
import com.solacesystems.jms.impl.ConnectionProperties;
import com.solacesystems.jms.impl.JMSClientInfoProvider;
import com.solacesystems.jms.impl.JMSState;
import com.solacesystems.jms.impl.SessionTransactionType;
import com.solacesystems.jms.impl.SolCollections;
import com.solacesystems.jms.impl.SolConnectionMetaData;
import com.solacesystems.jms.impl.SolJMSErrorMessages;
import com.solacesystems.jms.impl.Validator;
import com.solacesystems.jms.interceptors.MessageProducerInterceptor;
import com.solacesystems.jms.interceptors.impl.SolJCSMPMessageConsumerInterceptor;
import com.solacesystems.jms.property.JMSAPIPropertyBean;
import com.solacesystems.jms.property.JMSProperties;
import com.solacesystems.jms.property.JMSPropertyBean;
import jakarta.jms.ConnectionConsumer;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import jakarta.jms.ServerSessionPool;
import jakarta.jms.Topic;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public class SolConnection
implements SolConnectionIF,
SolConnectionEventSource,
ExceptionListener,
SessionEventHandler {
    private final LogWrapper log;
    protected JMSProperties mProperties;
    protected JMSPropertyBean mBean;
    protected JMSAPIPropertyBean mAPIBean;
    protected JCSMPProperties mJCSMPProperties;
    protected ConnectionProperties mConnectionProps;
    protected volatile JMSState mState;
    protected ArrayList<SolSessionIF> mSessions;
    protected ArrayList<SolConnectionConsumerIF> mConnectionConsumers;
    protected volatile ExceptionListener mListener;
    protected ConnectionMetaData mConnectionMetaData;
    protected XMLMessageConsumer mDefaultConsumer;
    protected Object mDefaultConsumerLock;
    protected String mClientID;
    protected SolConnectionEventListener mConnectionEventListener;
    protected boolean mCFClientIDSet;
    protected boolean mProviderGeneratedClientID;
    protected boolean mHasBeenAccessed;
    private Class<MessageProducerInterceptor> producer_interceptor_class;

    SolConnection(JMSProperties properties, boolean connectionTypeXA) throws JMSException {
        this(properties, connectionTypeXA, null, null);
    }

    SolConnection(JMSProperties properties, boolean connectionTypeXA, String username, String password) throws JMSException {
        block26: {
            block25: {
                this.log = new LogWrapper(SolConnection.class);
                this.producer_interceptor_class = null;
                this.mProperties = (JMSProperties)properties.clone();
                this.mBean = new JMSPropertyBean(this.mProperties.getProperties().values());
                this.mAPIBean = new JMSAPIPropertyBean(this.mProperties.getProperties().values());
                if (username != null) {
                    try {
                        this.mAPIBean.setUsername(username);
                    }
                    catch (Exception e) {
                        if (!this.log.isErrorEnabled()) break block25;
                        this.log.error("Error setting username \"" + username + "\"");
                    }
                }
            }
            if (password != null) {
                try {
                    this.mAPIBean.setPassword(password);
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break block26;
                    this.log.error("Error setting password");
                }
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating connection.  Properties used for connection creation:\n\n" + this.mProperties);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Creating connection");
        }
        this.mState = JMSState.Stopped;
        this.mSessions = new ArrayList();
        this.mConnectionConsumers = new ArrayList();
        this.mListener = null;
        this.mConnectionMetaData = new SolConnectionMetaData();
        this.mDefaultConsumer = null;
        this.mDefaultConsumerLock = new Object();
        this.mClientID = this.mBean.getClientID();
        this.mCFClientIDSet = this.mClientID != null && this.mClientID.length() > 0;
        this.mProviderGeneratedClientID = this.mBean.getProviderGeneratedClientID();
        this.mHasBeenAccessed = false;
        Context context = null;
        Session session = null;
        if (this.mBean.isSetMessageProducerInterceptorClassName()) {
            try {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Loading producer interceptor class: " + this.mBean.getMessageProducerInterceptorClassName());
                }
                this.producer_interceptor_class = Class.forName(this.mBean.getMessageProducerInterceptorClassName());
            }
            catch (ClassNotFoundException e) {
                throw Validator.createJMSException("soljms.operation.connection.create", e);
            }
        }
        try {
            this.mJCSMPProperties = SolConnection.toJCSMPProperties(this.mBean, connectionTypeXA);
            boolean allowDupClientId = this.mBean.getAllowDuplicateClientId();
            try {
                if (this.mBean.getUseDefaultContext().booleanValue()) {
                    session = JCSMPFactory.onlyInstance().createSession(this.mJCSMPProperties, null, this, allowDupClientId);
                } else {
                    context = JCSMPFactory.onlyInstance().createContext(null);
                    session = JCSMPFactory.onlyInstance().createSession(this.mJCSMPProperties, context, this, allowDupClientId);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw Validator.createJMSException("soljms.operation.connection.create", e);
            }
            session.connect();
            this.mConnectionProps = new ConnectionProperties(this.mProperties, context, (JCSMPSession)session, this);
            if (this.mConnectionProps.getRouterCapabilities().crMode() && this.mBean.getDirectTransport().booleanValue()) {
                throw new ConfigurationException("Content routing with the JNDI direct transport property set to true is not supported");
            }
        }
        catch (InvalidPropertiesException e) {
            if (context != null) {
                context.destroy();
            }
            throw new ConfigurationException(e.getMessage());
        }
        catch (JCSMPException e) {
            if (session != null) {
                session.closeSession();
            }
            if (context != null) {
                context.destroy();
            }
            throw Validator.createJMSException("soljms.operation.connection.create", e);
        }
        this.log.setContextInfo(this.getLogContextInfo());
        if (this.log.isDebugEnabled()) {
            this.log.debug("Connection created.");
        }
    }

    protected String getLogContextInfo() {
        if (this.mConnectionProps.getJCSMPSession() instanceof JCSMPBasicSession) {
            return ((JCSMPBasicSession)this.mConnectionProps.getJCSMPSession()).getLogContextInfo();
        }
        return "Client-" + this.mConnectionProps.getJCSMPSession().getSessionName();
    }

    @Override
    public JCSMPProperties getJCSMPProperties() {
        return this.mJCSMPProperties;
    }

    public JMSProperties getJMSProperties() {
        return this.mProperties;
    }

    @Override
    public MessageProducerInterceptor getMessageProducerInterceptorInstance() throws JMSException {
        if (this.producer_interceptor_class != null) {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Create a producer interceptor instance: " + this.mBean.getMessageProducerInterceptorClassName());
                }
                return this.producer_interceptor_class.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw Validator.createJMSException("soljms.operation.producer.create", e);
            }
        }
        return null;
    }

    public synchronized void close() throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Closing connection");
        }
        if (this.mState != JMSState.Closed) {
            this.mHasBeenAccessed = true;
            ArrayList<SolConnectionConsumerIF> ccToClose = new ArrayList<SolConnectionConsumerIF>(this.mConnectionConsumers);
            SolCollections.stopAll(ccToClose);
            SolCollections.closeAll(new ArrayList<SolSessionIF>(this.mSessions));
            this.mSessions.clear();
            SolCollections.closeAll(ccToClose);
            this.mConnectionConsumers.clear();
            if (!this.mConnectionProps.getJCSMPSession().isClosed()) {
                this.mConnectionProps.getJCSMPSession().closeSession();
            }
            if (this.mConnectionProps.getContext() != null) {
                this.mConnectionProps.getContext().destroy();
            }
            this.mState = JMSState.Closed;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Connection closed");
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Connection already closed");
        }
    }

    public synchronized ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering createConnectionConsumer()");
        }
        this.checkClosed();
        Validator.checkConsumerDestination(destination, this);
        SolDestinationInfo destInfo = new SolDestinationInfo();
        destInfo.destination = destination;
        destInfo.subscriptionName = null;
        SolConnectionConsumerIF connCons = null;
        Boolean useLegacy = this.mBean.getUseLegacyConnectionConsumer();
        connCons = useLegacy != null && useLegacy != false ? new SolConnectionConsumer(this, destInfo, messageSelector, sessionPool, maxMessages, this.mState) : new SolConnectionConsumerRA(this, destInfo, messageSelector, sessionPool, maxMessages, this.mState);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving createConnectionConsumer()");
        }
        return connCons;
    }

    public synchronized ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering createDurableConnectionConsumer()");
        }
        this.checkClosed();
        Validator.checkConsumerTopicDestination((Destination)topic, this, true);
        Validator.checkSubscriptionName(subscriptionName);
        SolDestinationInfo destInfo = new SolDestinationInfo();
        destInfo.destination = topic;
        destInfo.subscriptionName = subscriptionName;
        SolConnectionConsumerIF connCons = null;
        Boolean useLegacy = this.mBean.getUseLegacyConnectionConsumer();
        connCons = useLegacy != null && useLegacy != false ? new SolConnectionConsumer(this, destInfo, messageSelector, sessionPool, maxMessages, this.mState) : new SolConnectionConsumerRA(this, destInfo, messageSelector, sessionPool, maxMessages, this.mState);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving createDurableConnectionConsumer()");
        }
        return connCons;
    }

    public synchronized jakarta.jms.Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering createSession()");
        }
        this.checkClosed();
        Validator.checkTransactedAndAckMode(transacted ? SessionTransactionType.LocalTransaction : SessionTransactionType.NoTransaction, acknowledgeMode, this.mConnectionProps.getPropertyBean().getDirectTransport());
        this.mHasBeenAccessed = true;
        SolSession newSession = new SolSession(this, transacted, acknowledgeMode, this.mState);
        this.mSessions.add(newSession);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving createSession()");
        }
        return newSession;
    }

    public synchronized String getClientID() throws JMSException {
        this.checkClosed();
        if (this.mProviderGeneratedClientID) {
            return (String)this.mConnectionProps.getJCSMPSession().getProperty("client_name");
        }
        return this.mClientID;
    }

    public synchronized String getClientName() throws JMSException {
        this.checkClosed();
        return (String)this.mConnectionProps.getJCSMPSession().getProperty("client_name");
    }

    public synchronized ExceptionListener getExceptionListener() throws JMSException {
        this.checkClosed();
        return this.mListener;
    }

    public synchronized ConnectionMetaData getMetaData() throws JMSException {
        this.checkClosed();
        return this.mConnectionMetaData;
    }

    public synchronized void setClientID(String clientID) throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering setClientID(), clientId: " + clientID);
        }
        this.checkClosed();
        Validator.checkClientId(this.mBean.getJNDIClientID(), clientID);
        if (this.mCFClientIDSet) {
            throw new jakarta.jms.IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.clientid.set", "soljms.error.clientid.adminstrativelyConfigured", null), "soljms.error.clientid.adminstrativelyConfigured");
        }
        if (this.mHasBeenAccessed) {
            throw new jakarta.jms.IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.clientid.set", "soljms.error.clientid.notsettable", null), "soljms.error.clientid.notsettable");
        }
        try {
            String generatedClientId = clientID;
            if (clientID != null && !"".equals(clientID) && this.mBean.getAllowDuplicateClientId().booleanValue()) {
                this.mConnectionProps.getJCSMPSession().setJmsClientId(clientID, this.mBean.getAllowDuplicateClientId());
                this.mProviderGeneratedClientID = false;
                generatedClientId = (String)this.mConnectionProps.getJCSMPSession().getProperty("client_name");
            }
            this.mConnectionProps.getJCSMPSession().setProperty("client_name", generatedClientId);
            this.mJCSMPProperties.setProperty("client_name", clientID);
            this.mAPIBean.setClientID(clientID);
            this.mClientID = clientID;
        }
        catch (Exception e) {
            throw Validator.createJMSException("soljms.operation.clientid.set", e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving setClientID()");
        }
    }

    public synchronized void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.checkClosed();
        this.mListener = listener;
    }

    public synchronized void start() throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering start()");
        }
        this.checkClosed();
        if (this.mState == JMSState.Stopped) {
            this.mHasBeenAccessed = true;
            SolCollections.startAll(this.mSessions);
            SolCollections.startAll(this.mConnectionConsumers);
            this.mState = JMSState.Started;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Leaving start() : Connection started.");
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving start() : Connection already started");
        }
    }

    public synchronized void stop() throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering stop()");
        }
        this.checkClosed();
        if (this.mState == JMSState.Started) {
            this.mHasBeenAccessed = true;
            SolCollections.stopAll(this.mSessions);
            SolCollections.stopAll(this.mConnectionConsumers);
            this.mState = JMSState.Stopped;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Leaving stop() : Connection stopped.");
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving stop() : Connection already stopped");
        }
    }

    @Override
    public synchronized void remove(SolSessionIF session) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering remove(), session being removed: " + session);
        }
        for (int index = this.mSessions.size() - 1; index >= 0; --index) {
            if (this.mSessions.get(index) != session) continue;
            this.mSessions.remove(index);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Leaving remove() : session removed.");
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving remove(), session to be removed not found.");
        }
    }

    public synchronized void removeConnectionConsumer(SolConnectionConsumerIF cons) {
        this.mConnectionConsumers.remove(cons);
    }

    public synchronized void addConnectionConsumer(SolConnectionConsumerIF cons) {
        this.mConnectionConsumers.add(cons);
    }

    @Override
    public synchronized void deleteTemporaryQueue(SolTemporaryQueueIF queue) throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering deleteTemporaryQueue.  Queue: " + queue.getQueueName());
        }
        Validator.checkDeleteTempDestination((Destination)queue, this);
        if (this.mState != JMSState.Closed) {
            for (int i = 0; i < this.mSessions.size(); ++i) {
                if (!this.mSessions.get(i).isTemporaryQueueUsed(queue)) continue;
                throw new jakarta.jms.IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.temp.destination.delete", "soljms.error.tempdestination.inuse", null), "soljms.error.tempdestination.inuse");
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving deleteTemporaryQueue");
        }
    }

    @Override
    public synchronized void deleteTemporaryTopic(SolTemporaryTopicIF topic) throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering deleteTemporaryTopic.  Topic : " + topic.getTopicName());
        }
        Validator.checkDeleteTempDestination((Destination)topic, this);
        if (this.mState != JMSState.Closed) {
            for (int i = 0; i < this.mSessions.size(); ++i) {
                if (!this.mSessions.get(i).isTemporaryTopicUsed(topic)) continue;
                throw new jakarta.jms.IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.temp.destination.delete", "soljms.error.tempdestination.inuse", null), "soljms.error.tempdestination.inuse");
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving deleteTemporaryTopic");
        }
    }

    @Override
    public ConnectionProperties getProperties() {
        return this.mConnectionProps;
    }

    @Override
    public void handleEvent(SessionEventArgs event) {
        JMSException jmsEx;
        Exception jcsmpEx;
        if (event.getEvent() == SessionEvent.INCOMPLETE_LARGE_MESSAGE_RECVD) {
            JCSMPIncompleteLargeMessageReceivedException jEx = (JCSMPIncompleteLargeMessageReceivedException)event.getException();
            IncompleteLargeMessageException ex = new IncompleteLargeMessageException(event.getInfo());
            ex.setSignalMsgDump(jEx.getSignalMsgDump());
            ex.setSignalMsgPhysicalQueueName(jEx.getSignalMsgQueueName());
            ex.setSignalMsgSelector(jEx.getSignalMsgSelector());
            ex.setSegmentMsgPhsicalQueueName(jEx.getSegmentMsgQueueName());
            ex.setSegmentMsgSelector(jEx.getSegmentMsgSelector());
            this.onException(ex);
        }
        if ((jcsmpEx = event.getException()) != null && jcsmpEx instanceof JCSMPErrorResponseException && ((JCSMPErrorResponseException)jcsmpEx).getSubcodeEx() == 64) {
            jmsEx = new JMSException(jcsmpEx.getMessage(), "soljms.error.unknowntransactedsessionname");
            this.onException(jmsEx);
        }
        if (event.getEvent().equals((Object)SessionEvent.DOWN_ERROR)) {
            jmsEx = new JMSException(jcsmpEx == null ? "" : jcsmpEx.getMessage());
            this.onException(jmsEx);
        }
        if (this.mConnectionEventListener != null) {
            SolConnectionEvent solEvent = null;
            if (event.getEvent().equals((Object)SessionEvent.RECONNECTING)) {
                JMSException exception = Validator.createJMSException(null, event.getException());
                solEvent = new SolReconnectingEvent(exception);
            } else if (event.getEvent().equals((Object)SessionEvent.RECONNECTED)) {
                solEvent = new SolReconnectedEvent();
            }
            if (solEvent != null) {
                try {
                    this.mConnectionEventListener.onEvent(solEvent);
                }
                catch (Throwable t) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn("Exception occurred in connection event listener", t);
                    }
                }
            } else if (this.log.isInfoEnabled()) {
                this.log.info("Event is not a connection event - cannot notify SolConnectionEventListener");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDefaultSubscriber() throws JCSMPException {
        Object object = this.mDefaultConsumerLock;
        synchronized (object) {
            if (this.mDefaultConsumer == null) {
                this.mDefaultConsumer = this.mConnectionProps.getJCSMPSession().getMessageConsumer((XMLMessageListener)null);
            }
        }
    }

    public void onException(JMSException exception) {
        block4: {
            ExceptionListener listener;
            if (this.log.isDebugEnabled()) {
                this.log.debug("onException called.  Exception: " + exception.toString());
            }
            if ((listener = this.mListener) != null) {
                try {
                    listener.onException(exception);
                }
                catch (Throwable t) {
                    if (!this.log.isErrorEnabled()) break block4;
                    this.log.error("Error handling async exception", t);
                }
            }
        }
    }

    protected void checkClosed() throws JMSException {
        if (this.mState == JMSState.Closed || this.mConnectionProps.getJCSMPSession().isClosed()) {
            if (this.mState != JMSState.Closed) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Connection closed because JCSMP session is closed.");
                }
                this.mState = JMSState.Closed;
            }
            throw new jakarta.jms.IllegalStateException("connection closed", "soljms.error.closed");
        }
    }

    public static JCSMPProperties toJCSMPProperties(JMSPropertyBean bean, boolean connectionTypeXA) {
        JCSMPProperties jcsmpProps = new JCSMPProperties();
        JCSMPChannelProperties ccProps = (JCSMPChannelProperties)jcsmpProps.getProperty("client_channel");
        if (!bean.isSetHost()) {
            throw new IllegalArgumentException("Host not specified");
        }
        if (!(bean.getAuthenticationScheme().equals("AUTHENTICATION_SCHEME_CLIENT_CERTIFICATE") || bean.getAuthenticationScheme().equals("AUTHENTICATION_SCHEME_GSS_KRB") || bean.getAuthenticationScheme().equals("AUTHENTICATION_SCHEME_OAUTH2") || bean.isSetUsername())) {
            throw new IllegalArgumentException("Username not specified");
        }
        String hostlist = bean.getHost();
        int port = bean.getPort();
        if (port != -1) {
            hostlist = SolConnection.buildHostlist(bean, port);
        }
        jcsmpProps.setProperty("host", hostlist);
        if (bean.getUsername() != null) {
            jcsmpProps.setProperty("username", bean.getUsername());
        }
        if (bean.isSetPassword()) {
            jcsmpProps.setProperty("password", bean.getPassword());
        }
        if (bean.isSetVPN()) {
            jcsmpProps.setProperty("vpn_name", bean.getVPN());
        }
        if (bean.isSetAuthenticationScheme()) {
            jcsmpProps.setProperty("AUTHENTICATION_SCHEME", bean.getAuthenticationScheme());
        }
        if (bean.isSetKRBMutualAuthentication()) {
            jcsmpProps.setBooleanProperty("KRB_MUTUAL_AUTHENTICATION", bean.getKRBMutualAuthentication());
        }
        if (bean.isSetKRBServiceName()) {
            jcsmpProps.setProperty("KRB_SERVICE_NAME", bean.getKRBServiceName());
        }
        if (connectionTypeXA) {
            jcsmpProps.setProperty("connection_type", "CONNECTION_TYPE_XA");
        } else {
            jcsmpProps.setProperty("connection_type", "CONNECTION_TYPE_BASIC");
        }
        jcsmpProps.setProperty("client_info_provider", new JMSClientInfoProvider());
        if (bean.isSetClientID() && bean.getClientID().length() > 0) {
            jcsmpProps.setProperty("client_name", bean.getClientID());
        }
        jcsmpProps.setProperty("application_description", bean.getClientDescription());
        jcsmpProps.setProperty("message_ack_mode", "client_ack");
        jcsmpProps.setBooleanProperty("topic_dispatch", bean.getDirectTransport());
        jcsmpProps.setProperty("MESSAGE_CALLBACK_ON_REACTOR", bean.getCallbackOnIOThread());
        jcsmpProps.setProperty("topic_dispatch_optimize_direct", bean.getDirectOptimized());
        jcsmpProps.setIntegerProperty("pub_ack_window_size", bean.getSendADWindowSize());
        jcsmpProps.setIntegerProperty("pub_ack_time", bean.getSendADAckTimerInMillis());
        jcsmpProps.setIntegerProperty("max_resends", bean.getSendADMaxResends());
        jcsmpProps.setIntegerProperty("sub_ack_window_size", bean.getReceiveADWindowSize());
        jcsmpProps.setIntegerProperty("sub_ack_time", bean.getReceiveADAckTimerInMillis());
        jcsmpProps.setIntegerProperty("sub_ack_window_threshold", bean.getReceiveADAckThreshold());
        jcsmpProps.setIntegerProperty("subscriber_local_priority", bean.getSubscriberLocalPriority());
        jcsmpProps.setIntegerProperty("subscriber_network_priority", bean.getSubscriberNetworkPriority());
        jcsmpProps.setBooleanProperty("generate_sender_id", bean.getGenerateSenderID());
        ccProps.setConnectTimeoutInMillis(bean.getConnectTimeoutInMillis());
        ccProps.setReadTimeoutInMillis(bean.getReadTimeoutInMillis());
        ccProps.setConnectRetries(bean.getConnectRetries());
        ccProps.setConnectRetriesPerHost(bean.getConnectRetriesPerHost());
        ccProps.setReconnectRetries(bean.getReconnectRetries());
        ccProps.setReconnectRetryWaitInMillis(bean.getReconnectRetryWaitInMillis());
        if (bean.getKeepAlives().booleanValue()) {
            ccProps.setKeepAliveIntervalInMillis(bean.getKeepAliveIntervalInMillis());
        } else {
            ccProps.setKeepAliveIntervalInMillis(0);
        }
        ccProps.setKeepAliveLimit(bean.getKeepAliveCountMax());
        ccProps.setSendBuffer(bean.getSendBufferSize());
        ccProps.setReceiveBuffer(bean.getReceiveBufferSize());
        ccProps.setTcpNoDelay(bean.getTcpNoDelay());
        int compressionLevel = bean.getCompressionLevel();
        if (compressionLevel == -1) {
            compressionLevel = bean.getJNDICompressionLevel();
        }
        ccProps.setCompressionLevel(compressionLevel);
        if (bean.isSetPayloadCompressionLevel()) {
            jcsmpProps.setProperty("PAYLOAD_COMPRESSION_LEVEL", bean.getPayloadCompressionLevel());
        }
        jcsmpProps.setBooleanProperty("reapply_subscriptions", true);
        jcsmpProps.setBooleanProperty("calculate_message_expiration", true);
        if (bean.isSetLocalhost()) {
            jcsmpProps.setProperty("localhost", bean.getLocalhost());
        }
        if (bean.isSetSSLCipherSuites()) {
            jcsmpProps.setProperty("SSL_CIPHER_SUITES", bean.getSSLCipherSuites());
        }
        if (bean.isSetSSLExcludedProtocols()) {
            jcsmpProps.setProperty("SSL_EXCLUDED_PROTOCOLS", bean.getSSLExcludedProtocols());
        }
        if (bean.isSetSSLConnectionDowngradeTo()) {
            jcsmpProps.setProperty("SSL_CONNECTION_DOWNGRADE_TO", bean.getSSLConnectionDowngradeTo());
        }
        if (bean.isSetSSLProtocol()) {
            jcsmpProps.setProperty("SSL_PROTOCOL", bean.getSSLProtocol());
        }
        if (bean.isSetSSLTrustedCommonNameList()) {
            jcsmpProps.setProperty("SSL_TRUSTED_COMMON_NAME_LIST", bean.getSSLTrustedCommonNameList());
        }
        if (bean.isSetSSLTrustStore()) {
            jcsmpProps.setProperty("SSL_TRUST_STORE", bean.getSSLTrustStore());
        }
        if (bean.isSetSSLTrustStoreFormat()) {
            jcsmpProps.setProperty("SSL_TRUST_STORE_FORMAT", bean.getSSLTrustStoreFormat());
        }
        if (bean.isSetSSLTrustStorePassword()) {
            jcsmpProps.setProperty("SSL_TRUST_STORE_PASSWORD", bean.getSSLTrustStorePassword());
        }
        if (bean.isSetSSLKeyStore()) {
            jcsmpProps.setProperty("SSL_KEY_STORE", bean.getSSLKeyStore());
        }
        if (bean.isSetSSLKeyStoreFormat()) {
            jcsmpProps.setProperty("SSL_KEY_STORE_FORMAT", bean.getSSLKeyStoreFormat());
        }
        if (bean.isSetSSLKeyStoreNormalizedFormat()) {
            jcsmpProps.setProperty("SSL_KEY_STORE_NORMALIZED_FORMAT", bean.getSSLKeyStoreNormalizedFormat());
        }
        if (bean.isSetSSLKeyStorePassword()) {
            jcsmpProps.setProperty("SSL_KEY_STORE_PASSWORD", bean.getSSLKeyStorePassword());
        }
        if (bean.isSetSSLPrivateKeyAlias()) {
            jcsmpProps.setProperty("SSL_PRIVATE_KEY_ALIAS", bean.getSSLPrivateKeyAlias());
        }
        if (bean.isSetSSLPrivateKeyPassword()) {
            jcsmpProps.setProperty("SSL_PRIVATE_KEY_PASSWORD", bean.getSSLPrivateKeyPassword());
        }
        if (bean.isSetSSLValidateCertificate()) {
            jcsmpProps.setBooleanProperty("SSL_VALIDATE_CERTIFICATE", bean.getSSLValidateCertificate());
        }
        if (bean.isSetSSLValidateCertificateHost()) {
            jcsmpProps.setBooleanProperty("SSL_VALIDATE_CERTIFICATE_HOST", bean.getSSLValidateCertificateHost());
        }
        if (bean.isSetSSLValidateCertificateDate()) {
            jcsmpProps.setBooleanProperty("SSL_VALIDATE_CERTIFICATE_DATE", bean.getSSLValidateCertificateDate());
        }
        if (bean.isSetGdReconnectFailAction()) {
            jcsmpProps.setProperty("gd_reconnect_fail_action", bean.getGdReconnectFailAction());
        }
        if (bean.isSetLargeMessaging()) {
            jcsmpProps.setBooleanProperty("large_messaging", bean.getLargeMessaging());
        }
        if (bean.isSetLargeMessagingSegmentSize()) {
            jcsmpProps.setIntegerProperty("large_message_segment_size", bean.getLargeMessagingSegmentSize());
        }
        if (bean.isSetLargeMessagingMaximumSize()) {
            jcsmpProps.setIntegerProperty("large_message_max_size", bean.getLargeMessagingMaximumSize());
        }
        if (bean.isSetJaasConfigFileReloadEnabled()) {
            jcsmpProps.setBooleanProperty("JaasConfigFileReloadEnabled", bean.getJaasConfigFileReloadEnabled());
        }
        if (bean.isSetJaasLoginContext()) {
            jcsmpProps.setProperty("JaasLoginContext", bean.getJaasLoginContext());
        }
        if (bean.isSetLargeMessagingConsumeTimeoutInMillis()) {
            jcsmpProps.setIntegerProperty("large_message_consume_timeout", bean.getLargeMessagingConsumeTimeoutInMillis());
        }
        JCSMPGlobalProperties jcsmpGlobalProperties = new JCSMPGlobalProperties();
        if (bean.isSetConsumerDefaultFlowCongestionLimit()) {
            jcsmpGlobalProperties.setConsumerDefaultFlowCongestionLimit(bean.getConsumerDefaultFlowCongestionLimit());
        }
        if (bean.isSetConsumerDispatcherQueueSize()) {
            jcsmpGlobalProperties.setConsumerDispatcherQueueSize(bean.getConsumerDispatcherQueueSize());
        }
        if (bean.isSetProducerDispatcherQueueSize()) {
            jcsmpGlobalProperties.setProducerDispatcherQueueSize(bean.getProducerDispatcherQueueSize());
        }
        if (bean.isSetFrequencyManagerMaxReconnects()) {
            jcsmpGlobalProperties.setReconnectFreqManagerMaxReconnects(bean.getFrequencyManagerMaxReconnects());
        }
        if (bean.isSetOAuth2AccessToken()) {
            jcsmpProps.setProperty("OAUTH2_ACCESS_TOKEN", bean.getOAuth2AccessToken());
        }
        if (bean.isSetOidcIdToken()) {
            jcsmpProps.setProperty("OIDC_ID_TOKEN", bean.getOidcIdToken());
        }
        if (bean.isSetOauth2IssuerIdentifier()) {
            jcsmpProps.setProperty("OAUTH2_ISSUER_IDENTIFIER", bean.getOauth2IssuerIdentifier());
        }
        if (bean.isSetMessageConsumerInterceptorClassName()) {
            jcsmpProps.setProperty("Message_Consume_Interceptor_Class_Name", SolJCSMPMessageConsumerInterceptor.class.getName());
            jcsmpProps.setProperty("Message_Consume_Interceptor_Constructor_Argument", bean.getMessageConsumerInterceptorClassName());
        }
        try {
            JCSMPFactory.onlyInstance().setGlobalProperties(jcsmpGlobalProperties);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return jcsmpProps;
    }

    protected static String buildHostlist(JMSPropertyBean bean, int port) {
        String hostlist = bean.getHost();
        List<HostInfo> jcsmpHostInfo = HostInfo.toHostInfoList(hostlist);
        StringBuilder bldr = new StringBuilder();
        for (int i = 0; i < jcsmpHostInfo.size(); ++i) {
            HostInfo info = jcsmpHostInfo.get(i);
            if (i > 0) {
                bldr.append(",");
            }
            bldr.append(info.getScheme());
            bldr.append("://");
            bldr.append(info.getHost());
            if (port == 0) continue;
            bldr.append(":");
            bldr.append(port);
        }
        return bldr.toString();
    }

    @Override
    public synchronized JMSState getJMSState() {
        return this.mState;
    }

    @Override
    public void setConnectionEventListener(SolConnectionEventListener eventListener) {
        this.mConnectionEventListener = eventListener;
    }

    public ConnectionConsumer createSharedConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new UnsupportedOperationException("createSharedConnectionConsumer(Topic, String, String, ServerSessionPool, int) is not supported");
    }

    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new UnsupportedOperationException("createSharedDurableConnectionConsumer(Topic, String, String, ServerSessionPool, int) is not supported");
    }

    public jakarta.jms.Session createSession(int sessionMode) throws JMSException {
        throw new UnsupportedOperationException("createSession(int) is not supported");
    }

    public jakarta.jms.Session createSession() throws JMSException {
        throw new UnsupportedOperationException("createSession() is not supported");
    }

    static {
        JCSMPGlobalProperties.setShouldDropInternalReplyMessages(false);
    }

    private class ExceptionNotifier
    implements Callable<Void> {
        final JMSException e;

        private ExceptionNotifier(JMSException e) {
            this.e = e;
        }

        @Override
        public Void call() throws Exception {
            ExceptionListener listener = SolConnection.this.mListener;
            if (listener != null) {
                try {
                    listener.onException(this.e);
                }
                catch (Exception e) {
                    if (SolConnection.this.log.isErrorEnabled()) {
                        SolConnection.this.log.error("Error by handling of async exception notification", e);
                    }
                }
            } else if (SolConnection.this.log.isWarnEnabled()) {
                SolConnection.this.log.error("Async exception with no exception listener:", this.e);
            }
            return null;
        }
    }
}

