/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.Consumer;
import com.solacesystems.jcsmp.Endpoint;
import com.solacesystems.jcsmp.FlowReceiver;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.impl.flow.FlowHandleImpl;
import com.solacesystems.jms.SolConsumerEventListener;
import com.solacesystems.jms.SolConsumerEventSource;
import com.solacesystems.jms.SolMessageConsumerIF;
import com.solacesystems.jms.SolSession;
import com.solacesystems.jms.SolSessionIF;
import com.solacesystems.jms.encoding.JMSDecoder;
import com.solacesystems.jms.impl.ConsumerFactory;
import com.solacesystems.jms.impl.JCSMPMessageListener;
import com.solacesystems.jms.impl.JMSState;
import com.solacesystems.jms.impl.SessionProperties;
import com.solacesystems.jms.impl.Validator;
import com.solacesystems.jms.message.SolMessage;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;

public abstract class SolMessageConsumer
implements SolMessageConsumerIF,
SolConsumerEventSource {
    private final LogWrapper log = new LogWrapper(SolMessageConsumer.class);
    protected static final String Component = "MessageConsumer";
    protected SolSessionIF mSession;
    protected SessionProperties mSessionProps;
    public Consumer mConsumer;
    protected Endpoint mEndpoint;
    protected Destination mDestination;
    protected String mMessageSelector;
    protected boolean mNoLocal;
    protected JCSMPMessageListener mListener;
    protected JMSState mState;
    protected boolean mDurable;
    protected ConsumerFactory mConsumerFac;
    protected SolConsumerEventListener mConsumerEventListener = null;
    protected volatile DelayStartStatus mDelayStartRequested;

    protected SolMessageConsumer(SolSessionIF session, Destination destination, String messageSelector, boolean noLocal, JMSState state, boolean durable) {
        this.mSession = session;
        this.mSessionProps = session.getProperties();
        this.mConsumer = null;
        this.mEndpoint = null;
        this.mDestination = destination;
        this.mMessageSelector = messageSelector;
        this.mNoLocal = noLocal;
        this.mListener = new JCSMPMessageListener(this.mSessionProps.getAckHandler(), this.mSessionProps.getConnectionProperties().getExceptionListener());
        this.mState = state;
        this.mDurable = durable;
        this.mConsumerFac = new ConsumerFactory(messageSelector, noLocal, this.mSessionProps, null, this.mSession);
        boolean canUseDelayedStart = this.mSessionProps.getConnectionProperties().getPropertyBean().getDirectTransport() == false || this.mDurable;
        Boolean delayedStartOverride = this.mSessionProps.getConnectionProperties().getPropertyBean().getDelayedStartOverride();
        this.mDelayStartRequested = canUseDelayedStart && (delayedStartOverride == null || delayedStartOverride != false) ? DelayStartStatus.UNINITIALIZED : DelayStartStatus.DONE;
        if (this.log.isDebugEnabled()) {
            this.log.debug("SolMessageConsumer created.  Destination: " + destination + "  messageSelector: " + messageSelector + "   noLocal: " + noLocal + "   state: " + (Object)((Object)state) + "   durable: " + durable);
        }
    }

    protected String getLogContextInfo() {
        if (this.mConsumer != null && this.mConsumer instanceof FlowHandleImpl) {
            return ((FlowHandleImpl)this.mConsumer).getLogContextInfo();
        }
        if (this.mSession instanceof SolSession) {
            return ((SolSession)this.mSession).getLogContextInfo();
        }
        return "";
    }

    protected void updateLogContextInfo() {
        this.log.setContextInfo(this.getLogContextInfo());
    }

    protected void setDelayStartRequested() {
        if (this.mDelayStartRequested == DelayStartStatus.UNINITIALIZED) {
            this.mDelayStartRequested = DelayStartStatus.REQUESTED;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Message Consumer start delay requested.");
            }
        }
    }

    protected void clearDelayStartRequested() {
        if (this.mDelayStartRequested == DelayStartStatus.REQUESTED) {
            this.mDelayStartRequested = DelayStartStatus.UNINITIALIZED;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Message Consumer start delay request canceled.");
            }
        }
    }

    protected void processDelayStart() throws JMSException {
        switch (this.mDelayStartRequested) {
            case DONE: {
                return;
            }
            case REQUESTED: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Processing delayed start.");
                }
                this.startImpl();
                break;
            }
        }
        this.mDelayStartRequested = DelayStartStatus.DONE;
    }

    @Override
    public Endpoint getEndpoint() {
        return this.mEndpoint;
    }

    @Override
    public boolean isDurable() {
        return this.mDurable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws JMSException {
        SolMessageConsumer solMessageConsumer = this;
        synchronized (solMessageConsumer) {
            if (this.mConsumer != null) {
                try {
                    this.mConsumer.closeSync();
                }
                catch (JCSMPException e) {
                    throw Validator.createJMSException("soljms.operation.close", e);
                }
            }
            this.mState = JMSState.Closed;
        }
        this.mSession.remove(this);
        if (this.log.isDebugEnabled()) {
            this.log.debug("SolMessageConsumer (destination: " + this.mDestination + ") closed.");
        }
    }

    @Override
    public boolean getNoLocal() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        return this.mNoLocal;
    }

    public MessageListener getMessageListener() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        return this.mListener.getMessageListener();
    }

    public String getMessageSelector() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        return this.mMessageSelector;
    }

    public Message receive() throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering receive()");
        }
        this.processDelayStart();
        try {
            BytesXMLMessage xmlMessage = this.mConsumer.receive();
            SolMessage jmsMessage = this.createMessage(xmlMessage);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Leaving receive()");
            }
            return jmsMessage;
        }
        catch (Throwable e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Leaving receive() : throwing exception." + e);
            }
            if (e instanceof JCSMPException && Validator.wasConsumerClosedInReceive((JCSMPException)e)) {
                return null;
            }
            throw Validator.createJMSException("soljms.operation.recv", e);
        }
    }

    public Message receive(long timeout) throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering receive(), timeout: " + timeout);
        }
        this.processDelayStart();
        try {
            BytesXMLMessage xmlMessage = this.mConsumer.receive((int)timeout);
            SolMessage jmsMessage = this.createMessage(xmlMessage);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Leaving receive()");
            }
            return jmsMessage;
        }
        catch (Throwable e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Leaving receive() : throwing exception" + e);
            }
            if (e instanceof JCSMPException && Validator.wasConsumerClosedInReceive((JCSMPException)e)) {
                return null;
            }
            throw Validator.createJMSException("soljms.operation.recv", e);
        }
    }

    public Message receiveNoWait() throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering receiveNoWait()");
        }
        this.processDelayStart();
        try {
            BytesXMLMessage xmlMessage = this.mConsumer.receiveNoWait();
            SolMessage jmsMessage = this.createMessage(xmlMessage);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Leaving receiveNoWait()");
            }
            return jmsMessage;
        }
        catch (Throwable e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Leaving receive() : throwing exception.");
            }
            if (e instanceof JCSMPException && Validator.wasConsumerClosedInReceive((JCSMPException)e)) {
                return null;
            }
            throw Validator.createJMSException("soljms.operation.recv", e);
        }
    }

    @Override
    public void recover() throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering recover().");
        }
        Validator.checkClosed(this.mState, Component);
        try {
            if (this.mConsumer != null) {
                if (this.mConsumer instanceof FlowReceiver) {
                    ((FlowReceiver)this.mConsumer).closeSync(true);
                } else {
                    this.mConsumer.closeSync();
                }
                this.mConsumer = null;
            }
        }
        catch (JCSMPException e) {
            throw Validator.createJMSException("soljms.operation.close", e);
        }
        this.createConsumer();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving recover()");
        }
    }

    public void startImpl() throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering startImpl()");
        }
        Validator.checkClosed(this.mState, Component);
        if (this.mConsumer != null) {
            try {
                this.mConsumer.startSync();
                this.mState = JMSState.Started;
            }
            catch (JCSMPException e) {
                JMSException jmsEx = Validator.createJMSException("soljms.operation.consumer.start", e);
                throw jmsEx;
            }
        } else {
            this.mState = JMSState.Started;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving startImpl().  State is now " + (Object)((Object)this.mState));
        }
    }

    @Override
    public void start() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering start().");
        }
        switch (this.mDelayStartRequested) {
            case REQUESTED: 
            case UNINITIALIZED: {
                this.setDelayStartRequested();
                break;
            }
            case DONE: {
                this.startImpl();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving start().");
        }
    }

    @Override
    public void stop() throws JMSException {
        if (this.stopSyncStart()) {
            this.stopSyncWait();
        }
    }

    @Override
    public boolean stopSyncStart() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering stop().");
        }
        this.clearDelayStartRequested();
        if (this.mConsumer != null) {
            this.mState = JMSState.Stopping;
            return this.mConsumer.stopSyncStart();
        }
        this.mState = JMSState.Stopped;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving stop().  SolMessageConsumer state is now " + (Object)((Object)this.mState));
        }
        return false;
    }

    @Override
    public void stopSyncWait() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        try {
            if (this.mConsumer != null) {
                this.mConsumer.stopSyncWait();
            }
        }
        catch (JCSMPException e) {
            throw Validator.createJMSException("soljms.operation.close", e);
        }
        this.mState = JMSState.Stopped;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving stop().  SolMessageConsumer state is now " + (Object)((Object)this.mState));
        }
    }

    protected void createConsumer() throws JMSException {
        if (this.mState == JMSState.Started) {
            this.start();
        }
    }

    protected SolMessage createMessage(BytesXMLMessage xmlMessage) throws JMSException {
        if (xmlMessage != null) {
            SolMessage jmsMessage = JMSDecoder.createJMSMessage(xmlMessage);
            jmsMessage.setAckHandler(this.mSessionProps.getAckHandler());
            this.mSessionProps.getAckHandler().onMessageCreate(jmsMessage);
            this.mSessionProps.getAckHandler().onMessageSent(jmsMessage);
            return jmsMessage;
        }
        return null;
    }

    @Override
    public void setSolConsumerEventListener(SolConsumerEventListener listener) {
        this.mConsumerEventListener = listener;
    }

    private static enum DelayStartStatus {
        UNINITIALIZED,
        REQUESTED,
        DONE;

    }
}

