/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.impl;

import com.solacesystems.jcsmp.Consumer;
import com.solacesystems.jcsmp.ConsumerFlowProperties;
import com.solacesystems.jcsmp.Endpoint;
import com.solacesystems.jcsmp.EndpointProperties;
import com.solacesystems.jcsmp.FlowEventHandler;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.Queue;
import com.solacesystems.jcsmp.Subscription;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.XMLMessageListener;
import com.solacesystems.jcsmp.impl.TopicImpl;
import com.solacesystems.jcsmp.protocol.nio.impl.ConsumerNotificationDispatcherFactory;
import com.solacesystems.jms.ConfigurationException;
import com.solacesystems.jms.SolConnectionIF;
import com.solacesystems.jms.SolSessionIF;
import com.solacesystems.jms.impl.ConnectionProperties;
import com.solacesystems.jms.impl.CustomLogger;
import com.solacesystems.jms.impl.JCSMPConsumerFactory;
import com.solacesystems.jms.impl.SessionProperties;
import com.solacesystems.jms.impl.SolJMSErrorMessages;
import com.solacesystems.jms.impl.Validator;
import jakarta.jms.JMSException;

public class ConsumerFactory {
    private static final CustomLogger log = new CustomLogger(ConsumerFactory.class);
    private boolean mNoLocal;
    private String mMessageSelector;
    private SessionProperties mSessionProps;
    private SolConnectionIF mConnection;
    private SolSessionIF mSession;

    public ConsumerFactory(String messageSelector, boolean noLocal, SessionProperties sessionProps, SolConnectionIF conn, SolSessionIF session) {
        this.mNoLocal = noLocal;
        this.mMessageSelector = messageSelector;
        this.mSessionProps = sessionProps;
        this.mConnection = conn;
        this.mSession = session;
        if (this.mSession == null && this.mConnection == null) {
            throw new IllegalArgumentException("Must provide one of session or connection to allow creating default connection subscriber.");
        }
    }

    public Consumer createDurableConsumer(Queue jcsmpQueue, XMLMessageListener listener, JCSMPConsumerFactory jcsmpFac) throws JMSException, JCSMPException {
        return this.createDurableConsumer(jcsmpQueue, listener, null, jcsmpFac);
    }

    public Consumer createDurableConsumer(Queue jcsmpQueue, XMLMessageListener listener, FlowEventHandler flowEventHandler, JCSMPConsumerFactory jcsmpFac) throws JMSException, JCSMPException {
        ConsumerFlowProperties flowProps = new ConsumerFlowProperties();
        flowProps.setEndpoint(jcsmpQueue);
        flowProps.setSelector(Validator.checkSelector(this.mMessageSelector));
        flowProps.setNoLocal(this.mNoLocal);
        if (flowEventHandler != null) {
            flowProps.setActiveFlowIndication(true);
        }
        ConsumerNotificationDispatcherFactory factory = (ConsumerNotificationDispatcherFactory)((Object)this.mSessionProps.getUserProperties().get("ConsumerDispatcherFactory"));
        flowProps.setConsumerNotificationDispatcherFactory(factory);
        if (this.mSessionProps.getConnectionProperties().getCFPropertyBean().isSetReceiveReconnectRetries()) {
            flowProps.setReconnectTries(this.mSessionProps.getConnectionProperties().getCFPropertyBean().getReceiveReconnectRetries());
        }
        if (this.mSessionProps.getConnectionProperties().getCFPropertyBean().isSetReceiveReconnectRetryWaitInMillis()) {
            flowProps.setReconnectRetryIntervalInMsecs(this.mSessionProps.getConnectionProperties().getCFPropertyBean().getReceiveReconnectRetryWaitInMillis());
        }
        log.debug("Creating durable consumer for queue " + jcsmpQueue.getName());
        return jcsmpFac.createDurableJCSMPConsumer(this.mSessionProps, listener, flowEventHandler, flowProps);
    }

    public Consumer createNonDurableConsumer(Queue jcsmpQueue, XMLMessageListener listener, JCSMPConsumerFactory jcsmpFac) throws JMSException, JCSMPException {
        return this.createNonDurableConsumer(jcsmpQueue, listener, null, jcsmpFac);
    }

    public Consumer createNonDurableConsumer(Queue jcsmpQueue, XMLMessageListener listener, FlowEventHandler flowEventHandler, JCSMPConsumerFactory jcsmpFac) throws JMSException, JCSMPException {
        boolean direct = this.mSessionProps.getConnectionProperties().getPropertyBean().getDirectTransport();
        log.debug("Creating non-durable consumer for queue " + jcsmpQueue.getName() + "   Direct: " + direct);
        if (direct) {
            if (this.mMessageSelector != null && this.mMessageSelector.length() > 0) {
                throw new ConfigurationException(SolJMSErrorMessages.getMessage("soljms.operation.consumer.create", "soljms.error.selectordirectmismatch", null), "soljms.error.selectordirectmismatch");
            }
            if (this.mNoLocal) {
                throw new ConfigurationException(SolJMSErrorMessages.getMessage("soljms.operation.consumer.create", "soljms.error.nolocaldirectmismatch", null), "soljms.error.nolocaldirectmismatch");
            }
            Topic topic = TopicImpl.createWithInit(jcsmpQueue.getName(), this.mSessionProps.getConnectionProperties().getPropertyBean().getDeliverToOneOverride(), false);
            if (this.mConnection != null) {
                this.mConnection.createDefaultSubscriber();
            } else if (this.mSession != null) {
                this.mSession.createDefaultSubscriber();
            }
            ConsumerNotificationDispatcherFactory factory = (ConsumerNotificationDispatcherFactory)((Object)this.mSessionProps.getUserProperties().get("ConsumerDispatcherFactory"));
            return this.mSessionProps.getConnectionProperties().getJCSMPSession().addSubscription((Subscription)topic, listener, factory);
        }
        ConsumerFlowProperties flowProps = new ConsumerFlowProperties();
        flowProps.setEndpoint(jcsmpQueue);
        flowProps.setSelector(Validator.checkSelector(this.mMessageSelector));
        flowProps.setNoLocal(this.mNoLocal);
        if (flowEventHandler != null) {
            flowProps.setActiveFlowIndication(true);
        }
        ConsumerNotificationDispatcherFactory factory = (ConsumerNotificationDispatcherFactory)((Object)this.mSessionProps.getUserProperties().get("ConsumerDispatcherFactory"));
        flowProps.setConsumerNotificationDispatcherFactory(factory);
        if (this.mSessionProps.getConnectionProperties().getCFPropertyBean().isSetReceiveReconnectRetries()) {
            flowProps.setReconnectTries(this.mSessionProps.getConnectionProperties().getCFPropertyBean().getReceiveReconnectRetries());
        }
        if (this.mSessionProps.getConnectionProperties().getCFPropertyBean().isSetReceiveReconnectRetryWaitInMillis()) {
            flowProps.setReconnectRetryIntervalInMsecs(this.mSessionProps.getConnectionProperties().getCFPropertyBean().getReceiveReconnectRetryWaitInMillis());
        }
        EndpointProperties endpointProps = new EndpointProperties();
        endpointProps.setRespectsMsgTTL(this.mSessionProps.getConnectionProperties().getPropertyBean().getRespectTTL());
        return jcsmpFac.createNonDurableJCSMPConsumer(this.mSessionProps, listener, flowEventHandler, flowProps, endpointProps);
    }

    public Consumer createDurableConsumer(Topic topic, XMLMessageListener listener, Endpoint epoint, JCSMPConsumerFactory jcsmpFac) throws JMSException, JCSMPException {
        return this.createDurableConsumer(topic, listener, null, epoint, jcsmpFac);
    }

    public Consumer createDurableConsumer(Topic topic, XMLMessageListener listener, FlowEventHandler flowEventHandler, Endpoint epoint, JCSMPConsumerFactory jcsmpFac) throws JMSException, JCSMPException {
        ConnectionProperties connProps = this.mSessionProps.getConnectionProperties();
        ConsumerFlowProperties flowProps = new ConsumerFlowProperties();
        if (this.mSessionProps.getConnectionProperties().getPropertyBean().getDynamicDurables().booleanValue()) {
            EndpointProperties endpointProps = new EndpointProperties();
            endpointProps.setRespectsMsgTTL(connProps.getPropertyBean().getRespectTTL());
            try {
                connProps.getJCSMPSession().provision(epoint, endpointProps, 1L);
            }
            catch (JCSMPException jCSMPException) {
                // empty catch block
            }
        }
        flowProps.setEndpoint(epoint);
        flowProps.setNewSubscription(topic);
        flowProps.setSelector(Validator.checkSelector(this.mMessageSelector));
        flowProps.setNoLocal(this.mNoLocal);
        if (flowEventHandler != null) {
            flowProps.setActiveFlowIndication(true);
        }
        if (this.mSessionProps.getConnectionProperties().getCFPropertyBean().isSetReceiveReconnectRetries()) {
            flowProps.setReconnectTries(this.mSessionProps.getConnectionProperties().getCFPropertyBean().getReceiveReconnectRetries());
        }
        if (this.mSessionProps.getConnectionProperties().getCFPropertyBean().isSetReceiveReconnectRetryWaitInMillis()) {
            flowProps.setReconnectRetryIntervalInMsecs(this.mSessionProps.getConnectionProperties().getCFPropertyBean().getReceiveReconnectRetryWaitInMillis());
        }
        ConsumerNotificationDispatcherFactory factory = (ConsumerNotificationDispatcherFactory)((Object)this.mSessionProps.getUserProperties().get("ConsumerDispatcherFactory"));
        flowProps.setConsumerNotificationDispatcherFactory(factory);
        log.debug("Creating durable consumer for topic: " + topic.getName() + "   endpoint: " + epoint.getName());
        return jcsmpFac.createDurableJCSMPConsumer(this.mSessionProps, listener, flowEventHandler, flowProps);
    }

    public Consumer createNonDurableConsumer(Topic topic, XMLMessageListener listener, Endpoint epoint, JCSMPConsumerFactory jcsmpFac) throws JMSException, JCSMPException {
        return this.createNonDurableConsumer(topic, listener, null, epoint, jcsmpFac);
    }

    public Consumer createNonDurableConsumer(Topic topic, XMLMessageListener listener, FlowEventHandler flowEventHandler, Endpoint epoint, JCSMPConsumerFactory jcsmpFac) throws JMSException, JCSMPException {
        ConnectionProperties connProps = this.mSessionProps.getConnectionProperties();
        boolean direct = connProps.getPropertyBean().getDirectTransport();
        log.debug("Creating non durable consumer for topic " + topic.getName() + " endpoint: " + (epoint == null ? null : epoint.getName()) + "   direct: " + direct);
        if (direct) {
            if (this.mMessageSelector != null && this.mMessageSelector.length() > 0) {
                throw new ConfigurationException(SolJMSErrorMessages.getMessage("soljms.operation.consumer.create", "soljms.error.selectordirectmismatch", null), "soljms.error.selectordirectmismatch");
            }
            if (this.mNoLocal) {
                throw new ConfigurationException(SolJMSErrorMessages.getMessage("soljms.operation.consumer.create", "soljms.error.nolocaldirectmismatch", null), "soljms.error.nolocaldirectmismatch");
            }
            if (this.mConnection != null) {
                this.mConnection.createDefaultSubscriber();
            } else if (this.mSession != null) {
                this.mSession.createDefaultSubscriber();
            }
            Topic topicCopy = TopicImpl.createWithInit(topic.getName(), connProps.getPropertyBean().getDeliverToOneOverride(), topic.isTemporary());
            ConsumerNotificationDispatcherFactory factory = (ConsumerNotificationDispatcherFactory)((Object)this.mSessionProps.getUserProperties().get("ConsumerDispatcherFactory"));
            return connProps.getJCSMPSession().addSubscription((Subscription)topicCopy, listener, factory);
        }
        ConsumerFlowProperties flowProps = new ConsumerFlowProperties();
        flowProps.setEndpoint(epoint);
        flowProps.setNewSubscription(topic);
        flowProps.setSelector(Validator.checkSelector(this.mMessageSelector));
        flowProps.setNoLocal(this.mNoLocal);
        if (flowEventHandler != null) {
            flowProps.setActiveFlowIndication(true);
        }
        if (this.mSessionProps.getConnectionProperties().getCFPropertyBean().isSetReceiveReconnectRetries()) {
            flowProps.setReconnectTries(this.mSessionProps.getConnectionProperties().getCFPropertyBean().getReceiveReconnectRetries());
        }
        if (this.mSessionProps.getConnectionProperties().getCFPropertyBean().isSetReceiveReconnectRetryWaitInMillis()) {
            flowProps.setReconnectRetryIntervalInMsecs(this.mSessionProps.getConnectionProperties().getCFPropertyBean().getReceiveReconnectRetryWaitInMillis());
        }
        ConsumerNotificationDispatcherFactory factory = (ConsumerNotificationDispatcherFactory)((Object)this.mSessionProps.getUserProperties().get("ConsumerDispatcherFactory"));
        flowProps.setConsumerNotificationDispatcherFactory(factory);
        EndpointProperties endpointProps = new EndpointProperties();
        endpointProps.setRespectsMsgTTL(connProps.getPropertyBean().getRespectTTL());
        return jcsmpFac.createNonDurableJCSMPConsumer(this.mSessionProps, listener, flowEventHandler, flowProps, endpointProps);
    }
}

