/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.jms.SolConnectionFactoryImpl;
import com.solacesystems.jms.SolXAConnection;
import com.solacesystems.jms.SolXAConnectionFactory;
import com.solacesystems.jms.SolXAQueueConnection;
import com.solacesystems.jms.SolXATopicConnection;
import com.solacesystems.jms.impl.Validator;
import com.solacesystems.jms.property.JMSProperties;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XATopicConnection;

public class SolXAConnectionFactoryImpl
extends SolConnectionFactoryImpl
implements SolXAConnectionFactory {
    private static final long serialVersionUID = 1L;

    public SolXAConnectionFactoryImpl(JMSProperties properties) {
        super(properties);
        this.setXA(Boolean.TRUE);
    }

    public XAConnection createXAConnection() throws JMSException {
        Validator.checkClientId(this.mBean.getJNDIClientID(), this.mBean.getClientID());
        return new SolXAConnection(this.mProperties);
    }

    public XAConnection createXAConnection(String userName, String password) throws JMSException {
        Validator.checkClientId(this.mBean.getJNDIClientID(), this.mBean.getClientID());
        return new SolXAConnection(this.mProperties, userName, password);
    }

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        Validator.checkClientId(this.mBean.getJNDIClientID(), this.mBean.getClientID());
        return new SolXAQueueConnection(this.mProperties);
    }

    public XAQueueConnection createXAQueueConnection(String userName, String password) throws JMSException {
        Validator.checkClientId(this.mBean.getJNDIClientID(), this.mBean.getClientID());
        return new SolXAQueueConnection(this.mProperties, userName, password);
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        Validator.checkClientId(this.mBean.getJNDIClientID(), this.mBean.getClientID());
        return new SolXATopicConnection(this.mProperties);
    }

    public XATopicConnection createXATopicConnection(String userName, String password) throws JMSException {
        Validator.checkClientId(this.mBean.getJNDIClientID(), this.mBean.getClientID());
        return new SolXATopicConnection(this.mProperties, userName, password);
    }

    public Object clone() throws CloneNotSupportedException {
        return new SolXAConnectionFactoryImpl(this.mProperties);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SolXAConnectionFactory) {
            SolXAConnectionFactory other = (SolXAConnectionFactory)obj;
            for (String name : this.getPropertyNames()) {
                Object value = this.getProperty(name);
                Object otherValue = other.getProperty(name);
                if (!(value == null ? otherValue != null : !value.equals(otherValue))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

