/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.util;

import com.solacesystems.common.util.Base64;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class CipherUtil {
    private static byte[] ALGRM = new byte[]{81, 85, 86, 84};
    private Cipher encryptingCipher;
    private Cipher decryptingCipher;

    public CipherUtil(SecretKey secretkey) throws GeneralSecurityException {
        this.init(secretkey);
    }

    public CipherUtil(byte[] key) throws GeneralSecurityException {
        this.init(new SecretKeySpec(key, this.getAlgrm()));
    }

    private String getAlgrm() {
        return new String(Base64.decode(new String(ALGRM)));
    }

    private void init(SecretKey secretkey) throws GeneralSecurityException {
        this.encryptingCipher = Cipher.getInstance(this.getAlgrm());
        this.encryptingCipher.init(1, secretkey);
        this.decryptingCipher = Cipher.getInstance(this.getAlgrm());
        this.decryptingCipher.init(2, secretkey);
    }

    public Cipher getEncryptingCipher() {
        return this.encryptingCipher;
    }

    public Cipher getDecryptingCipher() {
        return this.decryptingCipher;
    }
}

